/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.controls.AffinityControl;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlsTestCase;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AffinityControlTestCase
extends ControlsTestCase {
    @Test
    public void testControl() throws Exception {
        SearchRequest req = Requests.newSearchRequest((DN)DN.valueOf((String)"uid=user.1,ou=people,o=test"), (SearchScope)SearchScope.BASE_OBJECT, (Filter)Filter.objectClassPresent(), (String[])new String[0]);
        AffinityControl control = AffinityControl.newControl((ByteString)ByteString.valueOfUtf8((CharSequence)"value"), (boolean)false);
        req.addControl((Control)control);
        try (Connection con = TestCaseUtils.getInternalConnection();){
            ArrayList entries = new ArrayList();
            con.search(req, entries);
            Assertions.assertThat(entries).hasAtLeastOneElementOfType(SearchResultEntry.class);
            SearchResultEntry entry = (SearchResultEntry)entries.get(0);
            Assertions.assertThat((List)entry.getControls()).hasSize(0);
        }
    }

    @Test
    public void testControlGeneratesRandomValue() throws Exception {
        AffinityControl control = AffinityControl.newControl((boolean)true);
        Assert.assertTrue((boolean)control.isCritical());
        ByteString value1 = control.getAffinityValue();
        Assertions.assertThat((Comparable)value1).isNotNull();
        Assertions.assertThat((int)value1.length()).isNotZero();
        AffinityControl control2 = AffinityControl.newControl((boolean)false);
        ByteString value2 = control2.getAffinityValue();
        Assert.assertFalse((boolean)control2.isCritical());
        Assertions.assertThat((Comparable)value2).isNotNull();
        Assertions.assertThat((int)value2.length()).isNotZero();
        Assertions.assertThat((Comparable)value1).isNotEqualTo((Object)value2);
    }
}

