/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.TemplateFile;
import org.forgerock.util.Reject;

public final class EntryGenerator
implements EntryReader {
    private static final int DEFAULT_RANDOM_SEED = 1;
    private TemplateFile templateFile;
    private final List<LocalizableMessage> warnings = new LinkedList<LocalizableMessage>();
    private boolean isClosed;
    private boolean isInitialized;
    private int randomSeed = 1;
    private String resourcePath;
    private Schema schema;
    private String templatePath;
    private String[] templateLines;
    private InputStream templateStream;
    private boolean generateBranches = true;
    private Map<String, String> constants = new HashMap<String, String>();

    public EntryGenerator() {
    }

    public EntryGenerator(String templatePath) {
        Reject.ifNull((Object)templatePath);
        this.templatePath = templatePath;
    }

    public EntryGenerator(String ... templateLines) {
        Reject.ifNull((Object[])templateLines);
        this.templateLines = templateLines;
    }

    public EntryGenerator(List<String> templateLines) {
        Reject.ifNull(templateLines);
        this.templateLines = templateLines.toArray(new String[templateLines.size()]);
    }

    public EntryGenerator(InputStream templateStream) {
        Reject.ifNull((Object)templateStream);
        this.templateStream = templateStream;
    }

    public EntryGenerator setRandomSeed(int seed) {
        this.randomSeed = seed;
        return this;
    }

    public EntryGenerator setResourcePath(String path) {
        Reject.ifNull((Object)path);
        this.resourcePath = path;
        return this;
    }

    public EntryGenerator setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public EntryGenerator setConstant(String name, Object value) {
        this.constants.put(name, value.toString());
        return this;
    }

    public EntryGenerator setGenerateBranches(boolean generateBranches) {
        this.generateBranches = generateBranches;
        return this;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<LocalizableMessage> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.isClosed) {
            return false;
        }
        this.ensureGeneratorIsInitialized();
        return this.templateFile.hasNext();
    }

    @Override
    public Entry readEntry() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.templateFile.nextEntry();
    }

    private void ensureGeneratorIsInitialized() throws IOException {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.initialize();
        }
    }

    private void initialize() throws IOException {
        if (this.schema == null) {
            this.schema = Schema.getDefaultSchema();
        }
        this.templateFile = new TemplateFile(this.schema, this.constants, this.resourcePath, new Random(this.randomSeed), this.generateBranches);
        try {
            if (this.templatePath != null) {
                this.templateFile.parse(this.templatePath, this.warnings);
            } else if (this.templateLines != null) {
                this.templateFile.parse(this.templateLines, this.warnings);
            } else if (this.templateStream != null) {
                this.templateFile.parse(this.templateStream, this.warnings);
            } else {
                this.templateFile.parse(this.warnings);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_EXCEPTION_DURING_PARSE.get((Object)e.getMessage()), e);
        }
    }
}

