/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class NumericStringSyntaxImpl
extends AbstractSyntaxImpl {
    NumericStringSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.8";
    }

    @Override
    public String getName() {
        return "NumericString";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.9";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.7";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueString = value.toString();
        int length = valueString.length();
        if (length == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_NUMERIC_STRING_EMPTY_VALUE.get());
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = valueString.charAt(i);
            if (StaticUtils.isDigit(c) || c == ' ') continue;
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_NUMERIC_STRING_ILLEGAL_CHAR.get((Object)valueString, (Object)String.valueOf(c), (Object)i));
            return false;
        }
        return true;
    }
}

