/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class BitStringSyntaxImpl
extends AbstractSyntaxImpl {
    BitStringSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.16";
    }

    @Override
    public String getName() {
        return "BitString";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueString = value.toString().toUpperCase();
        int length = valueString.length();
        if (length < 3) {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_TOO_SHORT.get((Object)value.toString()));
            return false;
        }
        if (valueString.charAt(0) != '\'' || valueString.charAt(length - 2) != '\'' || valueString.charAt(length - 1) != 'B') {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_NOT_QUOTED.get((Object)value.toString()));
            return false;
        }
        block3: for (int i = 1; i < length - 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': {
                    continue block3;
                }
                default: {
                    invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_INVALID_BIT.get((Object)value.toString(), (Object)String.valueOf(valueString.charAt(i))));
                    return false;
                }
            }
        }
        return true;
    }
}

