/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.AbstractResponseImpl;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.util.Reject;

abstract class AbstractResultImpl<S extends Result>
extends AbstractResponseImpl<S>
implements Result {
    private Throwable cause;
    private String diagnosticMessage = "";
    private String matchedDN = "";
    private final List<String> referralURIs = new LinkedList<String>();
    private ResultCode resultCode;

    AbstractResultImpl(Result result) {
        super(result);
        this.cause = result.getCause();
        this.diagnosticMessage = result.getDiagnosticMessage();
        this.matchedDN = result.getMatchedDN();
        this.referralURIs.addAll(result.getReferralURIs());
        this.resultCode = result.getResultCode();
    }

    AbstractResultImpl(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    public final S addReferralURI(String uri) {
        Reject.ifNull((Object)uri);
        this.referralURIs.add(uri);
        return (S)((Result)this.getThis());
    }

    @Override
    public final Throwable getCause() {
        return this.cause;
    }

    @Override
    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Override
    public final String getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    public final List<String> getReferralURIs() {
        return this.referralURIs;
    }

    @Override
    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public final boolean isReferral() {
        ResultCode code = this.getResultCode();
        return code.equals(ResultCode.REFERRAL);
    }

    @Override
    public final boolean isSuccess() {
        ResultCode code = this.getResultCode();
        return !code.isExceptional();
    }

    public final S setCause(Throwable cause) {
        this.cause = cause;
        return (S)((Result)this.getThis());
    }

    public final S setDiagnosticMessage(String message) {
        this.diagnosticMessage = message != null ? message : "";
        return (S)((Result)this.getThis());
    }

    public final S setMatchedDN(String dn) {
        this.matchedDN = dn != null ? dn : "";
        return (S)((Result)this.getThis());
    }

    public final S setResultCode(ResultCode resultCode) {
        Reject.ifNull((Object)resultCode);
        this.resultCode = resultCode;
        return (S)((Result)this.getThis());
    }
}

