/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Collections2;
import java.util.Collection;
import java.util.Collections;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;

public final class RootDSE {
    private static final AttributeDescription ATTR_ALT_SERVER = AttributeDescription.create(CoreSchema.getAltServerAttributeType());
    private static final AttributeDescription ATTR_NAMING_CONTEXTS = AttributeDescription.create(CoreSchema.getNamingContextsAttributeType());
    private static final AttributeDescription ATTR_SUBSCHEMA_SUBENTRY = AttributeDescription.create(CoreSchema.getSubschemaSubentryAttributeType());
    private static final AttributeDescription ATTR_SUPPORTED_AUTH_PASSWORD_SCHEMES = AttributeDescription.create(CoreSchema.getSupportedAuthPasswordSchemesAttributeType());
    private static final AttributeDescription ATTR_SUPPORTED_CONTROL = AttributeDescription.create(CoreSchema.getSupportedControlAttributeType());
    private static final AttributeDescription ATTR_SUPPORTED_EXTENSION = AttributeDescription.create(CoreSchema.getSupportedExtensionAttributeType());
    private static final AttributeDescription ATTR_SUPPORTED_FEATURE = AttributeDescription.create(CoreSchema.getSupportedFeaturesAttributeType());
    private static final AttributeDescription ATTR_SUPPORTED_LDAP_VERSION = AttributeDescription.create(CoreSchema.getSupportedLDAPVersionAttributeType());
    private static final AttributeDescription ATTR_SUPPORTED_SASL_MECHANISMS = AttributeDescription.create(CoreSchema.getSupportedSASLMechanismsAttributeType());
    private static final AttributeDescription ATTR_VENDOR_NAME = AttributeDescription.create(CoreSchema.getVendorNameAttributeType());
    private static final AttributeDescription ATTR_VENDOR_VERSION = AttributeDescription.create(CoreSchema.getVendorNameAttributeType());
    private static final AttributeDescription ATTR_FULL_VENDOR_VERSION = AttributeDescription.create(CoreSchema.getFullVendorVersionAttributeType());
    private static final SearchRequest SEARCH_REQUEST = Requests.newSearchRequest(DN.rootDN(), SearchScope.BASE_OBJECT, Filter.objectClassPresent(), ATTR_ALT_SERVER.toString(), ATTR_NAMING_CONTEXTS.toString(), ATTR_SUPPORTED_CONTROL.toString(), ATTR_SUPPORTED_EXTENSION.toString(), ATTR_SUPPORTED_FEATURE.toString(), ATTR_SUPPORTED_LDAP_VERSION.toString(), ATTR_SUPPORTED_SASL_MECHANISMS.toString(), ATTR_FULL_VENDOR_VERSION.toString(), ATTR_VENDOR_NAME.toString(), ATTR_VENDOR_VERSION.toString(), ATTR_SUPPORTED_AUTH_PASSWORD_SCHEMES.toString(), ATTR_SUBSCHEMA_SUBENTRY.toString(), "*");
    private final Entry entry;

    public static LdapPromise<RootDSE> readRootDSEAsync(Connection connection, LdapResultHandler<? super RootDSE> handler) {
        return connection.searchSingleEntryAsync(SEARCH_REQUEST).then(new Function<SearchResultEntry, RootDSE, LdapException>(){

            public RootDSE apply(SearchResultEntry result) {
                return RootDSE.valueOf(result);
            }
        });
    }

    public static RootDSE readRootDSE(Connection connection) throws LdapException {
        SearchResultEntry entry = connection.searchSingleEntry(SEARCH_REQUEST);
        return RootDSE.valueOf(entry);
    }

    public static RootDSE valueOf(Entry entry) {
        Reject.ifNull((Object)entry);
        return new RootDSE(entry);
    }

    private RootDSE(Entry entry) {
        this.entry = entry;
    }

    public Collection<String> getAlternativeServers() {
        return this.getMultiValuedAttribute(ATTR_ALT_SERVER, Functions.byteStringToString());
    }

    public Entry getEntry() {
        return this.entry;
    }

    public Collection<DN> getNamingContexts() {
        return this.getMultiValuedAttribute(ATTR_NAMING_CONTEXTS, Functions.byteStringToDN());
    }

    public DN getSubschemaSubentry() {
        return this.getSingleValuedAttribute(ATTR_SUBSCHEMA_SUBENTRY, Functions.byteStringToDN());
    }

    public Collection<String> getSupportedAuthenticationPasswordSchemes() {
        return this.getMultiValuedAttribute(ATTR_SUPPORTED_AUTH_PASSWORD_SCHEMES, Functions.byteStringToString());
    }

    public Collection<String> getSupportedControls() {
        return this.getMultiValuedAttribute(ATTR_SUPPORTED_CONTROL, Functions.byteStringToString());
    }

    public Collection<String> getSupportedExtendedOperations() {
        return this.getMultiValuedAttribute(ATTR_SUPPORTED_EXTENSION, Functions.byteStringToString());
    }

    public Collection<String> getSupportedFeatures() {
        return this.getMultiValuedAttribute(ATTR_SUPPORTED_FEATURE, Functions.byteStringToString());
    }

    public Collection<Integer> getSupportedLDAPVersions() {
        return this.getMultiValuedAttribute(ATTR_SUPPORTED_LDAP_VERSION, Functions.byteStringToInteger());
    }

    public Collection<String> getSupportedSASLMechanisms() {
        return this.getMultiValuedAttribute(ATTR_SUPPORTED_SASL_MECHANISMS, Functions.byteStringToString());
    }

    public String getVendorName() {
        return this.getSingleValuedAttribute(ATTR_VENDOR_NAME, Functions.byteStringToString());
    }

    public String getVendorVersion() {
        return this.getSingleValuedAttribute(ATTR_VENDOR_VERSION, Functions.byteStringToString());
    }

    public String getFullVendorVersion() {
        return this.getSingleValuedAttribute(ATTR_FULL_VENDOR_VERSION, Functions.byteStringToString());
    }

    private <N> Collection<N> getMultiValuedAttribute(AttributeDescription attributeDescription, Function<ByteString, N, NeverThrowsException> function) {
        Attribute attr = this.entry.getAttribute(attributeDescription);
        if (attr != null) {
            return Collections.unmodifiableCollection(Collections2.transformedCollection(attr, function, Functions.objectToByteString()));
        }
        return Collections.emptySet();
    }

    private <N> N getSingleValuedAttribute(AttributeDescription attributeDescription, Function<ByteString, N, NeverThrowsException> function) {
        Attribute attr = this.entry.getAttribute(attributeDescription);
        if (attr == null || attr.isEmpty()) {
            return null;
        }
        return (N)function.apply((Object)attr.firstValue());
    }
}

