/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.IOException;
import java.util.Collection;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeFilter;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.EntryReader;

public final class MemoryBackend
implements RequestHandler<RequestContext> {
    private final DecodeOptions decodeOptions;
    private final ConcurrentSkipListMap<DN, Entry> entries = new ConcurrentSkipListMap();
    private final Schema schema;
    private final Object writeLock = new Object();

    public MemoryBackend() {
        this(Schema.getDefaultSchema());
    }

    public MemoryBackend(EntryReader reader) throws IOException {
        this(Schema.getDefaultSchema(), reader);
    }

    public MemoryBackend(Schema schema) {
        this.schema = schema;
        this.decodeOptions = new DecodeOptions().setSchema(schema);
    }

    public MemoryBackend(Schema schema, EntryReader reader) throws IOException {
        this.schema = schema;
        this.decodeOptions = new DecodeOptions().setSchema(schema);
        this.load(reader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryBackend clear() {
        Object object = this.writeLock;
        synchronized (object) {
            this.entries.clear();
        }
        return this;
    }

    public boolean contains(DN dn) {
        return this.get(dn) != null;
    }

    public boolean contains(String dn) {
        return this.get(dn) != null;
    }

    public Entry get(DN dn) {
        return this.entries.get(dn);
    }

    public Entry get(String dn) {
        return this.get(DN.valueOf(dn, this.schema));
    }

    public Collection<Entry> getAll() {
        return this.entries.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAdd(RequestContext requestContext, AddRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                DN dn = request.getName();
                DN parent = dn.parent();
                if (this.entries.containsKey(dn)) {
                    throw LdapException.newLdapException(ResultCode.ENTRY_ALREADY_EXISTS, "The entry '" + dn + "' already exists");
                }
                if (parent != null && !this.entries.containsKey(parent)) {
                    this.noSuchObject(parent);
                } else {
                    this.entries.put(dn, request);
                }
            }
            resultHandler.handleResult(this.getResult(request, null, request));
        }
        catch (LdapException e) {
            resultHandler.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBind(RequestContext requestContext, int version, BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<BindResult> resultHandler) {
        try {
            Entry entry;
            Object object = this.writeLock;
            synchronized (object) {
                byte[] password;
                DN username = DN.valueOf(request.getName(), this.schema);
                if (request instanceof SimpleBindRequest) {
                    password = ((SimpleBindRequest)request).getPassword();
                } else if (request instanceof GenericBindRequest && request.getAuthenticationType() == -128) {
                    password = ((GenericBindRequest)request).getAuthenticationValue();
                } else {
                    throw LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, "non-SIMPLE authentication not supported: " + request.getAuthenticationType());
                }
                entry = this.getRequiredEntry(null, username);
                if (!entry.containsAttribute("userPassword", new Object[]{password})) {
                    throw LdapException.newLdapException(ResultCode.INVALID_CREDENTIALS, "Wrong password");
                }
            }
            resultHandler.handleResult(this.getBindResult(request, entry, entry));
        }
        catch (LocalizedIllegalArgumentException e) {
            resultHandler.handleException(LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e));
        }
        catch (EntryNotFoundException e) {
            resultHandler.handleException(LdapException.newLdapException(ResultCode.INVALID_CREDENTIALS, "Unknown user"));
        }
        catch (LdapException e) {
            resultHandler.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCompare(RequestContext requestContext, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<CompareResult> resultHandler) {
        try {
            Attribute assertion;
            Entry entry;
            Object object = this.writeLock;
            synchronized (object) {
                DN dn = request.getName();
                entry = this.getRequiredEntry(request, dn);
                assertion = Attributes.singletonAttribute(request.getAttributeDescription(), (Object)request.getAssertionValue());
            }
            resultHandler.handleResult(this.getCompareResult(request, entry, entry.containsAttribute(assertion, null)));
        }
        catch (LdapException e) {
            resultHandler.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDelete(RequestContext requestContext, DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        try {
            Entry entry;
            Object object = this.writeLock;
            synchronized (object) {
                DN dn = request.getName();
                entry = this.getRequiredEntry(request, dn);
                if (request.getControl(SubtreeDeleteRequestControl.DECODER, this.decodeOptions) != null) {
                    this.entries.subMap((Object)dn, (Object)dn.child(RDN.maxValue())).clear();
                } else {
                    DN next = this.entries.higherKey(dn);
                    if (next == null || !next.isChildOf(dn)) {
                        this.entries.remove(dn);
                    } else {
                        throw LdapException.newLdapException(ResultCode.NOT_ALLOWED_ON_NONLEAF);
                    }
                }
            }
            resultHandler.handleResult(this.getResult(request, entry, null));
        }
        catch (DecodeException e) {
            resultHandler.handleException(LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e));
        }
        catch (LdapException e) {
            resultHandler.handleException(e);
        }
    }

    @Override
    public <R extends ExtendedResult> void handleExtendedRequest(RequestContext requestContext, ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<R> resultHandler) {
        resultHandler.handleException(LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, "Extended request operation not supported"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleModify(RequestContext requestContext, ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        try {
            LinkedHashMapEntry newEntry;
            Entry entry;
            Object object = this.writeLock;
            synchronized (object) {
                DN dn = request.getName();
                entry = this.getRequiredEntry(request, dn);
                newEntry = new LinkedHashMapEntry(entry);
                this.entries.put(dn, Entries.modifyEntry((Entry)newEntry, request));
            }
            resultHandler.handleResult(this.getResult(request, entry, newEntry));
        }
        catch (LdapException e) {
            resultHandler.handleException(e);
        }
    }

    @Override
    public void handleModifyDN(RequestContext requestContext, ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
        resultHandler.handleException(LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, "ModifyDN request operation not supported"));
    }

    @Override
    public void handleSearch(RequestContext requestContext, SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler) {
        block6: {
            try {
                DN dn = request.getName();
                SearchScope scope = request.getScope();
                Filter filter = request.getFilter();
                Matcher matcher = filter.matcher(this.schema);
                AttributeFilter attributeFilter = new AttributeFilter(request.getAttributes(), this.schema).typesOnly(request.isTypesOnly());
                if (scope.equals(SearchScope.BASE_OBJECT)) {
                    Entry baseEntry = this.getRequiredEntry(request, dn);
                    if (matcher.matches(baseEntry).toBoolean()) {
                        this.sendEntry(attributeFilter, entryHandler, baseEntry);
                    }
                    resultHandler.handleResult(Responses.newResult(ResultCode.SUCCESS));
                    break block6;
                }
                if (scope.equals(SearchScope.SINGLE_LEVEL) || scope.equals(SearchScope.SUBORDINATES) || scope.equals(SearchScope.WHOLE_SUBTREE)) {
                    this.searchWithSubordinates(requestContext, entryHandler, resultHandler, dn, matcher, attributeFilter, request.getSizeLimit(), scope, request.getControl(SimplePagedResultsControl.DECODER, new DecodeOptions()));
                    break block6;
                }
                throw LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, "Search request contains an unsupported search scope");
            }
            catch (DecodeException e) {
                resultHandler.handleException(LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e.getMessage(), e));
            }
            catch (LdapException e) {
                resultHandler.handleException(e);
            }
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryBackend load(EntryReader reader, boolean overwrite) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (reader != null) {
                try {
                    while (reader.hasNext()) {
                        Entry entry = reader.readEntry();
                        DN dn = entry.getName();
                        if (!overwrite && this.entries.containsKey(dn)) {
                            throw LdapException.newLdapException(ResultCode.ENTRY_ALREADY_EXISTS, "Attempted to add the entry '" + dn + "' multiple times");
                        }
                        this.entries.put(dn, entry);
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        return this;
    }

    public int size() {
        return this.entries.size();
    }

    private void searchWithSubordinates(RequestContext requestContext, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler, DN dn, Matcher matcher, AttributeFilter attributeFilter, int sizeLimit, SearchScope scope, SimplePagedResultsControl pagedResults) throws CancelledResultException, LdapException {
        int pageSize = pagedResults != null ? pagedResults.getSize() : 0;
        int offset = pagedResults != null && !pagedResults.getCookie().isEmpty() ? Integer.valueOf(pagedResults.getCookie().toString()) : 0;
        SortedMap subtree = this.entries.subMap((Object)dn, (Object)dn.child(RDN.maxValue()));
        int numberOfResults = 0;
        int position = 0;
        for (Entry entry : subtree.values()) {
            requestContext.checkIfCancelled(false);
            if (!scope.equals(SearchScope.WHOLE_SUBTREE) && !entry.getName().isChildOf(dn) && (!scope.equals(SearchScope.SUBORDINATES) || entry.getName().equals(dn)) || !matcher.matches(entry).toBoolean()) continue;
            if (sizeLimit > 0 && numberOfResults >= sizeLimit) {
                throw LdapException.newLdapException(Responses.newResult(ResultCode.SIZE_LIMIT_EXCEEDED));
            }
            if (pageSize > 0 && position++ < offset || this.sendEntry(attributeFilter, entryHandler, entry) && (pageSize <= 0 || ++numberOfResults != pageSize)) continue;
            break;
        }
        Result result = Responses.newResult(ResultCode.SUCCESS);
        if (pageSize > 0) {
            ByteString cookie = numberOfResults == pageSize ? ByteString.valueOfUtf8(String.valueOf(position)) : ByteString.empty();
            result.addControl(SimplePagedResultsControl.newControl(true, 0, cookie));
        }
        resultHandler.handleResult(result);
    }

    private <R extends Result> R addResultControls(Request request, Entry before, Entry after, R result) throws LdapException {
        try {
            PostReadRequestControl postRead;
            PreReadRequestControl preRead = request.getControl(PreReadRequestControl.DECODER, this.decodeOptions);
            if (preRead != null) {
                if (preRead.isCritical() && before == null) {
                    throw LdapException.newLdapException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                }
                AttributeFilter filter = new AttributeFilter(preRead.getAttributes(), this.schema);
                result.addControl(PreReadResponseControl.newControl(filter.filteredViewOf(before)));
            }
            if ((postRead = request.getControl(PostReadRequestControl.DECODER, this.decodeOptions)) != null) {
                if (postRead.isCritical() && after == null) {
                    throw LdapException.newLdapException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                }
                AttributeFilter filter = new AttributeFilter(postRead.getAttributes(), this.schema);
                result.addControl(PostReadResponseControl.newControl(filter.filteredViewOf(after)));
            }
            return result;
        }
        catch (DecodeException e) {
            throw LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e);
        }
    }

    private BindResult getBindResult(BindRequest request, Entry before, Entry after) throws LdapException {
        return this.addResultControls(request, before, after, Responses.newBindResult(ResultCode.SUCCESS));
    }

    private CompareResult getCompareResult(CompareRequest request, Entry entry, boolean compareResult) throws LdapException {
        return this.addResultControls(request, entry, entry, Responses.newCompareResult(compareResult ? ResultCode.COMPARE_TRUE : ResultCode.COMPARE_FALSE));
    }

    private Entry getRequiredEntry(Request request, DN dn) throws LdapException {
        Entry entry = this.entries.get(dn);
        if (entry == null) {
            this.noSuchObject(dn);
        } else if (request != null) {
            Filter filter;
            Matcher matcher;
            AssertionRequestControl control;
            try {
                control = request.getControl(AssertionRequestControl.DECODER, this.decodeOptions);
            }
            catch (DecodeException e) {
                throw LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e);
            }
            if (control != null && !(matcher = (filter = control.getFilter()).matcher(this.schema)).matches(entry).toBoolean()) {
                throw LdapException.newLdapException(ResultCode.ASSERTION_FAILED, "The filter '" + filter + "' did not match the entry '" + entry.getName() + "'");
            }
        }
        return entry;
    }

    private Result getResult(Request request, Entry before, Entry after) throws LdapException {
        return this.addResultControls(request, before, after, Responses.newResult(ResultCode.SUCCESS));
    }

    private void noSuchObject(DN dn) throws LdapException {
        throw LdapException.newLdapException(ResultCode.NO_SUCH_OBJECT, "The entry '" + dn + "' does not exist");
    }

    private boolean sendEntry(AttributeFilter filter, SearchResultHandler resultHandler, Entry entry) {
        return resultHandler.handleEntry(Responses.newSearchResultEntry(filter.filteredViewOf(entry)));
    }
}

