/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.maven;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.command.diff.GitDiffConsumer;
import org.apache.maven.scm.provider.git.gitexe.GitExeScmProvider;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.diff.GitDiffCommand;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.forgerock.util.Utils;

public abstract class CopyrightAbstractMojo
extends AbstractMojo {
    @Parameter(required=true, property="project", readonly=true)
    private MavenProject project;
    @Parameter(required=true, defaultValue="ForgeRock AS")
    private String copyrightOwnerToken;
    @Parameter(required=true, defaultValue="${basedir}")
    private String baseDir;
    @Parameter(required=true, defaultValue="${project.scm.connection}")
    private String scmRepositoryUrl;
    @Parameter(required=false)
    private List<String> disabledFiles;
    public static final List<String> CHECKED_EXTENSIONS = new LinkedList<String>(Arrays.asList("bat", "c", "h", "html", "java", "ldif", "Makefile", "mc", "sh", "txt", "xml", "xsd", "xsl"));
    private static final List<String> EXCLUDED_END_COMMENT_BLOCK_TOKEN = new LinkedList<String>(Arrays.asList("*/", "-->"));
    private static final List<String> SUPPORTED_COMMENT_MIDDLE_BLOCK_TOKEN = new LinkedList<String>(Arrays.asList("*", "#", "rem", "!"));
    private static final List<String> SUPPORTED_START_BLOCK_COMMENT_TOKEN = new LinkedList<String>(Arrays.asList("/*", "<!--"));
    Integer currentYear = Calendar.getInstance().get(1);
    private final List<String> incorrectCopyrightFilePaths = new LinkedList<String>();
    private ScmManager scmManager;
    private ScmRepository scmRepository;

    private String getLocalScmRootPath(File basedir) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)basedir, (String)"rev-parse");
        cl.addArguments(new String[]{"--show-toplevel"});
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        ScmLogDispatcher dummyLogger = new ScmLogDispatcher();
        int exitCode = GitCommandLineUtils.execute((Commandline)cl, (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)dummyLogger);
        return exitCode == 0 ? stdout.getOutput().trim().replace(" ", "%20") : basedir.getPath();
    }

    List<String> getIncorrectCopyrightFilePaths() {
        return this.incorrectCopyrightFilePaths;
    }

    private ScmManager getScmManager() throws MojoExecutionException {
        if (this.scmManager == null) {
            this.scmManager = new BasicScmManager();
            String scmProviderID = this.getScmProviderID();
            if (!"git".equals(scmProviderID)) {
                throw new MojoExecutionException("Unsupported scm provider: " + scmProviderID + " or " + this.getIncorrectScmRepositoryUrlMsg());
            }
            this.scmManager.setScmProvider(scmProviderID, (ScmProvider)new CustomGitExeScmProvider());
        }
        return this.scmManager;
    }

    private String getScmProviderID() throws MojoExecutionException {
        try {
            return this.scmRepositoryUrl.split(":")[1];
        }
        catch (Exception e) {
            throw new MojoExecutionException(this.getIncorrectScmRepositoryUrlMsg(), e);
        }
    }

    String getIncorrectScmRepositoryUrlMsg() {
        return "the scmRepositoryUrl property with value '" + this.scmRepositoryUrl + "' is incorrect. " + "The URL has to respect the format: scm:[provider]:[provider_specific_url]";
    }

    ScmRepository getScmRepository() throws MojoExecutionException {
        if (this.scmRepository == null) {
            try {
                this.scmRepository = this.getScmManager().makeScmRepository(this.scmRepositoryUrl);
            }
            catch (NoSuchScmProviderException e) {
                throw new MojoExecutionException("Could not find a provider.", (Exception)((Object)e));
            }
            catch (ScmRepositoryException e) {
                throw new MojoExecutionException("Error while connecting to the repository", (Exception)((Object)e));
            }
        }
        return this.scmRepository;
    }

    String getBaseDir() {
        return this.baseDir;
    }

    List<File> getChangedFiles() throws MojoExecutionException, MojoFailureException {
        try {
            ScmFileSet workspaceFileSet = new ScmFileSet(new File(this.getBaseDir()));
            DiffScmResult diffMasterHeadResult = this.getScmManager().diff(this.getScmRepository(), workspaceFileSet, null, null);
            this.ensureCommandSuccess((ScmResult)diffMasterHeadResult, "diff master...HEAD .");
            StatusScmResult statusResult = this.getScmManager().status(this.getScmRepository(), workspaceFileSet);
            this.ensureCommandSuccess((ScmResult)statusResult, "status");
            ArrayList<File> changedFilePaths = new ArrayList<File>();
            this.addToChangedFiles(diffMasterHeadResult.getChangedFiles(), this.getBaseDir(), changedFilePaths);
            String localScmRootPath = this.getLocalScmRootPath(new File(this.getBaseDir()));
            this.addToChangedFiles(statusResult.getChangedFiles(), localScmRootPath, changedFilePaths);
            return changedFilePaths;
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Encountered an error while examining modified files,  SCM status:  " + e.getMessage() + "No further checks will be performed.", (Exception)((Object)e));
        }
    }

    private void ensureCommandSuccess(ScmResult result, String cmd) throws MojoFailureException {
        if (!result.isSuccess()) {
            String message = "Impossible to perform scm " + cmd + " command because " + result.getCommandOutput();
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
    }

    private void addToChangedFiles(List<ScmFile> scmChangedFiles, String rootPath, List<File> changedFiles) {
        for (ScmFile scmFile : scmChangedFiles) {
            String scmFilePath = scmFile.getPath();
            if (scmFile.getStatus() == ScmFileStatus.UNKNOWN || !new File(scmFilePath).exists() || changedFiles.contains(scmFilePath) || this.fileIsDisabled(scmFilePath)) continue;
            changedFiles.add(new File(rootPath, scmFilePath));
        }
    }

    private boolean fileIsDisabled(String scmFilePath) {
        if (this.disabledFiles == null) {
            return false;
        }
        for (String disableFile : this.disabledFiles) {
            String regexp = disableFile.replace("**/", "(.+/)+").replace("?", ".?").replace("*", ".*?");
            if (!scmFilePath.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    void checkCopyrights() throws MojoExecutionException, MojoFailureException {
        for (File changedFile : this.getChangedFiles()) {
            String extension;
            String changedFileName;
            int lastPeriodPos;
            if (!changedFile.exists() || !changedFile.isFile() || ((lastPeriodPos = (changedFileName = changedFile.getPath()).lastIndexOf(46)) <= 0 ? this.fileNameEquals("bin", changedFile.getParentFile()) && this.fileNameEquals("resource", changedFile.getParentFile().getParentFile()) : !CHECKED_EXTENSIONS.contains((extension = changedFileName.substring(lastPeriodPos + 1)).toLowerCase()))) continue;
            if (this.checkCopyrightForFile(changedFile)) continue;
            this.incorrectCopyrightFilePaths.add(changedFile.getAbsolutePath());
        }
    }

    private boolean fileNameEquals(String folderName, File file) {
        return file != null && folderName.equals(file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCopyrightForFile(File changedFile) throws MojoExecutionException {
        boolean bl;
        BufferedReader reader;
        block6: {
            boolean bl2;
            reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(changedFile));
                while ((line = reader.readLine()) != null) {
                    String lowerLine = line.toLowerCase().trim();
                    if (!this.isCommentLine(lowerLine) || !lowerLine.contains("copyright") || !line.contains(this.currentYear.toString()) || !line.contains(this.copyrightOwnerToken)) continue;
                    reader.close();
                    bl = true;
                    break block6;
                }
                bl2 = false;
            }
            catch (IOException ioe) {
                try {
                    throw new MojoExecutionException("Could not read file " + changedFile.getPath() + " to check copyright date. No further copyright date checking will be performed.");
                }
                catch (Throwable throwable) {
                    Utils.closeSilently((Closeable[])new Closeable[]{reader});
                    throw throwable;
                }
            }
            Utils.closeSilently((Closeable[])new Closeable[]{reader});
            return bl2;
        }
        Utils.closeSilently((Closeable[])new Closeable[]{reader});
        return bl;
    }

    private String getCommentToken(String line, boolean includesStartBlock) {
        List<String> supportedTokens = SUPPORTED_COMMENT_MIDDLE_BLOCK_TOKEN;
        if (includesStartBlock) {
            supportedTokens.addAll(SUPPORTED_START_BLOCK_COMMENT_TOKEN);
        }
        if (this.trimmedLineStartsWith(line, EXCLUDED_END_COMMENT_BLOCK_TOKEN) != null) {
            return null;
        }
        return this.trimmedLineStartsWith(line, supportedTokens);
    }

    private String trimmedLineStartsWith(String line, List<String> supportedTokens) {
        for (String token : supportedTokens) {
            if (!line.trim().startsWith(token)) continue;
            return token;
        }
        return null;
    }

    boolean isNonEmptyCommentedLine(String line) {
        String commentToken = this.getCommentTokenInBlock(line);
        return commentToken == null || !commentToken.equals(line.trim());
    }

    String getCommentTokenInBlock(String line) {
        return this.getCommentToken(line, false);
    }

    boolean isCommentLine(String line) {
        return this.getCommentToken(line, true) != null;
    }

    private static class CustomGitDiffCommand
    extends GitDiffCommand
    implements GitCommand {
        private CustomGitDiffCommand() {
        }

        protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion unused, ScmVersion unused2) throws ScmException {
            GitDiffConsumer consumer = new GitDiffConsumer(this.getLogger(), fileSet.getBasedir());
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)fileSet.getBasedir(), (String)"diff");
            cl.addArguments(new String[]{"--no-ext-diff", "--relative", "master...HEAD", "."});
            if (GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger()) != 0) {
                return new DiffScmResult(cl.toString(), "The git-diff command failed.", stderr.getOutput(), false);
            }
            return new DiffScmResult(cl.toString(), consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
        }
    }

    private static final class CustomGitExeScmProvider
    extends GitExeScmProvider {
        private CustomGitExeScmProvider() {
        }

        protected GitCommand getDiffCommand() {
            return new CustomGitDiffCommand();
        }
    }
}

