/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.forgerock.maven.CopyrightAbstractMojo;

@Mojo(name="check-copyright", defaultPhase=LifecyclePhase.VALIDATE)
public class CheckCopyrightMojo
extends CopyrightAbstractMojo {
    @Parameter(required=true, property="ignoreCopyrightErrors", defaultValue="false")
    private boolean ignoreCopyrightErrors;
    @Parameter(required=true, property="skipCopyrightCheck", defaultValue="false")
    private boolean checkDisabled;

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.checkDisabled) {
            this.getLog().info((CharSequence)"Copyright check is disabled");
            return;
        }
        this.checkCopyrights();
        if (!this.getIncorrectCopyrightFilePaths().isEmpty()) {
            this.getLog().warn((CharSequence)"Potential copyright year updates needed for the following files:");
            for (String filename : this.getIncorrectCopyrightFilePaths()) {
                this.getLog().warn((CharSequence)("     " + filename));
            }
            if (!this.ignoreCopyrightErrors) {
                this.getLog().warn((CharSequence)"Fix copyright date problems before proceeding, or use '-DignoreCopyrightErrors=true' to ignore copyright errors.");
                this.getLog().warn((CharSequence)"You can use update-copyrights maven profile (mvn validate -Pupdate-copyrights) to automatically update copyrights.");
                throw new MojoExecutionException("Found files with potential copyright year updates needed");
            }
        } else {
            this.getLog().info((CharSequence)"Copyrights are up to date");
        }
    }
}

