/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.forgerock.maven.CopyrightAbstractMojo;
import org.forgerock.util.Utils;

@Mojo(name="update-copyright", defaultPhase=LifecyclePhase.VALIDATE)
public class UpdateCopyrightMojo
extends CopyrightAbstractMojo {
    private static final Pattern OLD_COPYRIGHT_REGEXP = Pattern.compile(".*copyright.*", 2);
    @Parameter(required=true, defaultValue="1")
    private Integer nbLinesToSkip;
    @Parameter(required=true, defaultValue="1")
    private Integer numberSpaceIdentation;
    @Parameter(required=true, defaultValue="\\\"Portions Copyright \\[year\\] \\[name of copyright owner\\]\\\"")
    private String lineBeforeCopyrightRegExp;
    @Parameter(required=true, defaultValue="ForgeRock\\s+AS")
    private String forgerockCopyrightRegExp;
    @Parameter(required=true, defaultValue="Copyright")
    private String newCopyrightLabel;
    @Parameter(required=true, defaultValue="Portions Copyright")
    private String newPortionsCopyrightLabel;
    @Parameter(required=true, defaultValue="ForgeRock AS.")
    private String forgeRockCopyrightLabel;
    @Parameter(required=true, defaultValue="false")
    private boolean dryRun;
    private Pattern lineBeforeCopyrightCompiledRegExp;
    private Pattern copyrightOwnerCompiledRegExp;
    private boolean buildOK = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.compileRegExps();
        this.checkCopyrights();
        for (String filePath : this.getIncorrectCopyrightFilePaths()) {
            try {
                new UpdateCopyrightFile(filePath).updateCopyrightForFile();
                this.getLog().info((CharSequence)("Copyright of file " + this.printFilePath(filePath) + " has been successfully updated."));
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Impossible to update copyright of file " + this.printFilePath(filePath)));
                this.getLog().error((CharSequence)("  Details: " + e.getMessage()));
                this.getLog().error((CharSequence)"  No modification has been performed on this file");
                this.buildOK = false;
            }
        }
        if (!this.buildOK) {
            throw new MojoFailureException("Error(s) occured while trying to update some copyrights.");
        }
    }

    private void compileRegExps() {
        this.lineBeforeCopyrightCompiledRegExp = this.compileRegExp(this.lineBeforeCopyrightRegExp);
        this.copyrightOwnerCompiledRegExp = this.compileRegExp(this.forgerockCopyrightRegExp);
    }

    private Pattern compileRegExp(String regExp) {
        return Pattern.compile(".*" + regExp + ".*", 2);
    }

    private String intervalToString(Integer startYear, Integer endYear) {
        return startYear + "-" + endYear;
    }

    private String indent() {
        String indentation = "";
        for (int i = 0; i < this.numberSpaceIdentation; ++i) {
            indentation = indentation + " ";
        }
        return indentation;
    }

    void setLineBeforeCopyrightToken(String lineBeforeCopyrightToken) {
        this.lineBeforeCopyrightRegExp = lineBeforeCopyrightToken;
    }

    void setNbLinesToSkip(Integer nbLinesToSkip) {
        this.nbLinesToSkip = nbLinesToSkip;
    }

    void setNumberSpaceIdentation(Integer numberSpaceIdentation) {
        this.numberSpaceIdentation = numberSpaceIdentation;
    }

    void setNewPortionsCopyrightString(String portionsCopyrightString) {
        this.newPortionsCopyrightLabel = portionsCopyrightString;
    }

    void setNewCopyrightOwnerString(String newCopyrightOwnerString) {
        this.forgeRockCopyrightLabel = newCopyrightOwnerString;
    }

    void setNewCopyrightStartToken(String copyrightStartString) {
        this.newCopyrightLabel = copyrightStartString;
    }

    void setCopyrightEndToken(String copyrightEndToken) {
        this.forgerockCopyrightRegExp = copyrightEndToken;
    }

    void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    private final class UpdateCopyrightFile {
        private final String filePath;
        private final List<String> bufferedLines = new LinkedList<String>();
        private boolean copyrightUpdated;
        private boolean lineBeforeCopyrightReaded;
        private boolean commentBlockEnded;
        private boolean portionsCopyrightNeeded;
        private boolean copyrightSectionPresent;
        private CopyrightAbstractMojo.CommentParser commentParser;
        private String curLine;
        private Integer startYear;
        private Integer endYear;
        private final BufferedReader reader;
        private final BufferedWriter writer;

        private UpdateCopyrightFile(String filePath) throws IOException {
            this.filePath = filePath;
            this.reader = new BufferedReader(new FileReader(filePath));
            this.commentParser = CopyrightAbstractMojo.CommentParser.createParserForFile(filePath);
            File tmpFile = new File(filePath + ".tmp");
            if (!tmpFile.exists()) {
                tmpFile.createNewFile();
            }
            this.writer = new BufferedWriter(new FileWriter(tmpFile));
        }

        private void updateCopyrightForFile() throws MojoExecutionException {
            try {
                this.readLineBeforeCopyrightToken();
                this.portionsCopyrightNeeded = this.readOldCopyrightLine();
                this.copyrightSectionPresent = this.readCopyrightLine();
                this.writeCopyrightLine();
                this.writeChanges();
            }
            catch (Exception e) {
                try {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    Utils.closeSilently((Closeable[])new Closeable[]{this.reader, this.writer});
                    throw throwable;
                }
            }
            Utils.closeSilently((Closeable[])new Closeable[]{this.reader, this.writer});
        }

        private void writeChanges() throws Exception {
            while (this.curLine != null) {
                this.nextLine();
            }
            this.reader.close();
            for (String line : this.bufferedLines) {
                this.writer.write(line);
                this.writer.newLine();
            }
            this.writer.close();
            if (!UpdateCopyrightMojo.this.dryRun) {
                File updatedFile = new File(this.filePath);
                if (!updatedFile.delete()) {
                    throw new Exception("impossible to perform rename on the file.");
                }
                new File(this.filePath + ".tmp").renameTo(updatedFile);
            }
        }

        private void writeCopyrightLine() throws Exception {
            if (this.copyrightSectionPresent) {
                this.updateExistingCopyrightLine();
                this.copyrightUpdated = true;
                return;
            }
            int indexAdd = this.bufferedLines.size() - 1;
            Pattern stopRegExp = this.portionsCopyrightNeeded ? OLD_COPYRIGHT_REGEXP : UpdateCopyrightMojo.this.lineBeforeCopyrightCompiledRegExp;
            String previousLine = this.curLine;
            while (!this.lineMatches(previousLine, stopRegExp)) {
                previousLine = this.bufferedLines.get(--indexAdd);
            }
            ++indexAdd;
            String newCommentedLine = this.commentParser.getNewCommentedLine(previousLine);
            if (!this.portionsCopyrightNeeded) {
                for (int i = 0; i < UpdateCopyrightMojo.this.nbLinesToSkip; ++i) {
                    if (!this.bufferedLines.get(indexAdd).equals(newCommentedLine)) {
                        this.bufferedLines.add(indexAdd, newCommentedLine);
                    }
                    ++indexAdd;
                }
            }
            String newCopyrightLine = newCommentedLine + UpdateCopyrightMojo.this.indent() + (this.portionsCopyrightNeeded ? UpdateCopyrightMojo.this.newPortionsCopyrightLabel : UpdateCopyrightMojo.this.newCopyrightLabel) + " " + UpdateCopyrightMojo.this.currentYear + " " + UpdateCopyrightMojo.this.forgeRockCopyrightLabel;
            this.bufferedLines.add(indexAdd, newCopyrightLine);
            this.copyrightUpdated = true;
        }

        private void updateExistingCopyrightLine() throws Exception {
            this.readYearSection();
            String newCopyrightLine = this.endYear == null ? this.curLine.replace(this.startYear.toString(), UpdateCopyrightMojo.this.intervalToString(this.startYear, UpdateCopyrightMojo.this.currentYear)) : this.curLine.replace(UpdateCopyrightMojo.this.intervalToString(this.startYear, this.endYear), UpdateCopyrightMojo.this.intervalToString(this.startYear, UpdateCopyrightMojo.this.currentYear));
            this.bufferedLines.remove(this.bufferedLines.size() - 1);
            this.bufferedLines.add(newCopyrightLine);
        }

        private void readYearSection() throws Exception {
            String copyrightLineRegExp = ".*\\s+(\\d{4})(-(\\d{4}))?\\s+" + UpdateCopyrightMojo.this.forgerockCopyrightRegExp + ".*";
            Matcher copyrightMatcher = Pattern.compile(copyrightLineRegExp, 2).matcher(this.curLine);
            if (copyrightMatcher.matches()) {
                this.startYear = Integer.parseInt(copyrightMatcher.group(1));
                String endYearString = copyrightMatcher.group(3);
                if (endYearString != null) {
                    this.endYear = Integer.parseInt(endYearString);
                }
            } else {
                throw new Exception("Malformed year section in copyright line " + this.curLine);
            }
        }

        private void readLineBeforeCopyrightToken() throws Exception {
            this.nextLine();
            while (this.curLine != null) {
                if (this.curLineMatches(UpdateCopyrightMojo.this.lineBeforeCopyrightCompiledRegExp)) {
                    if (!this.commentParser.isCommentLine()) {
                        throw new Exception("The line before copyright token must be a commented line");
                    }
                    this.lineBeforeCopyrightReaded = true;
                    return;
                }
                if (this.commentBlockEnded) {
                    throw new Exception("unexpected non commented line found before copyright section");
                }
                this.nextLine();
            }
        }

        private boolean readOldCopyrightLine() throws Exception {
            this.nextLine();
            while (this.curLine != null) {
                if (this.isOldCopyrightOwnerLine()) {
                    return true;
                }
                if (this.commentParser.isNonEmptyCommentedLine() || this.isCopyrightLine() || this.commentBlockEnded) {
                    return false;
                }
                this.nextLine();
            }
            throw new Exception("unexpected end of file while trying to read copyright");
        }

        private boolean readCopyrightLine() throws Exception {
            while (this.curLine != null) {
                if (this.isCopyrightLine()) {
                    return true;
                }
                if (this.commentParser.isNonEmptyCommentedLine() && !this.isOldCopyrightOwnerLine() || this.commentBlockEnded) {
                    return false;
                }
                this.nextLine();
            }
            throw new Exception("unexpected end of file while trying to read copyright");
        }

        private boolean isOldCopyrightOwnerLine() {
            return this.curLineMatches(OLD_COPYRIGHT_REGEXP) && !this.curLineMatches(UpdateCopyrightMojo.this.copyrightOwnerCompiledRegExp);
        }

        private boolean isCopyrightLine() {
            return this.curLineMatches(UpdateCopyrightMojo.this.copyrightOwnerCompiledRegExp);
        }

        private boolean curLineMatches(Pattern compiledRegExp) {
            return this.lineMatches(this.curLine, compiledRegExp);
        }

        private boolean lineMatches(String line, Pattern compiledRegExp) {
            return compiledRegExp.matcher(line).matches();
        }

        private void nextLine() throws Exception {
            this.curLine = this.reader.readLine();
            this.commentParser.consumeLine(this.curLine);
            if (this.curLine == null && !this.copyrightUpdated) {
                throw new Exception("unexpected end of file while trying to read copyright");
            }
            if (this.curLine != null) {
                this.bufferedLines.add(this.curLine);
            }
            if (!this.copyrightUpdated && this.lineBeforeCopyrightReaded && !this.commentParser.isCommentLine()) {
                this.commentBlockEnded = true;
            }
        }
    }
}

