/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.command.diff.GitDiffConsumer;
import org.apache.maven.scm.provider.git.gitexe.GitExeScmProvider;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.diff.GitDiffCommand;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class CopyrightAbstractMojo
extends AbstractMojo {
    static final String DIFF_REFERENCE_BRANCH_NAME_PROPERTY = "checkCopyrightDiffReferenceBranchName";
    @Parameter(required=true, property="project", readonly=true)
    private MavenProject project;
    @Parameter(required=true, defaultValue="ForgeRock AS")
    private String copyrightOwnerToken;
    @Parameter(required=true, defaultValue="${project.scm.connection}")
    private String scmRepositoryUrl;
    @Parameter(required=true, property="checkCopyrightDiffReferenceBranchName", defaultValue="origin/master")
    private String gitMasterBranchName;
    @Parameter(required=true, defaultValue="true")
    private boolean printRelativeFilePath;
    @Parameter(required=false)
    private List<String> disabledFiles;
    public static final List<String> CHECKED_EXTENSIONS = Arrays.asList("bat", "c", "fml", "h", "html", "java", "java.stub", "ldif", "mc", "md", "properties", "security", "sh", "txt", "xjb", "xml", "xml.vm", "xsd", "xsl");
    Integer currentYear = Calendar.getInstance().get(1);
    private final List<String> incorrectCopyrightFilePaths = new LinkedList<String>();
    private ScmManager scmManager;
    private ScmRepository scmRepository;
    private String localScmRootPath;

    private static String resolveExtension(String filePath) {
        String fileName = Paths.get(filePath, new String[0]).getFileName().toString();
        int firstPeriodPos = fileName.indexOf(46);
        if (firstPeriodPos > 0) {
            return fileName.substring(firstPeriodPos + 1);
        }
        return "";
    }

    List<String> getIncorrectCopyrightFilePaths() {
        return this.incorrectCopyrightFilePaths;
    }

    private ScmManager getScmManager() throws MojoExecutionException {
        if (this.scmManager == null) {
            this.scmManager = new BasicScmManager();
            String scmProviderID = this.getScmProviderID();
            if (!"git".equals(scmProviderID)) {
                throw new MojoExecutionException("Unsupported scm provider: " + scmProviderID + " or " + this.getIncorrectScmRepositoryUrlMsg());
            }
            this.scmManager.setScmProvider(scmProviderID, (ScmProvider)new CustomGitExeScmProvider());
        }
        return this.scmManager;
    }

    private String getScmProviderID() throws MojoExecutionException {
        try {
            return this.scmRepositoryUrl.split(":")[1];
        }
        catch (Exception e) {
            throw new MojoExecutionException(this.getIncorrectScmRepositoryUrlMsg(), e);
        }
    }

    String getIncorrectScmRepositoryUrlMsg() {
        return "the scmRepositoryUrl property with value '" + this.scmRepositoryUrl + "' is incorrect. " + "The URL has to respect the format: scm:[provider]:[provider_specific_url]";
    }

    ScmRepository getScmRepository() throws MojoExecutionException {
        if (this.scmRepository == null) {
            try {
                this.scmRepository = this.getScmManager().makeScmRepository(this.scmRepositoryUrl);
            }
            catch (NoSuchScmProviderException e) {
                throw new MojoExecutionException("Could not find a provider.", (Exception)((Object)e));
            }
            catch (ScmRepositoryException e) {
                throw new MojoExecutionException("Error while connecting to the repository", (Exception)((Object)e));
            }
        }
        return this.scmRepository;
    }

    List<File> getChangedFiles() throws MojoExecutionException, MojoFailureException {
        try {
            this.localScmRootPath = this.getLocalScmRootPath(this.project.getBasedir());
            ScmFileSet workspaceFileSet = new ScmFileSet(new File(this.localScmRootPath));
            DiffScmResult diffMasterHeadResult = this.getScmManager().diff(this.getScmRepository(), workspaceFileSet, null, null);
            this.ensureCommandSuccess((ScmResult)diffMasterHeadResult, "diff " + this.gitMasterBranchName + "...HEAD .");
            StatusScmResult statusResult = this.getScmManager().status(this.getScmRepository(), workspaceFileSet);
            this.ensureCommandSuccess((ScmResult)statusResult, "status");
            ArrayList<File> changedFilePaths = new ArrayList<File>();
            this.addToChangedFiles(diffMasterHeadResult.getChangedFiles(), this.localScmRootPath, changedFilePaths);
            this.addToChangedFiles(statusResult.getChangedFiles(), this.localScmRootPath, changedFilePaths);
            return changedFilePaths;
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Encountered an error while examining modified files,  SCM status:  " + e.getMessage() + "No further checks will be performed.", (Exception)((Object)e));
        }
    }

    private String getLocalScmRootPath(File basedir) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)basedir, (String)"rev-parse");
        cl.addArguments(new String[]{"--show-toplevel"});
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        ScmLogDispatcher dummyLogger = new ScmLogDispatcher();
        int exitCode = GitCommandLineUtils.execute((Commandline)cl, (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)dummyLogger);
        return exitCode == 0 ? stdout.getOutput().trim().replace(" ", "%20") : basedir.getPath();
    }

    private void ensureCommandSuccess(ScmResult result, String cmd) throws MojoFailureException {
        if (!result.isSuccess()) {
            String message = "Impossible to perform scm " + cmd + " command because " + result.getCommandOutput();
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
    }

    private void addToChangedFiles(List<ScmFile> scmChangedFiles, String rootPath, List<File> changedFiles) {
        for (ScmFile scmFile : scmChangedFiles) {
            String scmFilePath = scmFile.getPath();
            File file = new File(rootPath, scmFilePath);
            if (scmFile.getStatus() == ScmFileStatus.UNKNOWN || !file.exists() || changedFiles.contains(file) || this.fileIsDisabled(scmFilePath)) continue;
            changedFiles.add(file);
        }
    }

    private boolean fileIsDisabled(String scmFilePath) {
        if (this.disabledFiles == null) {
            return false;
        }
        for (String disableFile : this.disabledFiles) {
            String regexp = disableFile.replace("**/", "(.+/)+").replace("?", ".?").replace("*", ".*?");
            if (!scmFilePath.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    void checkCopyrights() throws MojoExecutionException, MojoFailureException {
        for (File changedFile : this.getChangedFiles()) {
            if (!changedFile.exists() || !changedFile.isFile() || !CHECKED_EXTENSIONS.contains(CopyrightAbstractMojo.resolveExtension(changedFile.getPath()).toLowerCase()) || this.fileNameEquals("bin", changedFile.getParentFile()) && this.fileNameEquals("resource", changedFile.getParentFile().getParentFile()) || this.checkCopyrightForFile(changedFile)) continue;
            this.incorrectCopyrightFilePaths.add(changedFile.getAbsolutePath());
        }
    }

    private boolean fileNameEquals(String folderName, File file) {
        return file != null && folderName.equals(file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCopyrightForFile(File changedFile) throws MojoExecutionException {
        try (BufferedReader reader = new BufferedReader(new FileReader(changedFile));){
            String line;
            CommentParser commentParser = CommentParser.createParserForFile(changedFile.getPath());
            while ((line = reader.readLine()) != null) {
                commentParser.consumeLine(line);
                if (!commentParser.isCommentLine() || !line.toLowerCase().trim().contains("copyright") || !line.contains(this.currentYear.toString()) || !line.contains(this.copyrightOwnerToken)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not read file " + changedFile.getPath() + " to check copyright date. No further copyright date checking will be performed.");
        }
    }

    String printFilePath(String filePath) {
        return this.printRelativeFilePath ? filePath.replace(this.localScmRootPath + File.separator, "") : filePath;
    }

    static enum CommentParser {
        BAT("rem"),
        DEFAULT("#", "*", "!", "//"),
        JAVA("/*", "*/", Arrays.asList("*", "//", "")),
        MC(";"),
        SH("#"),
        XML("<!--", "-->", Arrays.asList("!", "~", ""));

        private final String startBlock;
        private final String endBlock;
        private final List<String> middleBlockTokens;
        private String currentLine = "";
        private boolean supportCommentBlocks;
        private boolean commentBlockOpened;

        static CommentParser createParserForFile(String filePath) {
            switch (CopyrightAbstractMojo.resolveExtension(filePath)) {
                case "java": 
                case "c": 
                case "h": {
                    return JAVA;
                }
                case "fml": 
                case "html": 
                case "md": 
                case "xjb": 
                case "xml": 
                case "xml.vm": 
                case "xsd": 
                case "xsl": {
                    return XML;
                }
                case "bat": {
                    return BAT;
                }
                case "security": 
                case "sh": 
                case "ldif": 
                case "properties": {
                    return SH;
                }
                case "mc": {
                    return MC;
                }
            }
            return DEFAULT;
        }

        private CommentParser(String ... middleBlockTokens) {
            this(null, null, Arrays.asList(middleBlockTokens));
        }

        private CommentParser(String startBlock, String endBlock, List<String> middleBlockTokens) {
            this.startBlock = startBlock;
            this.endBlock = endBlock;
            this.middleBlockTokens = middleBlockTokens;
            this.supportCommentBlocks = startBlock != null && endBlock != null;
        }

        void consumeLine(String line) {
            if (line != null) {
                if (this.supportCommentBlocks && this.currentLine.endsWith(this.endBlock)) {
                    this.commentBlockOpened = false;
                }
                this.currentLine = line.trim();
                if (this.supportCommentBlocks && this.currentLine.startsWith(this.startBlock)) {
                    this.commentBlockOpened = true;
                }
            }
        }

        boolean isCommentLine() {
            return this.commentBlockOpened || this.startsWithCommentLineToken();
        }

        private boolean startsWithCommentLineToken() {
            return this.getCommentTokenInLine(this.currentLine) != null;
        }

        private String getCommentTokenInLine(String line) {
            for (String token : this.middleBlockTokens) {
                if (!line.startsWith(token)) continue;
                return token;
            }
            return null;
        }

        String getNewCommentedLine(String line) throws Exception {
            String commentToken = this.getCommentTokenInLine(line.trim());
            if (commentToken == null) {
                throw new Exception("Incompatibles comments lines in the file.");
            }
            String resultLine = "";
            if (commentToken.isEmpty()) {
                resultLine = " ";
            }
            return resultLine + line.substring(0, line.indexOf(commentToken) + commentToken.length());
        }

        boolean isNonEmptyCommentedLine() {
            String commentToken = this.getCommentTokenInLine(this.currentLine);
            return commentToken == null || !commentToken.equals(this.currentLine);
        }
    }

    private class CustomGitDiffCommand
    extends GitDiffCommand
    implements GitCommand {
        private CustomGitDiffCommand() {
        }

        protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion unused, ScmVersion unused2) throws ScmException {
            GitDiffConsumer consumer = new GitDiffConsumer(this.getLogger(), fileSet.getBasedir());
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)fileSet.getBasedir(), (String)"diff");
            cl.addArguments(new String[]{"--no-ext-diff", "--relative", CopyrightAbstractMojo.this.gitMasterBranchName + "...HEAD", "."});
            if (GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger()) != 0) {
                return new DiffScmResult(cl.toString(), "The git-diff command failed.", stderr.getOutput(), false);
            }
            return new DiffScmResult(cl.toString(), consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
        }
    }

    private final class CustomGitExeScmProvider
    extends GitExeScmProvider {
        private CustomGitExeScmProvider() {
        }

        protected GitCommand getDiffCommand() {
            return new CustomGitDiffCommand();
        }
    }
}

