/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelationOption;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.RootDNCfgClient;
import org.forgerock.opendj.server.config.client.RootDNUserCfgClient;
import org.forgerock.opendj.server.config.meta.RootDNUserCfgDefn;
import org.forgerock.opendj.server.config.server.RootDNCfg;
import org.forgerock.opendj.server.config.server.RootDNUserCfg;

public final class RootDNCfgDefn
extends ManagedObjectDefinition<RootDNCfgClient, RootDNCfg> {
    private static final RootDNCfgDefn INSTANCE = new RootDNCfgDefn();
    private static final EnumPropertyDefinition<DefaultRootPrivilegeName> PD_DEFAULT_ROOT_PRIVILEGE_NAME;
    private static final InstantiableRelationDefinition<RootDNUserCfgClient, RootDNUserCfg> RD_ROOT_DN_USERS;

    public static RootDNCfgDefn getInstance() {
        return INSTANCE;
    }

    private RootDNCfgDefn() {
        super("root-dn", TopCfgDefn.getInstance());
    }

    @Override
    public RootDNCfgClient createClientConfiguration(ManagedObject<? extends RootDNCfgClient> impl) {
        return new RootDNCfgClientImpl(impl);
    }

    @Override
    public RootDNCfg createServerConfiguration(ServerManagedObject<? extends RootDNCfg> impl) {
        return new RootDNCfgServerImpl(impl);
    }

    @Override
    public Class<RootDNCfg> getServerConfigurationClass() {
        return RootDNCfg.class;
    }

    public EnumPropertyDefinition<DefaultRootPrivilegeName> getDefaultRootPrivilegeNamePropertyDefinition() {
        return PD_DEFAULT_ROOT_PRIVILEGE_NAME;
    }

    public InstantiableRelationDefinition<RootDNUserCfgClient, RootDNUserCfg> getRootDNUsersRelationDefinition() {
        return RD_ROOT_DN_USERS;
    }

    static {
        Object builder = EnumPropertyDefinition.createBuilder(INSTANCE, "default-root-privilege-name");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "default-root-privilege-name"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("bypass-lockdown", "bypass-acl", "modify-acl", "config-read", "config-write", "ldif-import", "ldif-export", "backend-backup", "backend-restore", "server-lockdown", "server-shutdown", "server-restart", "disconnect-client", "cancel-request", "password-reset", "update-schema", "privilege-change", "unindexed-search", "subentry-write", "changelog-read");
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(DefaultRootPrivilegeName.class);
        PD_DEFAULT_ROOT_PRIVILEGE_NAME = (EnumPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEFAULT_ROOT_PRIVILEGE_NAME);
        builder = new InstantiableRelationDefinition.Builder<RootDNUserCfgClient, RootDNUserCfg>(INSTANCE, "root-dn-user", "root-dn-users", RootDNUserCfgDefn.getInstance());
        ((RelationDefinition.AbstractBuilder)builder).setOption(RelationOption.HIDDEN);
        RD_ROOT_DN_USERS = (InstantiableRelationDefinition)((RelationDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerRelationDefinition(RD_ROOT_DN_USERS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class RootDNCfgServerImpl
    implements RootDNCfg {
        private ServerManagedObject<? extends RootDNCfg> impl;
        private final SortedSet<DefaultRootPrivilegeName> pDefaultRootPrivilegeName;

        private RootDNCfgServerImpl(ServerManagedObject<? extends RootDNCfg> impl) {
            this.impl = impl;
            this.pDefaultRootPrivilegeName = impl.getPropertyValues(INSTANCE.getDefaultRootPrivilegeNamePropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<RootDNCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<RootDNCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<DefaultRootPrivilegeName> getDefaultRootPrivilegeName() {
            return this.pDefaultRootPrivilegeName;
        }

        @Override
        public String[] listRootDNUsers() {
            return this.impl.listChildren(INSTANCE.getRootDNUsersRelationDefinition());
        }

        @Override
        public RootDNUserCfg getRootDNUser(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getRootDNUsersRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addRootDNUserAddListener(ConfigurationAddListener<RootDNUserCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public void removeRootDNUserAddListener(ConfigurationAddListener<RootDNUserCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public void addRootDNUserDeleteListener(ConfigurationDeleteListener<RootDNUserCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public void removeRootDNUserDeleteListener(ConfigurationDeleteListener<RootDNUserCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public Class<? extends RootDNCfg> configurationClass() {
            return RootDNCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class RootDNCfgClientImpl
    implements RootDNCfgClient {
        private ManagedObject<? extends RootDNCfgClient> impl;

        private RootDNCfgClientImpl(ManagedObject<? extends RootDNCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<DefaultRootPrivilegeName> getDefaultRootPrivilegeName() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultRootPrivilegeNamePropertyDefinition());
        }

        @Override
        public void setDefaultRootPrivilegeName(Collection<DefaultRootPrivilegeName> values) {
            this.impl.setPropertyValues(INSTANCE.getDefaultRootPrivilegeNamePropertyDefinition(), values);
        }

        @Override
        public String[] listRootDNUsers() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getRootDNUsersRelationDefinition());
        }

        @Override
        public RootDNUserCfgClient getRootDNUser(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getRootDNUsersRelationDefinition(), name).getConfiguration();
        }

        public <M extends RootDNUserCfgClient> M createRootDNUser(ManagedObjectDefinition<M, ? extends RootDNUserCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((RootDNUserCfgClient)this.impl.createChild(INSTANCE.getRootDNUsersRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeRootDNUser(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getRootDNUsersRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends RootDNCfgClient, ? extends RootDNCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum DefaultRootPrivilegeName {
        BACKEND_BACKUP("backend-backup"),
        BACKEND_RESTORE("backend-restore"),
        BYPASS_ACL("bypass-acl"),
        BYPASS_LOCKDOWN("bypass-lockdown"),
        CANCEL_REQUEST("cancel-request"),
        CHANGELOG_READ("changelog-read"),
        CONFIG_READ("config-read"),
        CONFIG_WRITE("config-write"),
        DATA_SYNC("data-sync"),
        DISCONNECT_CLIENT("disconnect-client"),
        JMX_NOTIFY("jmx-notify"),
        JMX_READ("jmx-read"),
        JMX_WRITE("jmx-write"),
        LDIF_EXPORT("ldif-export"),
        LDIF_IMPORT("ldif-import"),
        MODIFY_ACL("modify-acl"),
        PASSWORD_RESET("password-reset"),
        PRIVILEGE_CHANGE("privilege-change"),
        PROXIED_AUTH("proxied-auth"),
        SERVER_LOCKDOWN("server-lockdown"),
        SERVER_RESTART("server-restart"),
        SERVER_SHUTDOWN("server-shutdown"),
        SUBENTRY_WRITE("subentry-write"),
        UNINDEXED_SEARCH("unindexed-search"),
        UPDATE_SCHEMA("update-schema");

        private final String name;

        private DefaultRootPrivilegeName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

