/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefaultManagedObject;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.server.config.client.BackendIndexCfgClient;
import org.forgerock.opendj.server.config.client.BackendVLVIndexCfgClient;
import org.forgerock.opendj.server.config.client.PluggableBackendCfgClient;
import org.forgerock.opendj.server.config.meta.BackendCfgDefn;
import org.forgerock.opendj.server.config.meta.BackendIndexCfgDefn;
import org.forgerock.opendj.server.config.meta.BackendVLVIndexCfgDefn;
import org.forgerock.opendj.server.config.server.BackendIndexCfg;
import org.forgerock.opendj.server.config.server.BackendVLVIndexCfg;
import org.forgerock.opendj.server.config.server.PluggableBackendCfg;

public final class PluggableBackendCfgDefn
extends AbstractManagedObjectDefinition<PluggableBackendCfgClient, PluggableBackendCfg> {
    private static final PluggableBackendCfgDefn INSTANCE = new PluggableBackendCfgDefn();
    private static final IntegerPropertyDefinition PD_CIPHER_KEY_LENGTH;
    private static final StringPropertyDefinition PD_CIPHER_TRANSFORMATION;
    private static final BooleanPropertyDefinition PD_COMPACT_ENCODING;
    private static final BooleanPropertyDefinition PD_CONFIDENTIALITY_ENABLED;
    private static final BooleanPropertyDefinition PD_ENTRIES_COMPRESSED;
    private static final SizePropertyDefinition PD_IMPORT_OFFHEAP_MEMORY_SIZE;
    private static final IntegerPropertyDefinition PD_INDEX_ENTRY_LIMIT;
    private static final BooleanPropertyDefinition PD_INDEX_FILTER_ANALYZER_ENABLED;
    private static final IntegerPropertyDefinition PD_INDEX_FILTER_ANALYZER_MAX_FILTERS;
    private static final DurationPropertyDefinition PD_PRELOAD_TIME_LIMIT;
    private static final EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> PD_WRITABILITY_MODE;
    private static final InstantiableRelationDefinition<BackendIndexCfgClient, BackendIndexCfg> RD_BACKEND_INDEXES;
    private static final InstantiableRelationDefinition<BackendVLVIndexCfgClient, BackendVLVIndexCfg> RD_BACKEND_VLV_INDEXES;

    public static PluggableBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private PluggableBackendCfgDefn() {
        super("pluggable-backend", BackendCfgDefn.getInstance());
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendIdPropertyDefinition();
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBaseDNPropertyDefinition();
    }

    public IntegerPropertyDefinition getCipherKeyLengthPropertyDefinition() {
        return PD_CIPHER_KEY_LENGTH;
    }

    public StringPropertyDefinition getCipherTransformationPropertyDefinition() {
        return PD_CIPHER_TRANSFORMATION;
    }

    public BooleanPropertyDefinition getCompactEncodingPropertyDefinition() {
        return PD_COMPACT_ENCODING;
    }

    public BooleanPropertyDefinition getConfidentialityEnabledPropertyDefinition() {
        return PD_CONFIDENTIALITY_ENABLED;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return BackendCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getEntriesCompressedPropertyDefinition() {
        return PD_ENTRIES_COMPRESSED;
    }

    public SizePropertyDefinition getImportOffheapMemorySizePropertyDefinition() {
        return PD_IMPORT_OFFHEAP_MEMORY_SIZE;
    }

    public IntegerPropertyDefinition getIndexEntryLimitPropertyDefinition() {
        return PD_INDEX_ENTRY_LIMIT;
    }

    public BooleanPropertyDefinition getIndexFilterAnalyzerEnabledPropertyDefinition() {
        return PD_INDEX_FILTER_ANALYZER_ENABLED;
    }

    public IntegerPropertyDefinition getIndexFilterAnalyzerMaxFiltersPropertyDefinition() {
        return PD_INDEX_FILTER_ANALYZER_MAX_FILTERS;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return BackendCfgDefn.getInstance().getJavaClassPropertyDefinition();
    }

    public DurationPropertyDefinition getPreloadTimeLimitPropertyDefinition() {
        return PD_PRELOAD_TIME_LIMIT;
    }

    public EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> getWritabilityModePropertyDefinition() {
        return PD_WRITABILITY_MODE;
    }

    public InstantiableRelationDefinition<BackendIndexCfgClient, BackendIndexCfg> getBackendIndexesRelationDefinition() {
        return RD_BACKEND_INDEXES;
    }

    public InstantiableRelationDefinition<BackendVLVIndexCfgClient, BackendVLVIndexCfg> getBackendVLVIndexesRelationDefinition() {
        return RD_BACKEND_VLV_INDEXES;
    }

    static {
        InstantiableRelationDefinition.Builder<BackendVLVIndexCfgClient, BackendVLVIndexCfg> builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "cipher-key-length");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cipher-key-length"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("128");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_CIPHER_KEY_LENGTH = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_CIPHER_KEY_LENGTH);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "cipher-transformation");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cipher-transformation"));
        provider = new DefinedDefaultBehaviorProvider("AES/CBC/PKCS5Padding");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_CIPHER_TRANSFORMATION = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_CIPHER_TRANSFORMATION);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "compact-encoding");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "compact-encoding"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_COMPACT_ENCODING = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_COMPACT_ENCODING);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "confidentiality-enabled");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "confidentiality-enabled"));
        provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_CONFIDENTIALITY_ENABLED = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONFIDENTIALITY_ENABLED);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "entries-compressed");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "entries-compressed"));
        provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_ENTRIES_COMPRESSED = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENTRIES_COMPRESSED);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "import-offheap-memory-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "import-offheap-memory-size"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "import-offheap-memory-size"));
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("0 MB");
        PD_IMPORT_OFFHEAP_MEMORY_SIZE = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_IMPORT_OFFHEAP_MEMORY_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "index-entry-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "index-entry-limit"));
        provider = new DefinedDefaultBehaviorProvider("4000");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_INDEX_ENTRY_LIMIT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_ENTRY_LIMIT);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "index-filter-analyzer-enabled");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "index-filter-analyzer-enabled"));
        provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_INDEX_FILTER_ANALYZER_ENABLED = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_FILTER_ANALYZER_ENABLED);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "index-filter-analyzer-max-filters");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "index-filter-analyzer-max-filters"));
        provider = new DefinedDefaultBehaviorProvider("25");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_INDEX_FILTER_ANALYZER_MAX_FILTERS = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_FILTER_ANALYZER_MAX_FILTERS);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "preload-time-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "preload-time-limit"));
        provider = new DefinedDefaultBehaviorProvider("0s");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)((Object)builder)).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setLowerLimit("0");
        PD_PRELOAD_TIME_LIMIT = (DurationPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRELOAD_TIME_LIMIT);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "writability-mode");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "writability-mode"));
        provider = new DefinedDefaultBehaviorProvider("enabled");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)((Object)builder)).setEnumClass(BackendCfgDefn.WritabilityMode.class);
        PD_WRITABILITY_MODE = (EnumPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_WRITABILITY_MODE);
        builder = new InstantiableRelationDefinition.Builder<BackendIndexCfgClient, BackendIndexCfg>(INSTANCE, "backend-index", "backend-indexes", BackendIndexCfgDefn.getInstance());
        builder.setNamingProperty(BackendIndexCfgDefn.getInstance().getAttributePropertyDefinition());
        DefaultManagedObject.Builder<BackendIndexCfgClient, BackendIndexCfg> dmoBuilder = new DefaultManagedObject.Builder<BackendIndexCfgClient, BackendIndexCfg>(BackendIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "presence");
        dmoBuilder.setPropertyValues("attribute", "aci");
        builder.setDefaultManagedObject("aci", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<BackendIndexCfgClient, BackendIndexCfg>(BackendIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "equality");
        dmoBuilder.setPropertyValues("attribute", "entryUUID");
        builder.setDefaultManagedObject("entryUUID", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<BackendIndexCfgClient, BackendIndexCfg>(BackendIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "equality");
        dmoBuilder.setPropertyValues("attribute", "objectClass");
        builder.setDefaultManagedObject("objectClass", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<BackendIndexCfgClient, BackendIndexCfg>(BackendIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "ordering");
        dmoBuilder.setPropertyValues("attribute", "ds-sync-hist");
        builder.setDefaultManagedObject("ds-sync-hist", dmoBuilder.getInstance());
        dmoBuilder = new DefaultManagedObject.Builder<BackendIndexCfgClient, BackendIndexCfg>(BackendIndexCfgDefn.getInstance());
        dmoBuilder.setPropertyValues("index-type", "equality");
        dmoBuilder.setPropertyValues("attribute", "ds-sync-conflict");
        builder.setDefaultManagedObject("ds-sync-conflict", dmoBuilder.getInstance());
        RD_BACKEND_INDEXES = (InstantiableRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_BACKEND_INDEXES);
        builder = new InstantiableRelationDefinition.Builder<BackendVLVIndexCfgClient, BackendVLVIndexCfg>(INSTANCE, "backend-vlv-index", "backend-vlv-indexes", BackendVLVIndexCfgDefn.getInstance());
        builder.setNamingProperty(BackendVLVIndexCfgDefn.getInstance().getNamePropertyDefinition());
        RD_BACKEND_VLV_INDEXES = (InstantiableRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_BACKEND_VLV_INDEXES);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }
}

