/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.JsonSchemaCfgClient;
import org.forgerock.opendj.server.config.meta.SchemaProviderCfgDefn;
import org.forgerock.opendj.server.config.server.JsonSchemaCfg;
import org.forgerock.opendj.server.config.server.SchemaProviderCfg;

public final class JsonSchemaCfgDefn
extends ManagedObjectDefinition<JsonSchemaCfgClient, JsonSchemaCfg> {
    private static final JsonSchemaCfgDefn INSTANCE = new JsonSchemaCfgDefn();
    private static final BooleanPropertyDefinition PD_CASE_SENSITIVE_STRINGS;
    private static final BooleanPropertyDefinition PD_IGNORE_WHITE_SPACE;
    private static final StringPropertyDefinition PD_INDEXED_FIELD;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_MATCHING_RULE_NAME;
    private static final StringPropertyDefinition PD_MATCHING_RULE_OID;

    public static JsonSchemaCfgDefn getInstance() {
        return INSTANCE;
    }

    private JsonSchemaCfgDefn() {
        super("json-schema", SchemaProviderCfgDefn.getInstance());
    }

    @Override
    public JsonSchemaCfgClient createClientConfiguration(ManagedObject<? extends JsonSchemaCfgClient> impl) {
        return new JsonSchemaCfgClientImpl(impl);
    }

    @Override
    public JsonSchemaCfg createServerConfiguration(ServerManagedObject<? extends JsonSchemaCfg> impl) {
        return new JsonSchemaCfgServerImpl(impl);
    }

    @Override
    public Class<JsonSchemaCfg> getServerConfigurationClass() {
        return JsonSchemaCfg.class;
    }

    public BooleanPropertyDefinition getCaseSensitiveStringsPropertyDefinition() {
        return PD_CASE_SENSITIVE_STRINGS;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return SchemaProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getIgnoreWhiteSpacePropertyDefinition() {
        return PD_IGNORE_WHITE_SPACE;
    }

    public StringPropertyDefinition getIndexedFieldPropertyDefinition() {
        return PD_INDEXED_FIELD;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getMatchingRuleNamePropertyDefinition() {
        return PD_MATCHING_RULE_NAME;
    }

    public StringPropertyDefinition getMatchingRuleOidPropertyDefinition() {
        return PD_MATCHING_RULE_OID;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "case-sensitive-strings");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "case-sensitive-strings"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_CASE_SENSITIVE_STRINGS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CASE_SENSITIVE_STRINGS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "ignore-white-space");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ignore-white-space"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_IGNORE_WHITE_SPACE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IGNORE_WHITE_SPACE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "indexed-field");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "indexed-field"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "indexed-field"));
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "PATTERN");
        PD_INDEXED_FIELD = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEXED_FIELD);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.schema.JsonSchemaProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.schema.SchemaProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "matching-rule-name");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "matching-rule-name"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "matching-rule-name"));
        PD_MATCHING_RULE_NAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MATCHING_RULE_NAME);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "matching-rule-oid");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "matching-rule-oid"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-9.]+\\d)$", "OID");
        PD_MATCHING_RULE_OID = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MATCHING_RULE_OID);
    }

    private static class JsonSchemaCfgServerImpl
    implements JsonSchemaCfg {
        private ServerManagedObject<? extends JsonSchemaCfg> impl;
        private final boolean pCaseSensitiveStrings;
        private final boolean pEnabled;
        private final boolean pIgnoreWhiteSpace;
        private final SortedSet<String> pIndexedField;
        private final String pJavaClass;
        private final String pMatchingRuleName;
        private final String pMatchingRuleOid;

        private JsonSchemaCfgServerImpl(ServerManagedObject<? extends JsonSchemaCfg> impl) {
            this.impl = impl;
            this.pCaseSensitiveStrings = impl.getPropertyValue(INSTANCE.getCaseSensitiveStringsPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIgnoreWhiteSpace = impl.getPropertyValue(INSTANCE.getIgnoreWhiteSpacePropertyDefinition());
            this.pIndexedField = impl.getPropertyValues((PropertyDefinition)INSTANCE.getIndexedFieldPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMatchingRuleName = impl.getPropertyValue(INSTANCE.getMatchingRuleNamePropertyDefinition());
            this.pMatchingRuleOid = impl.getPropertyValue(INSTANCE.getMatchingRuleOidPropertyDefinition());
        }

        @Override
        public void addJsonSchemaChangeListener(ConfigurationChangeListener<JsonSchemaCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeJsonSchemaChangeListener(ConfigurationChangeListener<JsonSchemaCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<SchemaProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<SchemaProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isCaseSensitiveStrings() {
            return this.pCaseSensitiveStrings;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isIgnoreWhiteSpace() {
            return this.pIgnoreWhiteSpace;
        }

        @Override
        public SortedSet<String> getIndexedField() {
            return this.pIndexedField;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getMatchingRuleName() {
            return this.pMatchingRuleName;
        }

        @Override
        public String getMatchingRuleOid() {
            return this.pMatchingRuleOid;
        }

        @Override
        public Class<? extends JsonSchemaCfg> configurationClass() {
            return JsonSchemaCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class JsonSchemaCfgClientImpl
    implements JsonSchemaCfgClient {
        private ManagedObject<? extends JsonSchemaCfgClient> impl;

        private JsonSchemaCfgClientImpl(ManagedObject<? extends JsonSchemaCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isCaseSensitiveStrings() {
            return this.impl.getPropertyValue(INSTANCE.getCaseSensitiveStringsPropertyDefinition());
        }

        @Override
        public void setCaseSensitiveStrings(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCaseSensitiveStringsPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isIgnoreWhiteSpace() {
            return this.impl.getPropertyValue(INSTANCE.getIgnoreWhiteSpacePropertyDefinition());
        }

        @Override
        public void setIgnoreWhiteSpace(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIgnoreWhiteSpacePropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getIndexedField() {
            return this.impl.getPropertyValues(INSTANCE.getIndexedFieldPropertyDefinition());
        }

        @Override
        public void setIndexedField(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getIndexedFieldPropertyDefinition(), values);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getMatchingRuleName() {
            return this.impl.getPropertyValue(INSTANCE.getMatchingRuleNamePropertyDefinition());
        }

        @Override
        public void setMatchingRuleName(String value) {
            this.impl.setPropertyValue(INSTANCE.getMatchingRuleNamePropertyDefinition(), value);
        }

        @Override
        public String getMatchingRuleOid() {
            return this.impl.getPropertyValue(INSTANCE.getMatchingRuleOidPropertyDefinition());
        }

        @Override
        public void setMatchingRuleOid(String value) {
            this.impl.setPropertyValue(INSTANCE.getMatchingRuleOidPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends JsonSchemaCfgClient, ? extends JsonSchemaCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

