/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.GenericConstraint;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.BackendIndexCfgClient;
import org.forgerock.opendj.server.config.client.BackendVLVIndexCfgClient;
import org.forgerock.opendj.server.config.client.JEBackendCfgClient;
import org.forgerock.opendj.server.config.meta.BackendCfgDefn;
import org.forgerock.opendj.server.config.meta.PluggableBackendCfgDefn;
import org.forgerock.opendj.server.config.server.BackendCfg;
import org.forgerock.opendj.server.config.server.BackendIndexCfg;
import org.forgerock.opendj.server.config.server.BackendVLVIndexCfg;
import org.forgerock.opendj.server.config.server.JEBackendCfg;
import org.forgerock.opendj.server.config.server.PluggableBackendCfg;

public final class JEBackendCfgDefn
extends ManagedObjectDefinition<JEBackendCfgClient, JEBackendCfg> {
    private static final JEBackendCfgDefn INSTANCE = new JEBackendCfgDefn();
    private static final IntegerPropertyDefinition PD_DB_CACHE_PERCENT;
    private static final SizePropertyDefinition PD_DB_CACHE_SIZE;
    private static final SizePropertyDefinition PD_DB_CHECKPOINTER_BYTES_INTERVAL;
    private static final DurationPropertyDefinition PD_DB_CHECKPOINTER_WAKEUP_INTERVAL;
    private static final IntegerPropertyDefinition PD_DB_CLEANER_MIN_UTILIZATION;
    private static final StringPropertyDefinition PD_DB_DIRECTORY;
    private static final StringPropertyDefinition PD_DB_DIRECTORY_PERMISSIONS;
    private static final IntegerPropertyDefinition PD_DB_EVICTOR_CORE_THREADS;
    private static final DurationPropertyDefinition PD_DB_EVICTOR_KEEP_ALIVE;
    private static final BooleanPropertyDefinition PD_DB_EVICTOR_LRU_ONLY;
    private static final IntegerPropertyDefinition PD_DB_EVICTOR_MAX_THREADS;
    private static final IntegerPropertyDefinition PD_DB_EVICTOR_NODES_PER_SCAN;
    private static final IntegerPropertyDefinition PD_DB_LOG_FILECACHE_SIZE;
    private static final SizePropertyDefinition PD_DB_LOG_FILE_MAX;
    private static final BooleanPropertyDefinition PD_DB_LOGGING_FILE_HANDLER_ON;
    private static final StringPropertyDefinition PD_DB_LOGGING_LEVEL;
    private static final IntegerPropertyDefinition PD_DB_NUM_CLEANER_THREADS;
    private static final IntegerPropertyDefinition PD_DB_NUM_LOCK_TABLES;
    private static final BooleanPropertyDefinition PD_DB_RUN_CLEANER;
    private static final BooleanPropertyDefinition PD_DB_TXN_NO_SYNC;
    private static final BooleanPropertyDefinition PD_DB_TXN_WRITE_NO_SYNC;
    private static final SizePropertyDefinition PD_DISK_FULL_THRESHOLD;
    private static final SizePropertyDefinition PD_DISK_LOW_THRESHOLD;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_JE_PROPERTY;

    public static JEBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private JEBackendCfgDefn() {
        super("je-backend", PluggableBackendCfgDefn.getInstance());
    }

    @Override
    public JEBackendCfgClient createClientConfiguration(ManagedObject<? extends JEBackendCfgClient> impl) {
        return new JEBackendCfgClientImpl(impl);
    }

    @Override
    public JEBackendCfg createServerConfiguration(ServerManagedObject<? extends JEBackendCfg> impl) {
        return new JEBackendCfgServerImpl(impl);
    }

    @Override
    public Class<JEBackendCfg> getServerConfigurationClass() {
        return JEBackendCfg.class;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBackendIdPropertyDefinition();
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBaseDNPropertyDefinition();
    }

    public IntegerPropertyDefinition getCipherKeyLengthPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getCipherKeyLengthPropertyDefinition();
    }

    public StringPropertyDefinition getCipherTransformationPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getCipherTransformationPropertyDefinition();
    }

    public BooleanPropertyDefinition getCompactEncodingPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getCompactEncodingPropertyDefinition();
    }

    public BooleanPropertyDefinition getConfidentialityEnabledPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getConfidentialityEnabledPropertyDefinition();
    }

    public IntegerPropertyDefinition getDBCachePercentPropertyDefinition() {
        return PD_DB_CACHE_PERCENT;
    }

    public SizePropertyDefinition getDBCacheSizePropertyDefinition() {
        return PD_DB_CACHE_SIZE;
    }

    public SizePropertyDefinition getDBCheckpointerBytesIntervalPropertyDefinition() {
        return PD_DB_CHECKPOINTER_BYTES_INTERVAL;
    }

    public DurationPropertyDefinition getDBCheckpointerWakeupIntervalPropertyDefinition() {
        return PD_DB_CHECKPOINTER_WAKEUP_INTERVAL;
    }

    public IntegerPropertyDefinition getDBCleanerMinUtilizationPropertyDefinition() {
        return PD_DB_CLEANER_MIN_UTILIZATION;
    }

    public StringPropertyDefinition getDBDirectoryPropertyDefinition() {
        return PD_DB_DIRECTORY;
    }

    public StringPropertyDefinition getDBDirectoryPermissionsPropertyDefinition() {
        return PD_DB_DIRECTORY_PERMISSIONS;
    }

    public IntegerPropertyDefinition getDBEvictorCoreThreadsPropertyDefinition() {
        return PD_DB_EVICTOR_CORE_THREADS;
    }

    public DurationPropertyDefinition getDBEvictorKeepAlivePropertyDefinition() {
        return PD_DB_EVICTOR_KEEP_ALIVE;
    }

    public BooleanPropertyDefinition getDBEvictorLruOnlyPropertyDefinition() {
        return PD_DB_EVICTOR_LRU_ONLY;
    }

    public IntegerPropertyDefinition getDBEvictorMaxThreadsPropertyDefinition() {
        return PD_DB_EVICTOR_MAX_THREADS;
    }

    public IntegerPropertyDefinition getDBEvictorNodesPerScanPropertyDefinition() {
        return PD_DB_EVICTOR_NODES_PER_SCAN;
    }

    public IntegerPropertyDefinition getDBLogFilecacheSizePropertyDefinition() {
        return PD_DB_LOG_FILECACHE_SIZE;
    }

    public SizePropertyDefinition getDBLogFileMaxPropertyDefinition() {
        return PD_DB_LOG_FILE_MAX;
    }

    public BooleanPropertyDefinition getDBLoggingFileHandlerOnPropertyDefinition() {
        return PD_DB_LOGGING_FILE_HANDLER_ON;
    }

    public StringPropertyDefinition getDBLoggingLevelPropertyDefinition() {
        return PD_DB_LOGGING_LEVEL;
    }

    public IntegerPropertyDefinition getDBNumCleanerThreadsPropertyDefinition() {
        return PD_DB_NUM_CLEANER_THREADS;
    }

    public IntegerPropertyDefinition getDBNumLockTablesPropertyDefinition() {
        return PD_DB_NUM_LOCK_TABLES;
    }

    public BooleanPropertyDefinition getDBRunCleanerPropertyDefinition() {
        return PD_DB_RUN_CLEANER;
    }

    public BooleanPropertyDefinition getDBTxnNoSyncPropertyDefinition() {
        return PD_DB_TXN_NO_SYNC;
    }

    public BooleanPropertyDefinition getDBTxnWriteNoSyncPropertyDefinition() {
        return PD_DB_TXN_WRITE_NO_SYNC;
    }

    public SizePropertyDefinition getDiskFullThresholdPropertyDefinition() {
        return PD_DISK_FULL_THRESHOLD;
    }

    public SizePropertyDefinition getDiskLowThresholdPropertyDefinition() {
        return PD_DISK_LOW_THRESHOLD;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getEntriesCompressedPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getEntriesCompressedPropertyDefinition();
    }

    public SizePropertyDefinition getImportOffheapMemorySizePropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getImportOffheapMemorySizePropertyDefinition();
    }

    public IntegerPropertyDefinition getIndexEntryLimitPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getIndexEntryLimitPropertyDefinition();
    }

    public BooleanPropertyDefinition getIndexFilterAnalyzerEnabledPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getIndexFilterAnalyzerEnabledPropertyDefinition();
    }

    public IntegerPropertyDefinition getIndexFilterAnalyzerMaxFiltersPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getIndexFilterAnalyzerMaxFiltersPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getJEPropertyPropertyDefinition() {
        return PD_JE_PROPERTY;
    }

    public DurationPropertyDefinition getPreloadTimeLimitPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getPreloadTimeLimitPropertyDefinition();
    }

    public EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> getWritabilityModePropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getWritabilityModePropertyDefinition();
    }

    public InstantiableRelationDefinition<BackendIndexCfgClient, BackendIndexCfg> getBackendIndexesRelationDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBackendIndexesRelationDefinition();
    }

    public InstantiableRelationDefinition<BackendVLVIndexCfgClient, BackendVLVIndexCfg> getBackendVLVIndexesRelationDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBackendVLVIndexesRelationDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-cache-percent");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cache-percent"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("50");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(90);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_DB_CACHE_PERCENT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CACHE_PERCENT);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "db-cache-size");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cache-size"));
        provider = new DefinedDefaultBehaviorProvider("0 MB");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("0 MB");
        PD_DB_CACHE_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CACHE_SIZE);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "db-checkpointer-bytes-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "db-checkpointer-bytes-interval"));
        provider = new DefinedDefaultBehaviorProvider("500mb");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setUpperLimit("9223372036854775807b");
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("0b");
        PD_DB_CHECKPOINTER_BYTES_INTERVAL = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CHECKPOINTER_BYTES_INTERVAL);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "db-checkpointer-wakeup-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-checkpointer-wakeup-interval"));
        provider = new DefinedDefaultBehaviorProvider("30s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("4294");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_DB_CHECKPOINTER_WAKEUP_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CHECKPOINTER_WAKEUP_INTERVAL);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-cleaner-min-utilization");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cleaner-min-utilization"));
        provider = new DefinedDefaultBehaviorProvider("50");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(90);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_DB_CLEANER_MIN_UTILIZATION = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CLEANER_MIN_UTILIZATION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-directory"));
        provider = new DefinedDefaultBehaviorProvider("db");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_DIRECTORY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-directory-permissions");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "db-directory-permissions"));
        provider = new DefinedDefaultBehaviorProvider("700");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^7[0-7][0-7]$", "MODE");
        PD_DB_DIRECTORY_PERMISSIONS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_DIRECTORY_PERMISSIONS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-evictor-core-threads");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-evictor-core-threads"));
        provider = new DefinedDefaultBehaviorProvider("1");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_DB_EVICTOR_CORE_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_EVICTOR_CORE_THREADS);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "db-evictor-keep-alive");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-evictor-keep-alive"));
        provider = new DefinedDefaultBehaviorProvider("600s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("86400");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_DB_EVICTOR_KEEP_ALIVE = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_EVICTOR_KEEP_ALIVE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-evictor-lru-only");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-evictor-lru-only"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_EVICTOR_LRU_ONLY = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_EVICTOR_LRU_ONLY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-evictor-max-threads");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-evictor-max-threads"));
        provider = new DefinedDefaultBehaviorProvider("10");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_DB_EVICTOR_MAX_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_EVICTOR_MAX_THREADS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-evictor-nodes-per-scan");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-evictor-nodes-per-scan"));
        provider = new DefinedDefaultBehaviorProvider("10");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(1000);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_DB_EVICTOR_NODES_PER_SCAN = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_EVICTOR_NODES_PER_SCAN);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-log-filecache-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-log-filecache-size"));
        provider = new DefinedDefaultBehaviorProvider("100");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(3);
        PD_DB_LOG_FILECACHE_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_LOG_FILECACHE_SIZE);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "db-log-file-max");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-log-file-max"));
        provider = new DefinedDefaultBehaviorProvider("100mb");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setUpperLimit("4gib");
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1mb");
        PD_DB_LOG_FILE_MAX = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_LOG_FILE_MAX);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-logging-file-handler-on");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-logging-file-handler-on"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_LOGGING_FILE_HANDLER_ON = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_LOGGING_FILE_HANDLER_ON);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-logging-level");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-logging-level"));
        provider = new DefinedDefaultBehaviorProvider("CONFIG");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_LOGGING_LEVEL = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_LOGGING_LEVEL);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-num-cleaner-threads");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-num-cleaner-threads"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "db-num-cleaner-threads"));
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_DB_NUM_CLEANER_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_NUM_CLEANER_THREADS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-num-lock-tables");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-num-lock-tables"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "db-num-lock-tables"));
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit((Integer)Short.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_DB_NUM_LOCK_TABLES = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_NUM_LOCK_TABLES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-run-cleaner");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-run-cleaner"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_RUN_CLEANER = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_RUN_CLEANER);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-txn-no-sync");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-txn-no-sync"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_TXN_NO_SYNC = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_TXN_NO_SYNC);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-txn-write-no-sync");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-txn-write-no-sync"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_TXN_WRITE_NO_SYNC = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_TXN_WRITE_NO_SYNC);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "disk-full-threshold");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disk-full-threshold"));
        provider = new DefinedDefaultBehaviorProvider("100 megabytes");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_DISK_FULL_THRESHOLD = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISK_FULL_THRESHOLD);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "disk-low-threshold");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disk-low-threshold"));
        provider = new DefinedDefaultBehaviorProvider("200 megabytes");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_DISK_LOW_THRESHOLD = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISK_LOW_THRESHOLD);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.jeb.JEBackend");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.Backend");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "je-property");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "je-property"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_JE_PROPERTY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JE_PROPERTY);
        INSTANCE.registerTag(Tag.valueOf("database"));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.implies(Conditions.contains("enabled", "true"), Conditions.not(Conditions.and(Conditions.contains("db-txn-no-sync", "true"), Conditions.contains("db-txn-write-no-sync", "true"))))));
    }

    private static class JEBackendCfgServerImpl
    implements JEBackendCfg {
        private ServerManagedObject<? extends JEBackendCfg> impl;
        private final String pBackendId;
        private final SortedSet<DN> pBaseDN;
        private final int pCipherKeyLength;
        private final String pCipherTransformation;
        private final boolean pCompactEncoding;
        private final boolean pConfidentialityEnabled;
        private final int pDBCachePercent;
        private final long pDBCacheSize;
        private final long pDBCheckpointerBytesInterval;
        private final long pDBCheckpointerWakeupInterval;
        private final int pDBCleanerMinUtilization;
        private final String pDBDirectory;
        private final String pDBDirectoryPermissions;
        private final int pDBEvictorCoreThreads;
        private final long pDBEvictorKeepAlive;
        private final boolean pDBEvictorLruOnly;
        private final int pDBEvictorMaxThreads;
        private final int pDBEvictorNodesPerScan;
        private final int pDBLogFilecacheSize;
        private final long pDBLogFileMax;
        private final boolean pDBLoggingFileHandlerOn;
        private final String pDBLoggingLevel;
        private final Integer pDBNumCleanerThreads;
        private final Integer pDBNumLockTables;
        private final boolean pDBRunCleaner;
        private final boolean pDBTxnNoSync;
        private final boolean pDBTxnWriteNoSync;
        private final long pDiskFullThreshold;
        private final long pDiskLowThreshold;
        private final boolean pEnabled;
        private final boolean pEntriesCompressed;
        private final Long pImportOffheapMemorySize;
        private final int pIndexEntryLimit;
        private final boolean pIndexFilterAnalyzerEnabled;
        private final int pIndexFilterAnalyzerMaxFilters;
        private final String pJavaClass;
        private final SortedSet<String> pJEProperty;
        private final long pPreloadTimeLimit;
        private final BackendCfgDefn.WritabilityMode pWritabilityMode;

        private JEBackendCfgServerImpl(ServerManagedObject<? extends JEBackendCfg> impl) {
            this.impl = impl;
            this.pBackendId = impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pCipherKeyLength = impl.getPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition());
            this.pCipherTransformation = impl.getPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition());
            this.pCompactEncoding = impl.getPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition());
            this.pConfidentialityEnabled = impl.getPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition());
            this.pDBCachePercent = impl.getPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition());
            this.pDBCacheSize = impl.getPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition());
            this.pDBCheckpointerBytesInterval = impl.getPropertyValue(INSTANCE.getDBCheckpointerBytesIntervalPropertyDefinition());
            this.pDBCheckpointerWakeupInterval = impl.getPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition());
            this.pDBCleanerMinUtilization = impl.getPropertyValue(INSTANCE.getDBCleanerMinUtilizationPropertyDefinition());
            this.pDBDirectory = impl.getPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition());
            this.pDBDirectoryPermissions = impl.getPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition());
            this.pDBEvictorCoreThreads = impl.getPropertyValue(INSTANCE.getDBEvictorCoreThreadsPropertyDefinition());
            this.pDBEvictorKeepAlive = impl.getPropertyValue(INSTANCE.getDBEvictorKeepAlivePropertyDefinition());
            this.pDBEvictorLruOnly = impl.getPropertyValue(INSTANCE.getDBEvictorLruOnlyPropertyDefinition());
            this.pDBEvictorMaxThreads = impl.getPropertyValue(INSTANCE.getDBEvictorMaxThreadsPropertyDefinition());
            this.pDBEvictorNodesPerScan = impl.getPropertyValue(INSTANCE.getDBEvictorNodesPerScanPropertyDefinition());
            this.pDBLogFilecacheSize = impl.getPropertyValue(INSTANCE.getDBLogFilecacheSizePropertyDefinition());
            this.pDBLogFileMax = impl.getPropertyValue(INSTANCE.getDBLogFileMaxPropertyDefinition());
            this.pDBLoggingFileHandlerOn = impl.getPropertyValue(INSTANCE.getDBLoggingFileHandlerOnPropertyDefinition());
            this.pDBLoggingLevel = impl.getPropertyValue(INSTANCE.getDBLoggingLevelPropertyDefinition());
            this.pDBNumCleanerThreads = impl.getPropertyValue(INSTANCE.getDBNumCleanerThreadsPropertyDefinition());
            this.pDBNumLockTables = impl.getPropertyValue(INSTANCE.getDBNumLockTablesPropertyDefinition());
            this.pDBRunCleaner = impl.getPropertyValue(INSTANCE.getDBRunCleanerPropertyDefinition());
            this.pDBTxnNoSync = impl.getPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition());
            this.pDBTxnWriteNoSync = impl.getPropertyValue(INSTANCE.getDBTxnWriteNoSyncPropertyDefinition());
            this.pDiskFullThreshold = impl.getPropertyValue(INSTANCE.getDiskFullThresholdPropertyDefinition());
            this.pDiskLowThreshold = impl.getPropertyValue(INSTANCE.getDiskLowThresholdPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pEntriesCompressed = impl.getPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition());
            this.pImportOffheapMemorySize = impl.getPropertyValue(INSTANCE.getImportOffheapMemorySizePropertyDefinition());
            this.pIndexEntryLimit = impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
            this.pIndexFilterAnalyzerEnabled = impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerEnabledPropertyDefinition());
            this.pIndexFilterAnalyzerMaxFilters = impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerMaxFiltersPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pJEProperty = impl.getPropertyValues((PropertyDefinition)INSTANCE.getJEPropertyPropertyDefinition());
            this.pPreloadTimeLimit = impl.getPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition());
            this.pWritabilityMode = impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void addJEChangeListener(ConfigurationChangeListener<JEBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeJEChangeListener(ConfigurationChangeListener<JEBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addPluggableChangeListener(ConfigurationChangeListener<PluggableBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removePluggableChangeListener(ConfigurationChangeListener<PluggableBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getBackendId() {
            return this.pBackendId;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public int getCipherKeyLength() {
            return this.pCipherKeyLength;
        }

        @Override
        public String getCipherTransformation() {
            return this.pCipherTransformation;
        }

        @Override
        public boolean isCompactEncoding() {
            return this.pCompactEncoding;
        }

        @Override
        public boolean isConfidentialityEnabled() {
            return this.pConfidentialityEnabled;
        }

        @Override
        public int getDBCachePercent() {
            return this.pDBCachePercent;
        }

        @Override
        public long getDBCacheSize() {
            return this.pDBCacheSize;
        }

        @Override
        public long getDBCheckpointerBytesInterval() {
            return this.pDBCheckpointerBytesInterval;
        }

        @Override
        public long getDBCheckpointerWakeupInterval() {
            return this.pDBCheckpointerWakeupInterval;
        }

        @Override
        public int getDBCleanerMinUtilization() {
            return this.pDBCleanerMinUtilization;
        }

        @Override
        public String getDBDirectory() {
            return this.pDBDirectory;
        }

        @Override
        public String getDBDirectoryPermissions() {
            return this.pDBDirectoryPermissions;
        }

        @Override
        public int getDBEvictorCoreThreads() {
            return this.pDBEvictorCoreThreads;
        }

        @Override
        public long getDBEvictorKeepAlive() {
            return this.pDBEvictorKeepAlive;
        }

        @Override
        public boolean isDBEvictorLruOnly() {
            return this.pDBEvictorLruOnly;
        }

        @Override
        public int getDBEvictorMaxThreads() {
            return this.pDBEvictorMaxThreads;
        }

        @Override
        public int getDBEvictorNodesPerScan() {
            return this.pDBEvictorNodesPerScan;
        }

        @Override
        public int getDBLogFilecacheSize() {
            return this.pDBLogFilecacheSize;
        }

        @Override
        public long getDBLogFileMax() {
            return this.pDBLogFileMax;
        }

        @Override
        public boolean isDBLoggingFileHandlerOn() {
            return this.pDBLoggingFileHandlerOn;
        }

        @Override
        public String getDBLoggingLevel() {
            return this.pDBLoggingLevel;
        }

        @Override
        public Integer getDBNumCleanerThreads() {
            return this.pDBNumCleanerThreads;
        }

        @Override
        public Integer getDBNumLockTables() {
            return this.pDBNumLockTables;
        }

        @Override
        public boolean isDBRunCleaner() {
            return this.pDBRunCleaner;
        }

        @Override
        public boolean isDBTxnNoSync() {
            return this.pDBTxnNoSync;
        }

        @Override
        public boolean isDBTxnWriteNoSync() {
            return this.pDBTxnWriteNoSync;
        }

        @Override
        public long getDiskFullThreshold() {
            return this.pDiskFullThreshold;
        }

        @Override
        public long getDiskLowThreshold() {
            return this.pDiskLowThreshold;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isEntriesCompressed() {
            return this.pEntriesCompressed;
        }

        @Override
        public Long getImportOffheapMemorySize() {
            return this.pImportOffheapMemorySize;
        }

        @Override
        public int getIndexEntryLimit() {
            return this.pIndexEntryLimit;
        }

        @Override
        public boolean isIndexFilterAnalyzerEnabled() {
            return this.pIndexFilterAnalyzerEnabled;
        }

        @Override
        public int getIndexFilterAnalyzerMaxFilters() {
            return this.pIndexFilterAnalyzerMaxFilters;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<String> getJEProperty() {
            return this.pJEProperty;
        }

        @Override
        public long getPreloadTimeLimit() {
            return this.pPreloadTimeLimit;
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.pWritabilityMode;
        }

        @Override
        public String[] listBackendIndexes() {
            return this.impl.listChildren(INSTANCE.getBackendIndexesRelationDefinition());
        }

        @Override
        public BackendIndexCfg getBackendIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getBackendIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addBackendIndexAddListener(ConfigurationAddListener<BackendIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendIndexAddListener(ConfigurationAddListener<BackendIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public void addBackendIndexDeleteListener(ConfigurationDeleteListener<BackendIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendIndexDeleteListener(ConfigurationDeleteListener<BackendIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public String[] listBackendVLVIndexes() {
            return this.impl.listChildren(INSTANCE.getBackendVLVIndexesRelationDefinition());
        }

        @Override
        public BackendVLVIndexCfg getBackendVLVIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addBackendVLVIndexAddListener(ConfigurationAddListener<BackendVLVIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendVLVIndexAddListener(ConfigurationAddListener<BackendVLVIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void addBackendVLVIndexDeleteListener(ConfigurationDeleteListener<BackendVLVIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendVLVIndexDeleteListener(ConfigurationDeleteListener<BackendVLVIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public Class<? extends JEBackendCfg> configurationClass() {
            return JEBackendCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class JEBackendCfgClientImpl
    implements JEBackendCfgClient {
        private ManagedObject<? extends JEBackendCfgClient> impl;

        private JEBackendCfgClientImpl(ManagedObject<? extends JEBackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public int getCipherKeyLength() {
            return this.impl.getPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition());
        }

        @Override
        public void setCipherKeyLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition(), value);
        }

        @Override
        public String getCipherTransformation() {
            return this.impl.getPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition());
        }

        @Override
        public void setCipherTransformation(String value) {
            this.impl.setPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition(), value);
        }

        @Override
        public boolean isCompactEncoding() {
            return this.impl.getPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition());
        }

        @Override
        public void setCompactEncoding(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition(), value);
        }

        @Override
        public boolean isConfidentialityEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition());
        }

        @Override
        public void setConfidentialityEnabled(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition(), value);
        }

        @Override
        public int getDBCachePercent() {
            return this.impl.getPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition());
        }

        @Override
        public void setDBCachePercent(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition(), value);
        }

        @Override
        public long getDBCacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition());
        }

        @Override
        public void setDBCacheSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition(), value);
        }

        @Override
        public long getDBCheckpointerBytesInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDBCheckpointerBytesIntervalPropertyDefinition());
        }

        @Override
        public void setDBCheckpointerBytesInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCheckpointerBytesIntervalPropertyDefinition(), value);
        }

        @Override
        public long getDBCheckpointerWakeupInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition());
        }

        @Override
        public void setDBCheckpointerWakeupInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition(), value);
        }

        @Override
        public int getDBCleanerMinUtilization() {
            return this.impl.getPropertyValue(INSTANCE.getDBCleanerMinUtilizationPropertyDefinition());
        }

        @Override
        public void setDBCleanerMinUtilization(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBCleanerMinUtilizationPropertyDefinition(), value);
        }

        @Override
        public String getDBDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition());
        }

        @Override
        public void setDBDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition(), value);
        }

        @Override
        public String getDBDirectoryPermissions() {
            return this.impl.getPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition());
        }

        @Override
        public void setDBDirectoryPermissions(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition(), value);
        }

        @Override
        public int getDBEvictorCoreThreads() {
            return this.impl.getPropertyValue(INSTANCE.getDBEvictorCoreThreadsPropertyDefinition());
        }

        @Override
        public void setDBEvictorCoreThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBEvictorCoreThreadsPropertyDefinition(), value);
        }

        @Override
        public long getDBEvictorKeepAlive() {
            return this.impl.getPropertyValue(INSTANCE.getDBEvictorKeepAlivePropertyDefinition());
        }

        @Override
        public void setDBEvictorKeepAlive(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBEvictorKeepAlivePropertyDefinition(), value);
        }

        @Override
        public boolean isDBEvictorLruOnly() {
            return this.impl.getPropertyValue(INSTANCE.getDBEvictorLruOnlyPropertyDefinition());
        }

        @Override
        public void setDBEvictorLruOnly(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBEvictorLruOnlyPropertyDefinition(), value);
        }

        @Override
        public int getDBEvictorMaxThreads() {
            return this.impl.getPropertyValue(INSTANCE.getDBEvictorMaxThreadsPropertyDefinition());
        }

        @Override
        public void setDBEvictorMaxThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBEvictorMaxThreadsPropertyDefinition(), value);
        }

        @Override
        public int getDBEvictorNodesPerScan() {
            return this.impl.getPropertyValue(INSTANCE.getDBEvictorNodesPerScanPropertyDefinition());
        }

        @Override
        public void setDBEvictorNodesPerScan(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBEvictorNodesPerScanPropertyDefinition(), value);
        }

        @Override
        public int getDBLogFilecacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDBLogFilecacheSizePropertyDefinition());
        }

        @Override
        public void setDBLogFilecacheSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBLogFilecacheSizePropertyDefinition(), value);
        }

        @Override
        public long getDBLogFileMax() {
            return this.impl.getPropertyValue(INSTANCE.getDBLogFileMaxPropertyDefinition());
        }

        @Override
        public void setDBLogFileMax(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBLogFileMaxPropertyDefinition(), value);
        }

        @Override
        public boolean isDBLoggingFileHandlerOn() {
            return this.impl.getPropertyValue(INSTANCE.getDBLoggingFileHandlerOnPropertyDefinition());
        }

        @Override
        public void setDBLoggingFileHandlerOn(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBLoggingFileHandlerOnPropertyDefinition(), value);
        }

        @Override
        public String getDBLoggingLevel() {
            return this.impl.getPropertyValue(INSTANCE.getDBLoggingLevelPropertyDefinition());
        }

        @Override
        public void setDBLoggingLevel(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBLoggingLevelPropertyDefinition(), value);
        }

        @Override
        public Integer getDBNumCleanerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getDBNumCleanerThreadsPropertyDefinition());
        }

        @Override
        public void setDBNumCleanerThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBNumCleanerThreadsPropertyDefinition(), value);
        }

        @Override
        public Integer getDBNumLockTables() {
            return this.impl.getPropertyValue(INSTANCE.getDBNumLockTablesPropertyDefinition());
        }

        @Override
        public void setDBNumLockTables(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBNumLockTablesPropertyDefinition(), value);
        }

        @Override
        public boolean isDBRunCleaner() {
            return this.impl.getPropertyValue(INSTANCE.getDBRunCleanerPropertyDefinition());
        }

        @Override
        public void setDBRunCleaner(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBRunCleanerPropertyDefinition(), value);
        }

        @Override
        public boolean isDBTxnNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition());
        }

        @Override
        public void setDBTxnNoSync(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition(), value);
        }

        @Override
        public boolean isDBTxnWriteNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDBTxnWriteNoSyncPropertyDefinition());
        }

        @Override
        public void setDBTxnWriteNoSync(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBTxnWriteNoSyncPropertyDefinition(), value);
        }

        @Override
        public long getDiskFullThreshold() {
            return this.impl.getPropertyValue(INSTANCE.getDiskFullThresholdPropertyDefinition());
        }

        @Override
        public void setDiskFullThreshold(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDiskFullThresholdPropertyDefinition(), value);
        }

        @Override
        public long getDiskLowThreshold() {
            return this.impl.getPropertyValue(INSTANCE.getDiskLowThresholdPropertyDefinition());
        }

        @Override
        public void setDiskLowThreshold(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDiskLowThresholdPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isEntriesCompressed() {
            return this.impl.getPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition());
        }

        @Override
        public void setEntriesCompressed(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition(), value);
        }

        @Override
        public Long getImportOffheapMemorySize() {
            return this.impl.getPropertyValue(INSTANCE.getImportOffheapMemorySizePropertyDefinition());
        }

        @Override
        public void setImportOffheapMemorySize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getImportOffheapMemorySizePropertyDefinition(), value);
        }

        @Override
        public int getIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
        }

        @Override
        public void setIndexEntryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition(), value);
        }

        @Override
        public boolean isIndexFilterAnalyzerEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerEnabledPropertyDefinition());
        }

        @Override
        public void setIndexFilterAnalyzerEnabled(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIndexFilterAnalyzerEnabledPropertyDefinition(), value);
        }

        @Override
        public int getIndexFilterAnalyzerMaxFilters() {
            return this.impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerMaxFiltersPropertyDefinition());
        }

        @Override
        public void setIndexFilterAnalyzerMaxFilters(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexFilterAnalyzerMaxFiltersPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getJEProperty() {
            return this.impl.getPropertyValues(INSTANCE.getJEPropertyPropertyDefinition());
        }

        @Override
        public void setJEProperty(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getJEPropertyPropertyDefinition(), values);
        }

        @Override
        public long getPreloadTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition());
        }

        @Override
        public void setPreloadTimeLimit(Long value) {
            this.impl.setPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition(), value);
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void setWritabilityMode(BackendCfgDefn.WritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getWritabilityModePropertyDefinition(), value);
        }

        @Override
        public String[] listBackendIndexes() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getBackendIndexesRelationDefinition());
        }

        @Override
        public BackendIndexCfgClient getBackendIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getBackendIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends BackendIndexCfgClient> M createBackendIndex(ManagedObjectDefinition<M, ? extends BackendIndexCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((BackendIndexCfgClient)this.impl.createChild(INSTANCE.getBackendIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeBackendIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getBackendIndexesRelationDefinition(), name);
        }

        @Override
        public String[] listBackendVLVIndexes() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getBackendVLVIndexesRelationDefinition());
        }

        @Override
        public BackendVLVIndexCfgClient getBackendVLVIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends BackendVLVIndexCfgClient> M createBackendVLVIndex(ManagedObjectDefinition<M, ? extends BackendVLVIndexCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((BackendVLVIndexCfgClient)this.impl.createChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeBackendVLVIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends JEBackendCfgClient, ? extends JEBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

