/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.HTTPOauth2FileAuthorizationMechanismCfgClient;
import org.forgerock.opendj.server.config.client.IdentityMapperCfgClient;
import org.forgerock.opendj.server.config.meta.HTTPOauth2AuthorizationMechanismCfgDefn;
import org.forgerock.opendj.server.config.server.HTTPAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPOauth2AuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPOauth2FileAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.IdentityMapperCfg;

public final class HTTPOauth2FileAuthorizationMechanismCfgDefn
extends ManagedObjectDefinition<HTTPOauth2FileAuthorizationMechanismCfgClient, HTTPOauth2FileAuthorizationMechanismCfg> {
    private static final HTTPOauth2FileAuthorizationMechanismCfgDefn INSTANCE = new HTTPOauth2FileAuthorizationMechanismCfgDefn();
    private static final StringPropertyDefinition PD_ACCESS_TOKEN_DIRECTORY;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static HTTPOauth2FileAuthorizationMechanismCfgDefn getInstance() {
        return INSTANCE;
    }

    private HTTPOauth2FileAuthorizationMechanismCfgDefn() {
        super("http-oauth2-file-authorization-mechanism", HTTPOauth2AuthorizationMechanismCfgDefn.getInstance());
    }

    @Override
    public HTTPOauth2FileAuthorizationMechanismCfgClient createClientConfiguration(ManagedObject<? extends HTTPOauth2FileAuthorizationMechanismCfgClient> impl) {
        return new HTTPOauth2FileAuthorizationMechanismCfgClientImpl(impl);
    }

    @Override
    public HTTPOauth2FileAuthorizationMechanismCfg createServerConfiguration(ServerManagedObject<? extends HTTPOauth2FileAuthorizationMechanismCfg> impl) {
        return new HTTPOauth2FileAuthorizationMechanismCfgServerImpl(impl);
    }

    @Override
    public Class<HTTPOauth2FileAuthorizationMechanismCfg> getServerConfigurationClass() {
        return HTTPOauth2FileAuthorizationMechanismCfg.class;
    }

    public BooleanPropertyDefinition getAccessTokenCacheEnabledPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getAccessTokenCacheEnabledPropertyDefinition();
    }

    public DurationPropertyDefinition getAccessTokenCacheExpirationPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getAccessTokenCacheExpirationPropertyDefinition();
    }

    public StringPropertyDefinition getAccessTokenDirectoryPropertyDefinition() {
        return PD_ACCESS_TOKEN_DIRECTORY;
    }

    public StringPropertyDefinition getAuthzidJsonPointerPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getAuthzidJsonPointerPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> getIdentityMapperPropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getIdentityMapperPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getRequiredScopePropertyDefinition() {
        return HTTPOauth2AuthorizationMechanismCfgDefn.getInstance().getRequiredScopePropertyDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "access-token-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "access-token-directory"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("oauth2-demo/");
        builder.setDefaultBehaviorProvider(provider);
        PD_ACCESS_TOKEN_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ACCESS_TOKEN_DIRECTORY);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.http.authz.HttpOAuth2FileAuthorizationMechanism");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.protocols.http.authz.HttpAuthorizationMechanism");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
    }

    private static class HTTPOauth2FileAuthorizationMechanismCfgServerImpl
    implements HTTPOauth2FileAuthorizationMechanismCfg {
        private ServerManagedObject<? extends HTTPOauth2FileAuthorizationMechanismCfg> impl;
        private final boolean pAccessTokenCacheEnabled;
        private final Long pAccessTokenCacheExpiration;
        private final String pAccessTokenDirectory;
        private final String pAuthzidJsonPointer;
        private final boolean pEnabled;
        private final String pIdentityMapper;
        private final String pJavaClass;
        private final SortedSet<String> pRequiredScope;

        private HTTPOauth2FileAuthorizationMechanismCfgServerImpl(ServerManagedObject<? extends HTTPOauth2FileAuthorizationMechanismCfg> impl) {
            this.impl = impl;
            this.pAccessTokenCacheEnabled = impl.getPropertyValue(INSTANCE.getAccessTokenCacheEnabledPropertyDefinition());
            this.pAccessTokenCacheExpiration = impl.getPropertyValue(INSTANCE.getAccessTokenCacheExpirationPropertyDefinition());
            this.pAccessTokenDirectory = impl.getPropertyValue(INSTANCE.getAccessTokenDirectoryPropertyDefinition());
            this.pAuthzidJsonPointer = impl.getPropertyValue(INSTANCE.getAuthzidJsonPointerPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIdentityMapper = impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pRequiredScope = impl.getPropertyValues((PropertyDefinition)INSTANCE.getRequiredScopePropertyDefinition());
        }

        @Override
        public void addHTTPOauth2FileAuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2FileAuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeHTTPOauth2FileAuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2FileAuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addHTTPOauth2AuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2AuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeHTTPOauth2AuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPOauth2AuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<HTTPAuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<HTTPAuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAccessTokenCacheEnabled() {
            return this.pAccessTokenCacheEnabled;
        }

        @Override
        public Long getAccessTokenCacheExpiration() {
            return this.pAccessTokenCacheExpiration;
        }

        @Override
        public String getAccessTokenDirectory() {
            return this.pAccessTokenDirectory;
        }

        @Override
        public String getAuthzidJsonPointer() {
            return this.pAuthzidJsonPointer;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getIdentityMapper() {
            return this.pIdentityMapper;
        }

        @Override
        public DN getIdentityMapperDN() {
            String value = this.getIdentityMapper();
            if (value == null) {
                return null;
            }
            return INSTANCE.getIdentityMapperPropertyDefinition().getChildDN(value);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<String> getRequiredScope() {
            return this.pRequiredScope;
        }

        @Override
        public Class<? extends HTTPOauth2FileAuthorizationMechanismCfg> configurationClass() {
            return HTTPOauth2FileAuthorizationMechanismCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class HTTPOauth2FileAuthorizationMechanismCfgClientImpl
    implements HTTPOauth2FileAuthorizationMechanismCfgClient {
        private ManagedObject<? extends HTTPOauth2FileAuthorizationMechanismCfgClient> impl;

        private HTTPOauth2FileAuthorizationMechanismCfgClientImpl(ManagedObject<? extends HTTPOauth2FileAuthorizationMechanismCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAccessTokenCacheEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getAccessTokenCacheEnabledPropertyDefinition());
        }

        @Override
        public void setAccessTokenCacheEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAccessTokenCacheEnabledPropertyDefinition(), value);
        }

        @Override
        public Long getAccessTokenCacheExpiration() {
            return this.impl.getPropertyValue(INSTANCE.getAccessTokenCacheExpirationPropertyDefinition());
        }

        @Override
        public void setAccessTokenCacheExpiration(Long value) {
            this.impl.setPropertyValue(INSTANCE.getAccessTokenCacheExpirationPropertyDefinition(), value);
        }

        @Override
        public String getAccessTokenDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getAccessTokenDirectoryPropertyDefinition());
        }

        @Override
        public void setAccessTokenDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getAccessTokenDirectoryPropertyDefinition(), value);
        }

        @Override
        public String getAuthzidJsonPointer() {
            return this.impl.getPropertyValue(INSTANCE.getAuthzidJsonPointerPropertyDefinition());
        }

        @Override
        public void setAuthzidJsonPointer(String value) {
            this.impl.setPropertyValue(INSTANCE.getAuthzidJsonPointerPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getIdentityMapper() {
            return this.impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
        }

        @Override
        public void setIdentityMapper(String value) {
            this.impl.setPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRequiredScope() {
            return this.impl.getPropertyValues(INSTANCE.getRequiredScopePropertyDefinition());
        }

        @Override
        public void setRequiredScope(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRequiredScopePropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends HTTPOauth2FileAuthorizationMechanismCfgClient, ? extends HTTPOauth2FileAuthorizationMechanismCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

