/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.GenericConstraint;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.HTTPBasicAuthorizationMechanismCfgClient;
import org.forgerock.opendj.server.config.client.IdentityMapperCfgClient;
import org.forgerock.opendj.server.config.meta.HTTPAuthorizationMechanismCfgDefn;
import org.forgerock.opendj.server.config.server.HTTPAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPBasicAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.IdentityMapperCfg;

public final class HTTPBasicAuthorizationMechanismCfgDefn
extends ManagedObjectDefinition<HTTPBasicAuthorizationMechanismCfgClient, HTTPBasicAuthorizationMechanismCfg> {
    private static final HTTPBasicAuthorizationMechanismCfgDefn INSTANCE = new HTTPBasicAuthorizationMechanismCfgDefn();
    private static final BooleanPropertyDefinition PD_ALT_AUTHENTICATION_ENABLED;
    private static final StringPropertyDefinition PD_ALT_PASSWORD_HEADER;
    private static final StringPropertyDefinition PD_ALT_USERNAME_HEADER;
    private static final AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> PD_IDENTITY_MAPPER;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static HTTPBasicAuthorizationMechanismCfgDefn getInstance() {
        return INSTANCE;
    }

    private HTTPBasicAuthorizationMechanismCfgDefn() {
        super("http-basic-authorization-mechanism", HTTPAuthorizationMechanismCfgDefn.getInstance());
    }

    @Override
    public HTTPBasicAuthorizationMechanismCfgClient createClientConfiguration(ManagedObject<? extends HTTPBasicAuthorizationMechanismCfgClient> impl) {
        return new HTTPBasicAuthorizationMechanismCfgClientImpl(impl);
    }

    @Override
    public HTTPBasicAuthorizationMechanismCfg createServerConfiguration(ServerManagedObject<? extends HTTPBasicAuthorizationMechanismCfg> impl) {
        return new HTTPBasicAuthorizationMechanismCfgServerImpl(impl);
    }

    @Override
    public Class<HTTPBasicAuthorizationMechanismCfg> getServerConfigurationClass() {
        return HTTPBasicAuthorizationMechanismCfg.class;
    }

    public BooleanPropertyDefinition getAltAuthenticationEnabledPropertyDefinition() {
        return PD_ALT_AUTHENTICATION_ENABLED;
    }

    public StringPropertyDefinition getAltPasswordHeaderPropertyDefinition() {
        return PD_ALT_PASSWORD_HEADER;
    }

    public StringPropertyDefinition getAltUsernameHeaderPropertyDefinition() {
        return PD_ALT_USERNAME_HEADER;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return HTTPAuthorizationMechanismCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> getIdentityMapperPropertyDefinition() {
        return PD_IDENTITY_MAPPER;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "alt-authentication-enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "alt-authentication-enabled"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALT_AUTHENTICATION_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALT_AUTHENTICATION_ENABLED);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "alt-password-header");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "alt-password-header"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ALT_PASSWORD_HEADER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALT_PASSWORD_HEADER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "alt-username-header");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "alt-username-header"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ALT_USERNAME_HEADER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALT_USERNAME_HEADER);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "identity-mapper");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "identity-mapper"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("identity-mapper");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_IDENTITY_MAPPER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IDENTITY_MAPPER);
        INSTANCE.registerConstraint(PD_IDENTITY_MAPPER.getSourceConstraint());
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.http.authz.HttpBasicAuthorizationMechanism");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.protocols.http.authz.HttpAuthorizationMechanism");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.implies(Conditions.contains("alt-authentication-enabled", "true"), Conditions.implies(Conditions.isPresent("alt-username-header"), Conditions.isPresent("alt-password-header")))));
    }

    private static class HTTPBasicAuthorizationMechanismCfgServerImpl
    implements HTTPBasicAuthorizationMechanismCfg {
        private ServerManagedObject<? extends HTTPBasicAuthorizationMechanismCfg> impl;
        private final boolean pAltAuthenticationEnabled;
        private final String pAltPasswordHeader;
        private final String pAltUsernameHeader;
        private final boolean pEnabled;
        private final String pIdentityMapper;
        private final String pJavaClass;

        private HTTPBasicAuthorizationMechanismCfgServerImpl(ServerManagedObject<? extends HTTPBasicAuthorizationMechanismCfg> impl) {
            this.impl = impl;
            this.pAltAuthenticationEnabled = impl.getPropertyValue(INSTANCE.getAltAuthenticationEnabledPropertyDefinition());
            this.pAltPasswordHeader = impl.getPropertyValue(INSTANCE.getAltPasswordHeaderPropertyDefinition());
            this.pAltUsernameHeader = impl.getPropertyValue(INSTANCE.getAltUsernameHeaderPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIdentityMapper = impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addHTTPBasicAuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPBasicAuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeHTTPBasicAuthorizationMechanismChangeListener(ConfigurationChangeListener<HTTPBasicAuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<HTTPAuthorizationMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<HTTPAuthorizationMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAltAuthenticationEnabled() {
            return this.pAltAuthenticationEnabled;
        }

        @Override
        public String getAltPasswordHeader() {
            return this.pAltPasswordHeader;
        }

        @Override
        public String getAltUsernameHeader() {
            return this.pAltUsernameHeader;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getIdentityMapper() {
            return this.pIdentityMapper;
        }

        @Override
        public DN getIdentityMapperDN() {
            String value = this.getIdentityMapper();
            if (value == null) {
                return null;
            }
            return INSTANCE.getIdentityMapperPropertyDefinition().getChildDN(value);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends HTTPBasicAuthorizationMechanismCfg> configurationClass() {
            return HTTPBasicAuthorizationMechanismCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class HTTPBasicAuthorizationMechanismCfgClientImpl
    implements HTTPBasicAuthorizationMechanismCfgClient {
        private ManagedObject<? extends HTTPBasicAuthorizationMechanismCfgClient> impl;

        private HTTPBasicAuthorizationMechanismCfgClientImpl(ManagedObject<? extends HTTPBasicAuthorizationMechanismCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAltAuthenticationEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getAltAuthenticationEnabledPropertyDefinition());
        }

        @Override
        public void setAltAuthenticationEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAltAuthenticationEnabledPropertyDefinition(), value);
        }

        @Override
        public String getAltPasswordHeader() {
            return this.impl.getPropertyValue(INSTANCE.getAltPasswordHeaderPropertyDefinition());
        }

        @Override
        public void setAltPasswordHeader(String value) {
            this.impl.setPropertyValue(INSTANCE.getAltPasswordHeaderPropertyDefinition(), value);
        }

        @Override
        public String getAltUsernameHeader() {
            return this.impl.getPropertyValue(INSTANCE.getAltUsernameHeaderPropertyDefinition());
        }

        @Override
        public void setAltUsernameHeader(String value) {
            this.impl.setPropertyValue(INSTANCE.getAltUsernameHeaderPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getIdentityMapper() {
            return this.impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
        }

        @Override
        public void setIdentityMapper(String value) {
            this.impl.setPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends HTTPBasicAuthorizationMechanismCfgClient, ? extends HTTPBasicAuthorizationMechanismCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

