/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.CryptoManagerCfgClient;
import org.forgerock.opendj.server.config.server.CryptoManagerCfg;

public final class CryptoManagerCfgDefn
extends ManagedObjectDefinition<CryptoManagerCfgClient, CryptoManagerCfg> {
    private static final CryptoManagerCfgDefn INSTANCE = new CryptoManagerCfgDefn();
    private static final IntegerPropertyDefinition PD_CIPHER_KEY_LENGTH;
    private static final StringPropertyDefinition PD_CIPHER_TRANSFORMATION;
    private static final StringPropertyDefinition PD_DIGEST_ALGORITHM;
    private static final StringPropertyDefinition PD_KEY_WRAPPING_TRANSFORMATION;
    private static final StringPropertyDefinition PD_MAC_ALGORITHM;
    private static final IntegerPropertyDefinition PD_MAC_KEY_LENGTH;
    private static final StringPropertyDefinition PD_SSL_CERT_NICKNAME;
    private static final StringPropertyDefinition PD_SSL_CIPHER_SUITE;
    private static final BooleanPropertyDefinition PD_SSL_ENCRYPTION;
    private static final StringPropertyDefinition PD_SSL_PROTOCOL;

    public static CryptoManagerCfgDefn getInstance() {
        return INSTANCE;
    }

    private CryptoManagerCfgDefn() {
        super("crypto-manager", TopCfgDefn.getInstance());
    }

    @Override
    public CryptoManagerCfgClient createClientConfiguration(ManagedObject<? extends CryptoManagerCfgClient> impl) {
        return new CryptoManagerCfgClientImpl(impl);
    }

    @Override
    public CryptoManagerCfg createServerConfiguration(ServerManagedObject<? extends CryptoManagerCfg> impl) {
        return new CryptoManagerCfgServerImpl(impl);
    }

    @Override
    public Class<CryptoManagerCfg> getServerConfigurationClass() {
        return CryptoManagerCfg.class;
    }

    public IntegerPropertyDefinition getCipherKeyLengthPropertyDefinition() {
        return PD_CIPHER_KEY_LENGTH;
    }

    public StringPropertyDefinition getCipherTransformationPropertyDefinition() {
        return PD_CIPHER_TRANSFORMATION;
    }

    public StringPropertyDefinition getDigestAlgorithmPropertyDefinition() {
        return PD_DIGEST_ALGORITHM;
    }

    public StringPropertyDefinition getKeyWrappingTransformationPropertyDefinition() {
        return PD_KEY_WRAPPING_TRANSFORMATION;
    }

    public StringPropertyDefinition getMacAlgorithmPropertyDefinition() {
        return PD_MAC_ALGORITHM;
    }

    public IntegerPropertyDefinition getMacKeyLengthPropertyDefinition() {
        return PD_MAC_KEY_LENGTH;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return PD_SSL_CERT_NICKNAME;
    }

    public StringPropertyDefinition getSSLCipherSuitePropertyDefinition() {
        return PD_SSL_CIPHER_SUITE;
    }

    public BooleanPropertyDefinition getSSLEncryptionPropertyDefinition() {
        return PD_SSL_ENCRYPTION;
    }

    public StringPropertyDefinition getSSLProtocolPropertyDefinition() {
        return PD_SSL_PROTOCOL;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "cipher-key-length");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cipher-key-length"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("128");
        builder.setDefaultBehaviorProvider(provider);
        PD_CIPHER_KEY_LENGTH = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CIPHER_KEY_LENGTH);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "cipher-transformation");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cipher-transformation"));
        provider = new DefinedDefaultBehaviorProvider("AES/CBC/PKCS5Padding");
        builder.setDefaultBehaviorProvider(provider);
        PD_CIPHER_TRANSFORMATION = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CIPHER_TRANSFORMATION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "digest-algorithm");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "digest-algorithm"));
        provider = new DefinedDefaultBehaviorProvider("SHA-1");
        builder.setDefaultBehaviorProvider(provider);
        PD_DIGEST_ALGORITHM = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DIGEST_ALGORITHM);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-wrapping-transformation");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-wrapping-transformation"));
        provider = new DefinedDefaultBehaviorProvider("RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING");
        builder.setDefaultBehaviorProvider(provider);
        PD_KEY_WRAPPING_TRANSFORMATION = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_WRAPPING_TRANSFORMATION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "mac-algorithm");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mac-algorithm"));
        provider = new DefinedDefaultBehaviorProvider("HmacSHA1");
        builder.setDefaultBehaviorProvider(provider);
        PD_MAC_ALGORITHM = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAC_ALGORITHM);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "mac-key-length");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "mac-key-length"));
        provider = new DefinedDefaultBehaviorProvider("128");
        builder.setDefaultBehaviorProvider(provider);
        PD_MAC_KEY_LENGTH = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAC_KEY_LENGTH);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cert-nickname");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ssl-cert-nickname"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cert-nickname"));
        PD_SSL_CERT_NICKNAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CERT_NICKNAME);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cipher-suite");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-cipher-suite"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cipher-suite"));
        PD_SSL_CIPHER_SUITE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CIPHER_SUITE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "ssl-encryption");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-encryption"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_SSL_ENCRYPTION = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_ENCRYPTION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-protocol");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-protocol"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-protocol"));
        PD_SSL_PROTOCOL = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_PROTOCOL);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class CryptoManagerCfgServerImpl
    implements CryptoManagerCfg {
        private ServerManagedObject<? extends CryptoManagerCfg> impl;
        private final int pCipherKeyLength;
        private final String pCipherTransformation;
        private final String pDigestAlgorithm;
        private final String pKeyWrappingTransformation;
        private final String pMacAlgorithm;
        private final int pMacKeyLength;
        private final SortedSet<String> pSSLCertNickname;
        private final SortedSet<String> pSSLCipherSuite;
        private final boolean pSSLEncryption;
        private final SortedSet<String> pSSLProtocol;

        private CryptoManagerCfgServerImpl(ServerManagedObject<? extends CryptoManagerCfg> impl) {
            this.impl = impl;
            this.pCipherKeyLength = impl.getPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition());
            this.pCipherTransformation = impl.getPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition());
            this.pDigestAlgorithm = impl.getPropertyValue(INSTANCE.getDigestAlgorithmPropertyDefinition());
            this.pKeyWrappingTransformation = impl.getPropertyValue(INSTANCE.getKeyWrappingTransformationPropertyDefinition());
            this.pMacAlgorithm = impl.getPropertyValue(INSTANCE.getMacAlgorithmPropertyDefinition());
            this.pMacKeyLength = impl.getPropertyValue(INSTANCE.getMacKeyLengthPropertyDefinition());
            this.pSSLCertNickname = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCertNicknamePropertyDefinition());
            this.pSSLCipherSuite = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCipherSuitePropertyDefinition());
            this.pSSLEncryption = impl.getPropertyValue(INSTANCE.getSSLEncryptionPropertyDefinition());
            this.pSSLProtocol = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLProtocolPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<CryptoManagerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<CryptoManagerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public int getCipherKeyLength() {
            return this.pCipherKeyLength;
        }

        @Override
        public String getCipherTransformation() {
            return this.pCipherTransformation;
        }

        @Override
        public String getDigestAlgorithm() {
            return this.pDigestAlgorithm;
        }

        @Override
        public String getKeyWrappingTransformation() {
            return this.pKeyWrappingTransformation;
        }

        @Override
        public String getMacAlgorithm() {
            return this.pMacAlgorithm;
        }

        @Override
        public int getMacKeyLength() {
            return this.pMacKeyLength;
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.pSSLCertNickname;
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.pSSLCipherSuite;
        }

        @Override
        public boolean isSSLEncryption() {
            return this.pSSLEncryption;
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.pSSLProtocol;
        }

        @Override
        public Class<? extends CryptoManagerCfg> configurationClass() {
            return CryptoManagerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class CryptoManagerCfgClientImpl
    implements CryptoManagerCfgClient {
        private ManagedObject<? extends CryptoManagerCfgClient> impl;

        private CryptoManagerCfgClientImpl(ManagedObject<? extends CryptoManagerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public int getCipherKeyLength() {
            return this.impl.getPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition());
        }

        @Override
        public void setCipherKeyLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition(), value);
        }

        @Override
        public String getCipherTransformation() {
            return this.impl.getPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition());
        }

        @Override
        public void setCipherTransformation(String value) {
            this.impl.setPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition(), value);
        }

        @Override
        public String getDigestAlgorithm() {
            return this.impl.getPropertyValue(INSTANCE.getDigestAlgorithmPropertyDefinition());
        }

        @Override
        public void setDigestAlgorithm(String value) {
            this.impl.setPropertyValue(INSTANCE.getDigestAlgorithmPropertyDefinition(), value);
        }

        @Override
        public String getKeyWrappingTransformation() {
            return this.impl.getPropertyValue(INSTANCE.getKeyWrappingTransformationPropertyDefinition());
        }

        @Override
        public void setKeyWrappingTransformation(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyWrappingTransformationPropertyDefinition(), value);
        }

        @Override
        public String getMacAlgorithm() {
            return this.impl.getPropertyValue(INSTANCE.getMacAlgorithmPropertyDefinition());
        }

        @Override
        public void setMacAlgorithm(String value) {
            this.impl.setPropertyValue(INSTANCE.getMacAlgorithmPropertyDefinition(), value);
        }

        @Override
        public int getMacKeyLength() {
            return this.impl.getPropertyValue(INSTANCE.getMacKeyLengthPropertyDefinition());
        }

        @Override
        public void setMacKeyLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMacKeyLengthPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition());
        }

        @Override
        public void setSSLCipherSuite(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition(), values);
        }

        @Override
        public boolean isSSLEncryption() {
            return this.impl.getPropertyValue(INSTANCE.getSSLEncryptionPropertyDefinition());
        }

        @Override
        public void setSSLEncryption(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSSLEncryptionPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.impl.getPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition());
        }

        @Override
        public void setSSLProtocol(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends CryptoManagerCfgClient, ? extends CryptoManagerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

