/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RDN;

public final class Reference<C extends ConfigurationClient, S extends Configuration> {
    private final String name;
    private final ManagedObjectPath<C, S> path;
    private final InstantiableRelationDefinition<C, S> relation;

    public static <C extends ConfigurationClient, S extends Configuration> Reference<C, S> parseDN(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<C, S> relationDef, String dnAsString) {
        AbstractManagedObjectDefinition<?, ?> definition = path.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = definition.getRelationDefinition(relationDef.getName());
        if (tmp != relationDef) {
            throw new IllegalArgumentException("The relation \"" + relationDef.getName() + "\" is not associated with the definition \"" + definition.getName() + "\"");
        }
        DN dn = DN.valueOf((String)dnAsString);
        RDN rdn = dn.rdn();
        if (rdn == null) {
            throw new IllegalArgumentException("Unabled to decode the DN string: \"" + dnAsString + "\"");
        }
        String name = rdn.getFirstAVA().getAttributeValue().toString();
        DN expected = path.child(relationDef, name).toDN();
        if (!dn.equals((Object)expected)) {
            throw new IllegalArgumentException("Unabled to decode the DN string: \"" + dnAsString + "\"");
        }
        return new Reference<C, S>(path, relationDef, name);
    }

    public static <C extends ConfigurationClient, S extends Configuration> Reference<C, S> parseName(ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<C, S> rd, String s) {
        AbstractManagedObjectDefinition<?, ?> d = p.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation \"" + rd.getName() + "\" is not associated with the definition \"" + d.getName() + "\"");
        }
        if (s.trim().length() == 0) {
            throw new IllegalArgumentException("Empty names are not allowed");
        }
        return new Reference<C, S>(p, rd, s);
    }

    private Reference(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> relation, String name) {
        this.relation = relation;
        this.name = name;
        this.path = parent.child(relation, name);
    }

    public String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        PropertyDefinition<?> pd = this.relation.getNamingPropertyDefinition();
        return this.normalizeName(pd);
    }

    public DN toDN() {
        return this.path.toDN();
    }

    public String toString() {
        return this.name;
    }

    private <T> String normalizeName(PropertyDefinition<T> pd) {
        if (pd != null) {
            try {
                T tvalue = pd.decodeValue(this.name);
                return pd.normalizeValue(tvalue);
            }
            catch (PropertyException tvalue) {
                // empty catch block
            }
        }
        String s = this.name.trim().replaceAll(" +", " ");
        return StaticUtils.toLowerCase((String)s);
    }
}

