/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFramework {
    private static final String MANIFEST_RELATIVE_PATH = "META-INF/services/org.forgerock.opendj.config.AbstractManagedObjectDefinition";
    private static final String MANIFEST_ABSOLUTE_PATH = "/META-INF/services/org.forgerock.opendj.config.AbstractManagedObjectDefinition";
    private static final LocalizedLogger adminLogger = LocalizedLogger.getLocalizedLogger((String)ConfigMessages.resourceName());
    private static final Logger debugLogger = LoggerFactory.getLogger(ConfigurationFramework.class);
    private static final String LIB_DIR = "lib";
    private static final String EXTENSIONS_DIR = "extensions";
    private static final ConfigurationFramework INSTANCE = new ConfigurationFramework();
    private static final String REVISION_NUMBER = "Revision-Number";
    private static final String[] BUILD_INFORMATION_ATTRIBUTE_NAMES = new String[]{Attributes.Name.EXTENSION_NAME.toString(), Attributes.Name.IMPLEMENTATION_VERSION.toString(), "Revision-Number"};
    private Set<File> jarFiles = new HashSet<File>();
    private MyURLClassLoader loader;
    private boolean isClient = true;
    private String installPath;
    private String instancePath;
    private ClassLoader parent;

    public static ConfigurationFramework getInstance() {
        return INSTANCE;
    }

    public static String getPrintableExtensionInformation(String installPath, String instancePath) {
        File extensionsPath = ConfigurationFramework.buildExtensionDir(installPath);
        ArrayList<File> extensions = new ArrayList<File>();
        if (extensionsPath.exists() && extensionsPath.isDirectory()) {
            extensions.addAll(ConfigurationFramework.listFiles(extensionsPath));
        }
        File instanceExtensionsPath = ConfigurationFramework.buildExtensionDir(instancePath);
        if (!extensionsPath.getAbsolutePath().equals(instanceExtensionsPath.getAbsolutePath())) {
            extensions.addAll(ConfigurationFramework.listFiles(instanceExtensionsPath));
        }
        if (extensions.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ConfigurationFramework.printExtensionDetailsHeader(sb);
        for (File extension : extensions) {
            ConfigurationFramework.printExtensionDetails(sb, extension);
        }
        return sb.toString();
    }

    private static void printExtensionDetailsHeader(StringBuilder sb) {
        sb.append("--").append(StaticUtils.EOL).append("           Name                 Build number         Revision number").append(StaticUtils.EOL);
    }

    private static File buildExtensionDir(String directory) {
        File libDir = new File(directory, LIB_DIR);
        File extensionDir = new File(libDir, EXTENSIONS_DIR);
        try {
            return extensionDir.getCanonicalFile();
        }
        catch (Exception e) {
            return extensionDir;
        }
    }

    private static List<File> listFiles(File path) {
        if (path.exists() && path.isDirectory()) {
            return Arrays.asList(path.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            }));
        }
        return Collections.emptyList();
    }

    private static void printExtensionDetails(StringBuilder sb, File extension) {
        try (JarFile jarFile = new JarFile(extension);){
            JarEntry entry = jarFile.getJarEntry(MANIFEST_RELATIVE_PATH);
            if (entry == null) {
                return;
            }
            String[] information = ConfigurationFramework.getBuildInformation(jarFile);
            sb.append("Extension:");
            for (String name : information) {
                sb.append(" ").append(String.format("%-20s", name));
            }
            sb.append(StaticUtils.EOL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String[] getBuildInformation(JarFile extension) throws IOException {
        String[] result = new String[3];
        Manifest manifest = extension.getManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            int index = 0;
            for (String name : BUILD_INFORMATION_ATTRIBUTE_NAMES) {
                String value = attributes.getValue(name);
                if (value == null) {
                    value = "<unknown>";
                }
                result[index++] = value;
            }
        }
        return result;
    }

    private ConfigurationFramework() {
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public ConfigurationFramework initialize() throws ConfigException {
        return this.initialize(null);
    }

    public ConfigurationFramework initialize(String installAndInstancePath) throws ConfigException {
        return this.initialize(installAndInstancePath, installAndInstancePath);
    }

    public ConfigurationFramework initialize(String installPath, String instancePath) throws ConfigException {
        return this.initialize(installPath, instancePath, RootCfgDefn.class.getClassLoader());
    }

    public synchronized ConfigurationFramework initialize(String installPath, String instancePath, ClassLoader parent) throws ConfigException {
        String instanceRoot;
        if (this.loader != null) {
            throw new IllegalStateException("configuration framework already initialized.");
        }
        String string = this.installPath = installPath != null ? installPath : System.getenv("INSTALL_ROOT");
        this.instancePath = instancePath != null ? instancePath : ((instanceRoot = System.getenv("INSTANCE_ROOT")) != null ? instanceRoot : this.installPath);
        this.parent = parent;
        this.initialize0();
        return this;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public synchronized boolean isInitialized() {
        return this.loader != null;
    }

    public synchronized void reload() throws ConfigException {
        this.ensureInitialized();
        this.loader = null;
        this.jarFiles = new HashSet<File>();
        this.initialize0();
    }

    public ConfigurationFramework setIsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    private void addExtension(List<File> extensions) throws ConfigException {
        LinkedList<JarFile> jars = new LinkedList<JarFile>();
        for (File extension : extensions) {
            if (this.jarFiles.contains(extension)) continue;
            jars.add(this.loadJarFile(extension));
            try {
                this.loader.addJarFile(extension);
            }
            catch (Exception e) {
                debugLogger.trace("Unable to register the jar file with the class loader", (Throwable)e);
                LocalizableMessage message = ConfigMessages.ERR_ADMIN_CANNOT_OPEN_JAR_FILE.get((Object)extension.getName(), (Object)extension.getParent(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
                throw new ConfigException(message);
            }
            this.jarFiles.add(extension);
        }
        for (JarFile jar : jars) {
            this.initializeExtension(jar);
        }
    }

    private void ensureInitialized() {
        if (this.loader == null) {
            throw new IllegalStateException("configuration framework is disabled.");
        }
    }

    private void initialize0() throws ConfigException {
        this.loader = this.parent != null ? new MyURLClassLoader(this.parent) : new MyURLClassLoader();
        this.initializeCoreComponents();
        File installExtensionsPath = ConfigurationFramework.buildExtensionDir(this.installPath);
        File instanceExtensionsPath = ConfigurationFramework.buildExtensionDir(this.instancePath);
        this.initializeAllExtensions(installExtensionsPath);
        if (!installExtensionsPath.getAbsolutePath().equals(instanceExtensionsPath.getAbsolutePath())) {
            this.initializeAllExtensions(instanceExtensionsPath);
        }
    }

    private void initializeAllExtensions(File extensionsPath) throws ConfigException {
        try {
            if (!extensionsPath.exists()) {
                adminLogger.warn(ConfigMessages.WARN_ADMIN_NO_EXTENSIONS_DIR, (Object)extensionsPath);
                return;
            }
            if (!extensionsPath.isDirectory()) {
                throw new ConfigException(ConfigMessages.ERR_ADMIN_EXTENSIONS_DIR_NOT_DIRECTORY.get((Object)extensionsPath));
            }
            this.addExtension(ConfigurationFramework.listFiles(extensionsPath));
        }
        catch (ConfigException e) {
            debugLogger.trace("Unable to initialize all extensions", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            debugLogger.trace("Unable to initialize all extensions", (Throwable)e);
            LocalizableMessage message = ConfigMessages.ERR_ADMIN_EXTENSIONS_CANNOT_LIST_FILES.get((Object)extensionsPath, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
            throw new ConfigException(message, (Throwable)e);
        }
    }

    private void initializeCoreComponents() throws ConfigException {
        InputStream is = RootCfgDefn.class.getResourceAsStream(MANIFEST_ABSOLUTE_PATH);
        if (is == null) {
            throw new ConfigException(ConfigMessages.ERR_ADMIN_CANNOT_FIND_CORE_MANIFEST.get((Object)MANIFEST_ABSOLUTE_PATH));
        }
        try {
            this.loadDefinitionClasses(is);
        }
        catch (ConfigException e) {
            debugLogger.trace("Unable to initialize core components", (Throwable)e);
            throw new ConfigException(ConfigMessages.ERR_CLASS_LOADER_CANNOT_LOAD_CORE.get((Object)MANIFEST_ABSOLUTE_PATH, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true)));
        }
    }

    private void initializeExtension(JarFile jarFile) throws ConfigException {
        JarEntry entry = jarFile.getJarEntry(MANIFEST_RELATIVE_PATH);
        if (entry != null) {
            InputStream is;
            try {
                is = jarFile.getInputStream(entry);
            }
            catch (Exception e) {
                debugLogger.trace("Unable to get input stream from jar", (Throwable)e);
                LocalizableMessage message = ConfigMessages.ERR_ADMIN_CANNOT_READ_EXTENSION_MANIFEST.get((Object)MANIFEST_RELATIVE_PATH, (Object)jarFile.getName(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
                throw new ConfigException(message);
            }
            try {
                this.loadDefinitionClasses(is);
            }
            catch (ConfigException e) {
                debugLogger.trace("Unable to load classes from input stream", (Throwable)e);
                LocalizableMessage message = ConfigMessages.ERR_CLASS_LOADER_CANNOT_LOAD_EXTENSION.get((Object)jarFile.getName(), (Object)MANIFEST_RELATIVE_PATH, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
                throw new ConfigException(message);
            }
            try {
                String[] information = ConfigurationFramework.getBuildInformation(jarFile);
                LocalizableMessage message = ConfigMessages.NOTE_LOG_EXTENSION_INFORMATION.get((Object)jarFile.getName(), (Object)information[1], (Object)information[2]);
                LocalizedLogger.getLocalizedLogger((String)message.resourceName()).info(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadDefinitionClasses(InputStream is) throws ConfigException {
        LocalizableMessage msg;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        LinkedList<AbstractManagedObjectDefinition> definitions = new LinkedList<AbstractManagedObjectDefinition>();
        while (true) {
            AbstractManagedObjectDefinition d;
            Method method;
            Class<?> theClass;
            String className;
            try {
                className = reader.readLine();
            }
            catch (IOException e) {
                LocalizableMessage msg2 = ConfigMessages.ERR_CLASS_LOADER_CANNOT_READ_MANIFEST_FILE.get((Object)e.getMessage());
                throw new ConfigException(msg2, (Throwable)e);
            }
            if (className == null) break;
            if ((className = className.trim()).isEmpty() || className.startsWith("#")) continue;
            debugLogger.trace("Loading class " + className);
            try {
                theClass = Class.forName(className, true, this.loader);
            }
            catch (Exception e) {
                msg = ConfigMessages.ERR_CLASS_LOADER_CANNOT_LOAD_CLASS.get((Object)className, (Object)e.getMessage());
                throw new ConfigException(msg, (Throwable)e);
            }
            if (!AbstractManagedObjectDefinition.class.isAssignableFrom(theClass)) continue;
            try {
                method = theClass.getMethod("getInstance", new Class[0]);
            }
            catch (Exception e) {
                LocalizableMessage msg3 = ConfigMessages.ERR_CLASS_LOADER_CANNOT_FIND_GET_INSTANCE_METHOD.get((Object)className, (Object)e.getMessage());
                throw new ConfigException(msg3, (Throwable)e);
            }
            try {
                d = (AbstractManagedObjectDefinition)method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LocalizableMessage msg4 = ConfigMessages.ERR_CLASS_LOADER_CANNOT_INVOKE_GET_INSTANCE_METHOD.get((Object)className, (Object)e.getMessage());
                throw new ConfigException(msg4, (Throwable)e);
            }
            definitions.add(d);
        }
        for (AbstractManagedObjectDefinition d : definitions) {
            try {
                d.initialize();
            }
            catch (Exception e) {
                msg = ConfigMessages.ERR_CLASS_LOADER_CANNOT_INITIALIZE_DEFN.get((Object)d.getName(), (Object)d.getClass().getName(), (Object)e.getMessage());
                throw new ConfigException(msg, (Throwable)e);
            }
        }
    }

    private JarFile loadJarFile(File jar) throws ConfigException {
        try {
            return new JarFile(jar);
        }
        catch (Exception e) {
            debugLogger.trace("Unable to load jar file: " + jar, (Throwable)e);
            LocalizableMessage message = ConfigMessages.ERR_ADMIN_CANNOT_OPEN_JAR_FILE.get((Object)jar.getName(), (Object)jar.getParent(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
            throw new ConfigException(message);
        }
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public String getInstancePath() {
        return this.instancePath;
    }

    private static final class MyURLClassLoader
    extends URLClassLoader {
        public MyURLClassLoader() {
            super(new URL[0]);
        }

        public MyURLClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        public void addJarFile(File jarFile) throws MalformedURLException {
            this.addURL(jarFile.toURI().toURL());
        }
    }
}

