/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.KeyManagerProviderCfgClient;
import org.forgerock.opendj.server.config.client.StaticServiceDiscoveryMechanismCfgClient;
import org.forgerock.opendj.server.config.client.TrustManagerProviderCfgClient;
import org.forgerock.opendj.server.config.meta.ServiceDiscoveryMechanismCfgDefn;
import org.forgerock.opendj.server.config.server.KeyManagerProviderCfg;
import org.forgerock.opendj.server.config.server.ServiceDiscoveryMechanismCfg;
import org.forgerock.opendj.server.config.server.StaticServiceDiscoveryMechanismCfg;
import org.forgerock.opendj.server.config.server.TrustManagerProviderCfg;

public final class StaticServiceDiscoveryMechanismCfgDefn
extends ManagedObjectDefinition<StaticServiceDiscoveryMechanismCfgClient, StaticServiceDiscoveryMechanismCfg> {
    private static final StaticServiceDiscoveryMechanismCfgDefn INSTANCE = new StaticServiceDiscoveryMechanismCfgDefn();
    private static final DurationPropertyDefinition PD_DISCOVERY_INTERVAL;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_PRIMARY_SERVER;
    private static final StringPropertyDefinition PD_SECONDARY_SERVER;

    public static StaticServiceDiscoveryMechanismCfgDefn getInstance() {
        return INSTANCE;
    }

    private StaticServiceDiscoveryMechanismCfgDefn() {
        super("static-service-discovery-mechanism", ServiceDiscoveryMechanismCfgDefn.getInstance());
    }

    @Override
    public StaticServiceDiscoveryMechanismCfgClient createClientConfiguration(ManagedObject<? extends StaticServiceDiscoveryMechanismCfgClient> impl) {
        return new StaticServiceDiscoveryMechanismCfgClientImpl(impl);
    }

    @Override
    public StaticServiceDiscoveryMechanismCfg createServerConfiguration(ServerManagedObject<? extends StaticServiceDiscoveryMechanismCfg> impl) {
        return new StaticServiceDiscoveryMechanismCfgServerImpl(impl);
    }

    @Override
    public Class<StaticServiceDiscoveryMechanismCfg> getServerConfigurationClass() {
        return StaticServiceDiscoveryMechanismCfg.class;
    }

    public DurationPropertyDefinition getDiscoveryIntervalPropertyDefinition() {
        return PD_DISCOVERY_INTERVAL;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> getKeyManagerProviderPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getKeyManagerProviderPropertyDefinition();
    }

    public StringPropertyDefinition getPrimaryServerPropertyDefinition() {
        return PD_PRIMARY_SERVER;
    }

    public StringPropertyDefinition getSecondaryServerPropertyDefinition() {
        return PD_SECONDARY_SERVER;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getSSLCertNicknamePropertyDefinition();
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getTrustManagerProviderPropertyDefinition();
    }

    public BooleanPropertyDefinition getUseSSLPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getUseSSLPropertyDefinition();
    }

    public BooleanPropertyDefinition getUseStartTLSPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getUseStartTLSPropertyDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = DurationPropertyDefinition.createBuilder(INSTANCE, "discovery-interval");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "discovery-interval"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("60s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1s");
        PD_DISCOVERY_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISCOVERY_INTERVAL);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.proxy.StaticServiceDiscoveryMechanism");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.backends.proxy.ServiceDiscoveryMechanism");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "primary-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "primary-server"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_PRIMARY_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRIMARY_SERVER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "secondary-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "secondary-server"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_SECONDARY_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SECONDARY_SERVER);
        INSTANCE.registerTag(Tag.valueOf("service-discovery"));
    }

    private static class StaticServiceDiscoveryMechanismCfgServerImpl
    implements StaticServiceDiscoveryMechanismCfg {
        private ServerManagedObject<? extends StaticServiceDiscoveryMechanismCfg> impl;
        private final long pDiscoveryInterval;
        private final String pJavaClass;
        private final String pKeyManagerProvider;
        private final SortedSet<String> pPrimaryServer;
        private final SortedSet<String> pSecondaryServer;
        private final SortedSet<String> pSSLCertNickname;
        private final String pTrustManagerProvider;
        private final boolean pUseSSL;
        private final boolean pUseStartTLS;

        private StaticServiceDiscoveryMechanismCfgServerImpl(ServerManagedObject<? extends StaticServiceDiscoveryMechanismCfg> impl) {
            this.impl = impl;
            this.pDiscoveryInterval = impl.getPropertyValue(INSTANCE.getDiscoveryIntervalPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeyManagerProvider = impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
            this.pPrimaryServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getPrimaryServerPropertyDefinition());
            this.pSecondaryServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSecondaryServerPropertyDefinition());
            this.pSSLCertNickname = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCertNicknamePropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
            this.pUseSSL = impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
            this.pUseStartTLS = impl.getPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition());
        }

        @Override
        public void addStaticChangeListener(ConfigurationChangeListener<StaticServiceDiscoveryMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeStaticChangeListener(ConfigurationChangeListener<StaticServiceDiscoveryMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ServiceDiscoveryMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ServiceDiscoveryMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public long getDiscoveryInterval() {
            return this.pDiscoveryInterval;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.pKeyManagerProvider;
        }

        @Override
        public DN getKeyManagerProviderDN() {
            String value = this.getKeyManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getKeyManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public SortedSet<String> getPrimaryServer() {
            return this.pPrimaryServer;
        }

        @Override
        public SortedSet<String> getSecondaryServer() {
            return this.pSecondaryServer;
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.pSSLCertNickname;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public boolean isUseSSL() {
            return this.pUseSSL;
        }

        @Override
        public boolean isUseStartTLS() {
            return this.pUseStartTLS;
        }

        @Override
        public Class<? extends StaticServiceDiscoveryMechanismCfg> configurationClass() {
            return StaticServiceDiscoveryMechanismCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class StaticServiceDiscoveryMechanismCfgClientImpl
    implements StaticServiceDiscoveryMechanismCfgClient {
        private ManagedObject<? extends StaticServiceDiscoveryMechanismCfgClient> impl;

        private StaticServiceDiscoveryMechanismCfgClientImpl(ManagedObject<? extends StaticServiceDiscoveryMechanismCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public long getDiscoveryInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDiscoveryIntervalPropertyDefinition());
        }

        @Override
        public void setDiscoveryInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDiscoveryIntervalPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
        }

        @Override
        public void setKeyManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getPrimaryServer() {
            return this.impl.getPropertyValues(INSTANCE.getPrimaryServerPropertyDefinition());
        }

        @Override
        public void setPrimaryServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getPrimaryServerPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSecondaryServer() {
            return this.impl.getPropertyValues(INSTANCE.getSecondaryServerPropertyDefinition());
        }

        @Override
        public void setSecondaryServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSecondaryServerPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition(), values);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public boolean isUseSSL() {
            return this.impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
        }

        @Override
        public void setUseSSL(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseSSLPropertyDefinition(), value);
        }

        @Override
        public boolean isUseStartTLS() {
            return this.impl.getPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition());
        }

        @Override
        public void setUseStartTLS(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends StaticServiceDiscoveryMechanismCfgClient, ? extends StaticServiceDiscoveryMechanismCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

