/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.SizeLimitLogRetentionPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.LogRetentionPolicyCfgDefn;
import org.forgerock.opendj.server.config.server.LogRetentionPolicyCfg;
import org.forgerock.opendj.server.config.server.SizeLimitLogRetentionPolicyCfg;

public final class SizeLimitLogRetentionPolicyCfgDefn
extends ManagedObjectDefinition<SizeLimitLogRetentionPolicyCfgClient, SizeLimitLogRetentionPolicyCfg> {
    private static final SizeLimitLogRetentionPolicyCfgDefn INSTANCE = new SizeLimitLogRetentionPolicyCfgDefn();
    private static final SizePropertyDefinition PD_DISK_SPACE_USED;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static SizeLimitLogRetentionPolicyCfgDefn getInstance() {
        return INSTANCE;
    }

    private SizeLimitLogRetentionPolicyCfgDefn() {
        super("size-limit-log-retention-policy", LogRetentionPolicyCfgDefn.getInstance());
    }

    @Override
    public SizeLimitLogRetentionPolicyCfgClient createClientConfiguration(ManagedObject<? extends SizeLimitLogRetentionPolicyCfgClient> impl) {
        return new SizeLimitLogRetentionPolicyCfgClientImpl(impl);
    }

    @Override
    public SizeLimitLogRetentionPolicyCfg createServerConfiguration(ServerManagedObject<? extends SizeLimitLogRetentionPolicyCfg> impl) {
        return new SizeLimitLogRetentionPolicyCfgServerImpl(impl);
    }

    @Override
    public Class<SizeLimitLogRetentionPolicyCfg> getServerConfigurationClass() {
        return SizeLimitLogRetentionPolicyCfg.class;
    }

    public SizePropertyDefinition getDiskSpaceUsedPropertyDefinition() {
        return PD_DISK_SPACE_USED;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = SizePropertyDefinition.createBuilder(INSTANCE, "disk-space-used");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disk-space-used"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_DISK_SPACE_USED = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISK_SPACE_USED);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.SizeBasedRetentionPolicy");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.RetentionPolicy");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class SizeLimitLogRetentionPolicyCfgServerImpl
    implements SizeLimitLogRetentionPolicyCfg {
        private ServerManagedObject<? extends SizeLimitLogRetentionPolicyCfg> impl;
        private final long pDiskSpaceUsed;
        private final String pJavaClass;

        private SizeLimitLogRetentionPolicyCfgServerImpl(ServerManagedObject<? extends SizeLimitLogRetentionPolicyCfg> impl) {
            this.impl = impl;
            this.pDiskSpaceUsed = impl.getPropertyValue(INSTANCE.getDiskSpaceUsedPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addSizeLimitChangeListener(ConfigurationChangeListener<SizeLimitLogRetentionPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeSizeLimitChangeListener(ConfigurationChangeListener<SizeLimitLogRetentionPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogRetentionPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogRetentionPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public long getDiskSpaceUsed() {
            return this.pDiskSpaceUsed;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends SizeLimitLogRetentionPolicyCfg> configurationClass() {
            return SizeLimitLogRetentionPolicyCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class SizeLimitLogRetentionPolicyCfgClientImpl
    implements SizeLimitLogRetentionPolicyCfgClient {
        private ManagedObject<? extends SizeLimitLogRetentionPolicyCfgClient> impl;

        private SizeLimitLogRetentionPolicyCfgClientImpl(ManagedObject<? extends SizeLimitLogRetentionPolicyCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Long getDiskSpaceUsed() {
            return this.impl.getPropertyValue(INSTANCE.getDiskSpaceUsedPropertyDefinition());
        }

        @Override
        public void setDiskSpaceUsed(long value) {
            this.impl.setPropertyValue(INSTANCE.getDiskSpaceUsedPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends SizeLimitLogRetentionPolicyCfgClient, ? extends SizeLimitLogRetentionPolicyCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

