/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.KeyManagerProviderCfgClient;
import org.forgerock.opendj.server.config.client.ReplicationServiceDiscoveryMechanismCfgClient;
import org.forgerock.opendj.server.config.client.TrustManagerProviderCfgClient;
import org.forgerock.opendj.server.config.meta.ServiceDiscoveryMechanismCfgDefn;
import org.forgerock.opendj.server.config.server.KeyManagerProviderCfg;
import org.forgerock.opendj.server.config.server.ReplicationServiceDiscoveryMechanismCfg;
import org.forgerock.opendj.server.config.server.ServiceDiscoveryMechanismCfg;
import org.forgerock.opendj.server.config.server.TrustManagerProviderCfg;

public final class ReplicationServiceDiscoveryMechanismCfgDefn
extends ManagedObjectDefinition<ReplicationServiceDiscoveryMechanismCfgClient, ReplicationServiceDiscoveryMechanismCfg> {
    private static final ReplicationServiceDiscoveryMechanismCfgDefn INSTANCE = new ReplicationServiceDiscoveryMechanismCfgDefn();
    private static final DNPropertyDefinition PD_BIND_DN;
    private static final StringPropertyDefinition PD_BIND_PASSWORD;
    private static final DurationPropertyDefinition PD_DISCOVERY_INTERVAL;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_PRIMARY_GROUP_ID;
    private static final StringPropertyDefinition PD_REPLICATION_SERVER;

    public static ReplicationServiceDiscoveryMechanismCfgDefn getInstance() {
        return INSTANCE;
    }

    private ReplicationServiceDiscoveryMechanismCfgDefn() {
        super("replication-service-discovery-mechanism", ServiceDiscoveryMechanismCfgDefn.getInstance());
    }

    @Override
    public ReplicationServiceDiscoveryMechanismCfgClient createClientConfiguration(ManagedObject<? extends ReplicationServiceDiscoveryMechanismCfgClient> impl) {
        return new ReplicationServiceDiscoveryMechanismCfgClientImpl(impl);
    }

    @Override
    public ReplicationServiceDiscoveryMechanismCfg createServerConfiguration(ServerManagedObject<? extends ReplicationServiceDiscoveryMechanismCfg> impl) {
        return new ReplicationServiceDiscoveryMechanismCfgServerImpl(impl);
    }

    @Override
    public Class<ReplicationServiceDiscoveryMechanismCfg> getServerConfigurationClass() {
        return ReplicationServiceDiscoveryMechanismCfg.class;
    }

    public DNPropertyDefinition getBindDNPropertyDefinition() {
        return PD_BIND_DN;
    }

    public StringPropertyDefinition getBindPasswordPropertyDefinition() {
        return PD_BIND_PASSWORD;
    }

    public DurationPropertyDefinition getDiscoveryIntervalPropertyDefinition() {
        return PD_DISCOVERY_INTERVAL;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> getKeyManagerProviderPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getKeyManagerProviderPropertyDefinition();
    }

    public IntegerPropertyDefinition getPrimaryGroupIdPropertyDefinition() {
        return PD_PRIMARY_GROUP_ID;
    }

    public StringPropertyDefinition getReplicationServerPropertyDefinition() {
        return PD_REPLICATION_SERVER;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getSSLCertNicknamePropertyDefinition();
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getTrustManagerProviderPropertyDefinition();
    }

    public BooleanPropertyDefinition getUseSSLPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getUseSSLPropertyDefinition();
    }

    public BooleanPropertyDefinition getUseStartTLSPropertyDefinition() {
        return ServiceDiscoveryMechanismCfgDefn.getInstance().getUseStartTLSPropertyDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = DNPropertyDefinition.createBuilder(INSTANCE, "bind-dn");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "bind-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BIND_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BIND_DN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "bind-password");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "bind-password"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BIND_PASSWORD = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BIND_PASSWORD);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "discovery-interval");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "discovery-interval"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("60s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1s");
        PD_DISCOVERY_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISCOVERY_INTERVAL);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.proxy.ReplicationServiceDiscoveryMechanism");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.backends.proxy.ServiceDiscoveryMechanism");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "primary-group-id");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "primary-group-id"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "primary-group-id"));
        PD_PRIMARY_GROUP_ID = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRIMARY_GROUP_ID);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "replication-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-server"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_REPLICATION_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_SERVER);
        INSTANCE.registerTag(Tag.valueOf("service-discovery"));
    }

    private static class ReplicationServiceDiscoveryMechanismCfgServerImpl
    implements ReplicationServiceDiscoveryMechanismCfg {
        private ServerManagedObject<? extends ReplicationServiceDiscoveryMechanismCfg> impl;
        private final DN pBindDN;
        private final String pBindPassword;
        private final long pDiscoveryInterval;
        private final String pJavaClass;
        private final String pKeyManagerProvider;
        private final Integer pPrimaryGroupId;
        private final SortedSet<String> pReplicationServer;
        private final SortedSet<String> pSSLCertNickname;
        private final String pTrustManagerProvider;
        private final boolean pUseSSL;
        private final boolean pUseStartTLS;

        private ReplicationServiceDiscoveryMechanismCfgServerImpl(ServerManagedObject<? extends ReplicationServiceDiscoveryMechanismCfg> impl) {
            this.impl = impl;
            this.pBindDN = impl.getPropertyValue(INSTANCE.getBindDNPropertyDefinition());
            this.pBindPassword = impl.getPropertyValue(INSTANCE.getBindPasswordPropertyDefinition());
            this.pDiscoveryInterval = impl.getPropertyValue(INSTANCE.getDiscoveryIntervalPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeyManagerProvider = impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
            this.pPrimaryGroupId = impl.getPropertyValue(INSTANCE.getPrimaryGroupIdPropertyDefinition());
            this.pReplicationServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getReplicationServerPropertyDefinition());
            this.pSSLCertNickname = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCertNicknamePropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
            this.pUseSSL = impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
            this.pUseStartTLS = impl.getPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition());
        }

        @Override
        public void addReplicationChangeListener(ConfigurationChangeListener<ReplicationServiceDiscoveryMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeReplicationChangeListener(ConfigurationChangeListener<ReplicationServiceDiscoveryMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ServiceDiscoveryMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ServiceDiscoveryMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public DN getBindDN() {
            return this.pBindDN;
        }

        @Override
        public String getBindPassword() {
            return this.pBindPassword;
        }

        @Override
        public long getDiscoveryInterval() {
            return this.pDiscoveryInterval;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.pKeyManagerProvider;
        }

        @Override
        public DN getKeyManagerProviderDN() {
            String value = this.getKeyManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getKeyManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public Integer getPrimaryGroupId() {
            return this.pPrimaryGroupId;
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.pReplicationServer;
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.pSSLCertNickname;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public boolean isUseSSL() {
            return this.pUseSSL;
        }

        @Override
        public boolean isUseStartTLS() {
            return this.pUseStartTLS;
        }

        @Override
        public Class<? extends ReplicationServiceDiscoveryMechanismCfg> configurationClass() {
            return ReplicationServiceDiscoveryMechanismCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class ReplicationServiceDiscoveryMechanismCfgClientImpl
    implements ReplicationServiceDiscoveryMechanismCfgClient {
        private ManagedObject<? extends ReplicationServiceDiscoveryMechanismCfgClient> impl;

        private ReplicationServiceDiscoveryMechanismCfgClientImpl(ManagedObject<? extends ReplicationServiceDiscoveryMechanismCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public DN getBindDN() {
            return this.impl.getPropertyValue(INSTANCE.getBindDNPropertyDefinition());
        }

        @Override
        public void setBindDN(DN value) {
            this.impl.setPropertyValue(INSTANCE.getBindDNPropertyDefinition(), value);
        }

        @Override
        public String getBindPassword() {
            return this.impl.getPropertyValue(INSTANCE.getBindPasswordPropertyDefinition());
        }

        @Override
        public void setBindPassword(String value) {
            this.impl.setPropertyValue(INSTANCE.getBindPasswordPropertyDefinition(), value);
        }

        @Override
        public long getDiscoveryInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDiscoveryIntervalPropertyDefinition());
        }

        @Override
        public void setDiscoveryInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDiscoveryIntervalPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
        }

        @Override
        public void setKeyManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition(), value);
        }

        @Override
        public Integer getPrimaryGroupId() {
            return this.impl.getPropertyValue(INSTANCE.getPrimaryGroupIdPropertyDefinition());
        }

        @Override
        public void setPrimaryGroupId(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getPrimaryGroupIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.impl.getPropertyValues(INSTANCE.getReplicationServerPropertyDefinition());
        }

        @Override
        public void setReplicationServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getReplicationServerPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition(), values);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public boolean isUseSSL() {
            return this.impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
        }

        @Override
        public void setUseSSL(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseSSLPropertyDefinition(), value);
        }

        @Override
        public boolean isUseStartTLS() {
            return this.impl.getPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition());
        }

        @Override
        public void setUseStartTLS(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ReplicationServiceDiscoveryMechanismCfgClient, ? extends ReplicationServiceDiscoveryMechanismCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

