/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.net.InetAddress;
import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.ReplicationServerCfgClient;
import org.forgerock.opendj.server.config.server.ReplicationServerCfg;

public final class ReplicationServerCfgDefn
extends ManagedObjectDefinition<ReplicationServerCfgClient, ReplicationServerCfg> {
    private static final ReplicationServerCfgDefn INSTANCE = new ReplicationServerCfgDefn();
    private static final DurationPropertyDefinition PD_ASSURED_TIMEOUT;
    private static final IntegerPropertyDefinition PD_CIPHER_KEY_LENGTH;
    private static final StringPropertyDefinition PD_CIPHER_TRANSFORMATION;
    private static final BooleanPropertyDefinition PD_COMPUTE_CHANGE_NUMBER;
    private static final BooleanPropertyDefinition PD_CONFIDENTIALITY_ENABLED;
    private static final IntegerPropertyDefinition PD_DEGRADED_STATUS_THRESHOLD;
    private static final IntegerPropertyDefinition PD_GROUP_ID;
    private static final DurationPropertyDefinition PD_MONITORING_PERIOD;
    private static final IntegerPropertyDefinition PD_QUEUE_SIZE;
    private static final StringPropertyDefinition PD_REPLICATION_DB_DIRECTORY;
    private static final IntegerPropertyDefinition PD_REPLICATION_PORT;
    private static final DurationPropertyDefinition PD_REPLICATION_PURGE_DELAY;
    private static final StringPropertyDefinition PD_REPLICATION_SERVER;
    private static final IntegerPropertyDefinition PD_REPLICATION_SERVER_ID;
    private static final IPAddressPropertyDefinition PD_SOURCE_ADDRESS;
    private static final IntegerPropertyDefinition PD_WEIGHT;
    private static final IntegerPropertyDefinition PD_WINDOW_SIZE;

    public static ReplicationServerCfgDefn getInstance() {
        return INSTANCE;
    }

    private ReplicationServerCfgDefn() {
        super("replication-server", TopCfgDefn.getInstance());
    }

    @Override
    public ReplicationServerCfgClient createClientConfiguration(ManagedObject<? extends ReplicationServerCfgClient> impl) {
        return new ReplicationServerCfgClientImpl(impl);
    }

    @Override
    public ReplicationServerCfg createServerConfiguration(ServerManagedObject<? extends ReplicationServerCfg> impl) {
        return new ReplicationServerCfgServerImpl(impl);
    }

    @Override
    public Class<ReplicationServerCfg> getServerConfigurationClass() {
        return ReplicationServerCfg.class;
    }

    public DurationPropertyDefinition getAssuredTimeoutPropertyDefinition() {
        return PD_ASSURED_TIMEOUT;
    }

    public IntegerPropertyDefinition getCipherKeyLengthPropertyDefinition() {
        return PD_CIPHER_KEY_LENGTH;
    }

    public StringPropertyDefinition getCipherTransformationPropertyDefinition() {
        return PD_CIPHER_TRANSFORMATION;
    }

    public BooleanPropertyDefinition getComputeChangeNumberPropertyDefinition() {
        return PD_COMPUTE_CHANGE_NUMBER;
    }

    public BooleanPropertyDefinition getConfidentialityEnabledPropertyDefinition() {
        return PD_CONFIDENTIALITY_ENABLED;
    }

    public IntegerPropertyDefinition getDegradedStatusThresholdPropertyDefinition() {
        return PD_DEGRADED_STATUS_THRESHOLD;
    }

    public IntegerPropertyDefinition getGroupIdPropertyDefinition() {
        return PD_GROUP_ID;
    }

    public DurationPropertyDefinition getMonitoringPeriodPropertyDefinition() {
        return PD_MONITORING_PERIOD;
    }

    public IntegerPropertyDefinition getQueueSizePropertyDefinition() {
        return PD_QUEUE_SIZE;
    }

    public StringPropertyDefinition getReplicationDBDirectoryPropertyDefinition() {
        return PD_REPLICATION_DB_DIRECTORY;
    }

    public IntegerPropertyDefinition getReplicationPortPropertyDefinition() {
        return PD_REPLICATION_PORT;
    }

    public DurationPropertyDefinition getReplicationPurgeDelayPropertyDefinition() {
        return PD_REPLICATION_PURGE_DELAY;
    }

    public StringPropertyDefinition getReplicationServerPropertyDefinition() {
        return PD_REPLICATION_SERVER;
    }

    public IntegerPropertyDefinition getReplicationServerIdPropertyDefinition() {
        return PD_REPLICATION_SERVER_ID;
    }

    public IPAddressPropertyDefinition getSourceAddressPropertyDefinition() {
        return PD_SOURCE_ADDRESS;
    }

    public IntegerPropertyDefinition getWeightPropertyDefinition() {
        return PD_WEIGHT;
    }

    public IntegerPropertyDefinition getWindowSizePropertyDefinition() {
        return PD_WINDOW_SIZE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = DurationPropertyDefinition.createBuilder(INSTANCE, "assured-timeout");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "assured-timeout"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("1000ms");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_ASSURED_TIMEOUT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ASSURED_TIMEOUT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "cipher-key-length");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cipher-key-length"));
        provider = new DefinedDefaultBehaviorProvider("128");
        builder.setDefaultBehaviorProvider(provider);
        PD_CIPHER_KEY_LENGTH = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CIPHER_KEY_LENGTH);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "cipher-transformation");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "cipher-transformation"));
        provider = new DefinedDefaultBehaviorProvider("AES/CBC/PKCS5Padding");
        builder.setDefaultBehaviorProvider(provider);
        PD_CIPHER_TRANSFORMATION = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CIPHER_TRANSFORMATION);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "compute-change-number");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "compute-change-number"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_COMPUTE_CHANGE_NUMBER = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_COMPUTE_CHANGE_NUMBER);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "confidentiality-enabled");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "confidentiality-enabled"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_CONFIDENTIALITY_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONFIDENTIALITY_ENABLED);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "degraded-status-threshold");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "degraded-status-threshold"));
        provider = new DefinedDefaultBehaviorProvider("5000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_DEGRADED_STATUS_THRESHOLD = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEGRADED_STATUS_THRESHOLD);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "group-id");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "group-id"));
        provider = new DefinedDefaultBehaviorProvider("1");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(127);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_GROUP_ID = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_GROUP_ID);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "monitoring-period");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "monitoring-period"));
        provider = new DefinedDefaultBehaviorProvider("60s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_MONITORING_PERIOD = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MONITORING_PERIOD);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "queue-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "queue-size"));
        provider = new DefinedDefaultBehaviorProvider("10000");
        builder.setDefaultBehaviorProvider(provider);
        PD_QUEUE_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_QUEUE_SIZE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "replication-db-directory");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-db-directory"));
        provider = new DefinedDefaultBehaviorProvider("changelogDb");
        builder.setDefaultBehaviorProvider(provider);
        PD_REPLICATION_DB_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_DB_DIRECTORY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "replication-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_REPLICATION_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_PORT);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "replication-purge-delay");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-purge-delay"));
        provider = new DefinedDefaultBehaviorProvider("3 days");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(false);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        PD_REPLICATION_PURGE_DELAY = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_PURGE_DELAY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "replication-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-server"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_REPLICATION_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_SERVER);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "replication-server-id");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-server-id"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_REPLICATION_SERVER_ID = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_SERVER_ID);
        builder = IPAddressPropertyDefinition.createBuilder(INSTANCE, "source-address");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "source-address"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "source-address"));
        PD_SOURCE_ADDRESS = (IPAddressPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SOURCE_ADDRESS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "weight");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "weight"));
        provider = new DefinedDefaultBehaviorProvider("1");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_WEIGHT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WEIGHT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "window-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "window-size"));
        provider = new DefinedDefaultBehaviorProvider("100000");
        builder.setDefaultBehaviorProvider(provider);
        PD_WINDOW_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WINDOW_SIZE);
        INSTANCE.registerTag(Tag.valueOf("replication"));
    }

    private static class ReplicationServerCfgServerImpl
    implements ReplicationServerCfg {
        private ServerManagedObject<? extends ReplicationServerCfg> impl;
        private final long pAssuredTimeout;
        private final int pCipherKeyLength;
        private final String pCipherTransformation;
        private final boolean pComputeChangeNumber;
        private final boolean pConfidentialityEnabled;
        private final int pDegradedStatusThreshold;
        private final int pGroupId;
        private final long pMonitoringPeriod;
        private final int pQueueSize;
        private final String pReplicationDBDirectory;
        private final int pReplicationPort;
        private final long pReplicationPurgeDelay;
        private final SortedSet<String> pReplicationServer;
        private final int pReplicationServerId;
        private final InetAddress pSourceAddress;
        private final int pWeight;
        private final int pWindowSize;

        private ReplicationServerCfgServerImpl(ServerManagedObject<? extends ReplicationServerCfg> impl) {
            this.impl = impl;
            this.pAssuredTimeout = impl.getPropertyValue(INSTANCE.getAssuredTimeoutPropertyDefinition());
            this.pCipherKeyLength = impl.getPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition());
            this.pCipherTransformation = impl.getPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition());
            this.pComputeChangeNumber = impl.getPropertyValue(INSTANCE.getComputeChangeNumberPropertyDefinition());
            this.pConfidentialityEnabled = impl.getPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition());
            this.pDegradedStatusThreshold = impl.getPropertyValue(INSTANCE.getDegradedStatusThresholdPropertyDefinition());
            this.pGroupId = impl.getPropertyValue(INSTANCE.getGroupIdPropertyDefinition());
            this.pMonitoringPeriod = impl.getPropertyValue(INSTANCE.getMonitoringPeriodPropertyDefinition());
            this.pQueueSize = impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
            this.pReplicationDBDirectory = impl.getPropertyValue(INSTANCE.getReplicationDBDirectoryPropertyDefinition());
            this.pReplicationPort = impl.getPropertyValue(INSTANCE.getReplicationPortPropertyDefinition());
            this.pReplicationPurgeDelay = impl.getPropertyValue(INSTANCE.getReplicationPurgeDelayPropertyDefinition());
            this.pReplicationServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getReplicationServerPropertyDefinition());
            this.pReplicationServerId = impl.getPropertyValue(INSTANCE.getReplicationServerIdPropertyDefinition());
            this.pSourceAddress = impl.getPropertyValue(INSTANCE.getSourceAddressPropertyDefinition());
            this.pWeight = impl.getPropertyValue(INSTANCE.getWeightPropertyDefinition());
            this.pWindowSize = impl.getPropertyValue(INSTANCE.getWindowSizePropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ReplicationServerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ReplicationServerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public long getAssuredTimeout() {
            return this.pAssuredTimeout;
        }

        @Override
        public int getCipherKeyLength() {
            return this.pCipherKeyLength;
        }

        @Override
        public String getCipherTransformation() {
            return this.pCipherTransformation;
        }

        @Override
        public boolean isComputeChangeNumber() {
            return this.pComputeChangeNumber;
        }

        @Override
        public boolean isConfidentialityEnabled() {
            return this.pConfidentialityEnabled;
        }

        @Override
        public int getDegradedStatusThreshold() {
            return this.pDegradedStatusThreshold;
        }

        @Override
        public int getGroupId() {
            return this.pGroupId;
        }

        @Override
        public long getMonitoringPeriod() {
            return this.pMonitoringPeriod;
        }

        @Override
        public int getQueueSize() {
            return this.pQueueSize;
        }

        @Override
        public String getReplicationDBDirectory() {
            return this.pReplicationDBDirectory;
        }

        @Override
        public int getReplicationPort() {
            return this.pReplicationPort;
        }

        @Override
        public long getReplicationPurgeDelay() {
            return this.pReplicationPurgeDelay;
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.pReplicationServer;
        }

        @Override
        public int getReplicationServerId() {
            return this.pReplicationServerId;
        }

        @Override
        public InetAddress getSourceAddress() {
            return this.pSourceAddress;
        }

        @Override
        public int getWeight() {
            return this.pWeight;
        }

        @Override
        public int getWindowSize() {
            return this.pWindowSize;
        }

        @Override
        public Class<? extends ReplicationServerCfg> configurationClass() {
            return ReplicationServerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class ReplicationServerCfgClientImpl
    implements ReplicationServerCfgClient {
        private ManagedObject<? extends ReplicationServerCfgClient> impl;

        private ReplicationServerCfgClientImpl(ManagedObject<? extends ReplicationServerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public long getAssuredTimeout() {
            return this.impl.getPropertyValue(INSTANCE.getAssuredTimeoutPropertyDefinition());
        }

        @Override
        public void setAssuredTimeout(Long value) {
            this.impl.setPropertyValue(INSTANCE.getAssuredTimeoutPropertyDefinition(), value);
        }

        @Override
        public int getCipherKeyLength() {
            return this.impl.getPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition());
        }

        @Override
        public void setCipherKeyLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getCipherKeyLengthPropertyDefinition(), value);
        }

        @Override
        public String getCipherTransformation() {
            return this.impl.getPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition());
        }

        @Override
        public void setCipherTransformation(String value) {
            this.impl.setPropertyValue(INSTANCE.getCipherTransformationPropertyDefinition(), value);
        }

        @Override
        public boolean isComputeChangeNumber() {
            return this.impl.getPropertyValue(INSTANCE.getComputeChangeNumberPropertyDefinition());
        }

        @Override
        public void setComputeChangeNumber(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getComputeChangeNumberPropertyDefinition(), value);
        }

        @Override
        public boolean isConfidentialityEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition());
        }

        @Override
        public void setConfidentialityEnabled(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition(), value);
        }

        @Override
        public int getDegradedStatusThreshold() {
            return this.impl.getPropertyValue(INSTANCE.getDegradedStatusThresholdPropertyDefinition());
        }

        @Override
        public void setDegradedStatusThreshold(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDegradedStatusThresholdPropertyDefinition(), value);
        }

        @Override
        public int getGroupId() {
            return this.impl.getPropertyValue(INSTANCE.getGroupIdPropertyDefinition());
        }

        @Override
        public void setGroupId(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getGroupIdPropertyDefinition(), value);
        }

        @Override
        public long getMonitoringPeriod() {
            return this.impl.getPropertyValue(INSTANCE.getMonitoringPeriodPropertyDefinition());
        }

        @Override
        public void setMonitoringPeriod(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMonitoringPeriodPropertyDefinition(), value);
        }

        @Override
        public int getQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
        }

        @Override
        public void setQueueSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getQueueSizePropertyDefinition(), value);
        }

        @Override
        public String getReplicationDBDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationDBDirectoryPropertyDefinition());
        }

        @Override
        public void setReplicationDBDirectory(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getReplicationDBDirectoryPropertyDefinition(), value);
        }

        @Override
        public Integer getReplicationPort() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationPortPropertyDefinition());
        }

        @Override
        public void setReplicationPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getReplicationPortPropertyDefinition(), value);
        }

        @Override
        public long getReplicationPurgeDelay() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationPurgeDelayPropertyDefinition());
        }

        @Override
        public void setReplicationPurgeDelay(Long value) {
            this.impl.setPropertyValue(INSTANCE.getReplicationPurgeDelayPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.impl.getPropertyValues(INSTANCE.getReplicationServerPropertyDefinition());
        }

        @Override
        public void setReplicationServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getReplicationServerPropertyDefinition(), values);
        }

        @Override
        public Integer getReplicationServerId() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationServerIdPropertyDefinition());
        }

        @Override
        public void setReplicationServerId(int value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getReplicationServerIdPropertyDefinition(), value);
        }

        @Override
        public InetAddress getSourceAddress() {
            return this.impl.getPropertyValue(INSTANCE.getSourceAddressPropertyDefinition());
        }

        @Override
        public void setSourceAddress(InetAddress value) {
            this.impl.setPropertyValue(INSTANCE.getSourceAddressPropertyDefinition(), value);
        }

        @Override
        public int getWeight() {
            return this.impl.getPropertyValue(INSTANCE.getWeightPropertyDefinition());
        }

        @Override
        public void setWeight(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getWeightPropertyDefinition(), value);
        }

        @Override
        public int getWindowSize() {
            return this.impl.getPropertyValue(INSTANCE.getWindowSizePropertyDefinition());
        }

        @Override
        public void setWindowSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getWindowSizePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ReplicationServerCfgClient, ? extends ReplicationServerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

