/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.ParallelWorkQueueCfgClient;
import org.forgerock.opendj.server.config.meta.WorkQueueCfgDefn;
import org.forgerock.opendj.server.config.server.ParallelWorkQueueCfg;
import org.forgerock.opendj.server.config.server.WorkQueueCfg;

public final class ParallelWorkQueueCfgDefn
extends ManagedObjectDefinition<ParallelWorkQueueCfgClient, ParallelWorkQueueCfg> {
    private static final ParallelWorkQueueCfgDefn INSTANCE = new ParallelWorkQueueCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_NUM_WORKER_THREADS;

    public static ParallelWorkQueueCfgDefn getInstance() {
        return INSTANCE;
    }

    private ParallelWorkQueueCfgDefn() {
        super("parallel-work-queue", WorkQueueCfgDefn.getInstance());
    }

    @Override
    public ParallelWorkQueueCfgClient createClientConfiguration(ManagedObject<? extends ParallelWorkQueueCfgClient> impl) {
        return new ParallelWorkQueueCfgClientImpl(impl);
    }

    @Override
    public ParallelWorkQueueCfg createServerConfiguration(ServerManagedObject<? extends ParallelWorkQueueCfg> impl) {
        return new ParallelWorkQueueCfgServerImpl(impl);
    }

    @Override
    public Class<ParallelWorkQueueCfg> getServerConfigurationClass() {
        return ParallelWorkQueueCfg.class;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IntegerPropertyDefinition getNumWorkerThreadsPropertyDefinition() {
        return PD_NUM_WORKER_THREADS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.ParallelWorkQueue");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.WorkQueue");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-worker-threads");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "num-worker-threads"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "num-worker-threads"));
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_NUM_WORKER_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_WORKER_THREADS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class ParallelWorkQueueCfgServerImpl
    implements ParallelWorkQueueCfg {
        private ServerManagedObject<? extends ParallelWorkQueueCfg> impl;
        private final String pJavaClass;
        private final Integer pNumWorkerThreads;

        private ParallelWorkQueueCfgServerImpl(ServerManagedObject<? extends ParallelWorkQueueCfg> impl) {
            this.impl = impl;
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pNumWorkerThreads = impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void addParallelChangeListener(ConfigurationChangeListener<ParallelWorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeParallelChangeListener(ConfigurationChangeListener<ParallelWorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.pNumWorkerThreads;
        }

        @Override
        public Class<? extends ParallelWorkQueueCfg> configurationClass() {
            return ParallelWorkQueueCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class ParallelWorkQueueCfgClientImpl
    implements ParallelWorkQueueCfgClient {
        private ManagedObject<? extends ParallelWorkQueueCfgClient> impl;

        private ParallelWorkQueueCfgClientImpl(ManagedObject<? extends ParallelWorkQueueCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void setNumWorkerThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ParallelWorkQueueCfgClient, ? extends ParallelWorkQueueCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

