/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.net.InetAddress;
import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.GenericConstraint;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.AddressMask;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.HTTPConnectionHandlerCfgClient;
import org.forgerock.opendj.server.config.client.KeyManagerProviderCfgClient;
import org.forgerock.opendj.server.config.client.TrustManagerProviderCfgClient;
import org.forgerock.opendj.server.config.meta.ConnectionHandlerCfgDefn;
import org.forgerock.opendj.server.config.server.ConnectionHandlerCfg;
import org.forgerock.opendj.server.config.server.HTTPConnectionHandlerCfg;
import org.forgerock.opendj.server.config.server.KeyManagerProviderCfg;
import org.forgerock.opendj.server.config.server.TrustManagerProviderCfg;

public final class HTTPConnectionHandlerCfgDefn
extends ManagedObjectDefinition<HTTPConnectionHandlerCfgClient, HTTPConnectionHandlerCfg> {
    private static final HTTPConnectionHandlerCfgDefn INSTANCE = new HTTPConnectionHandlerCfgDefn();
    private static final IntegerPropertyDefinition PD_ACCEPT_BACKLOG;
    private static final BooleanPropertyDefinition PD_ALLOW_TCP_REUSE_ADDRESS;
    private static final SizePropertyDefinition PD_BUFFER_SIZE;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final BooleanPropertyDefinition PD_KEEP_STATS;
    private static final AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> PD_KEY_MANAGER_PROVIDER;
    private static final IPAddressPropertyDefinition PD_LISTEN_ADDRESS;
    private static final IntegerPropertyDefinition PD_LISTEN_PORT;
    private static final DurationPropertyDefinition PD_MAX_BLOCKED_WRITE_TIME_LIMIT;
    private static final IntegerPropertyDefinition PD_MAX_CONCURRENT_OPS_PER_CONNECTION;
    private static final SizePropertyDefinition PD_MAX_REQUEST_SIZE;
    private static final IntegerPropertyDefinition PD_NUM_REQUEST_HANDLERS;
    private static final StringPropertyDefinition PD_SSL_CERT_NICKNAME;
    private static final StringPropertyDefinition PD_SSL_CIPHER_SUITE;
    private static final EnumPropertyDefinition<SSLClientAuthPolicy> PD_SSL_CLIENT_AUTH_POLICY;
    private static final StringPropertyDefinition PD_SSL_PROTOCOL;
    private static final AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> PD_TRUST_MANAGER_PROVIDER;
    private static final BooleanPropertyDefinition PD_USE_SSL;
    private static final BooleanPropertyDefinition PD_USE_TCP_KEEP_ALIVE;
    private static final BooleanPropertyDefinition PD_USE_TCP_NO_DELAY;

    public static HTTPConnectionHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private HTTPConnectionHandlerCfgDefn() {
        super("http-connection-handler", ConnectionHandlerCfgDefn.getInstance());
    }

    @Override
    public HTTPConnectionHandlerCfgClient createClientConfiguration(ManagedObject<? extends HTTPConnectionHandlerCfgClient> impl) {
        return new HTTPConnectionHandlerCfgClientImpl(impl);
    }

    @Override
    public HTTPConnectionHandlerCfg createServerConfiguration(ServerManagedObject<? extends HTTPConnectionHandlerCfg> impl) {
        return new HTTPConnectionHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<HTTPConnectionHandlerCfg> getServerConfigurationClass() {
        return HTTPConnectionHandlerCfg.class;
    }

    public IntegerPropertyDefinition getAcceptBacklogPropertyDefinition() {
        return PD_ACCEPT_BACKLOG;
    }

    public IPAddressMaskPropertyDefinition getAllowedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getAllowedClientPropertyDefinition();
    }

    public BooleanPropertyDefinition getAllowTCPReuseAddressPropertyDefinition() {
        return PD_ALLOW_TCP_REUSE_ADDRESS;
    }

    public SizePropertyDefinition getBufferSizePropertyDefinition() {
        return PD_BUFFER_SIZE;
    }

    public IPAddressMaskPropertyDefinition getDeniedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getDeniedClientPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public BooleanPropertyDefinition getKeepStatsPropertyDefinition() {
        return PD_KEEP_STATS;
    }

    public AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> getKeyManagerProviderPropertyDefinition() {
        return PD_KEY_MANAGER_PROVIDER;
    }

    public IPAddressPropertyDefinition getListenAddressPropertyDefinition() {
        return PD_LISTEN_ADDRESS;
    }

    public IntegerPropertyDefinition getListenPortPropertyDefinition() {
        return PD_LISTEN_PORT;
    }

    public DurationPropertyDefinition getMaxBlockedWriteTimeLimitPropertyDefinition() {
        return PD_MAX_BLOCKED_WRITE_TIME_LIMIT;
    }

    public IntegerPropertyDefinition getMaxConcurrentOpsPerConnectionPropertyDefinition() {
        return PD_MAX_CONCURRENT_OPS_PER_CONNECTION;
    }

    public SizePropertyDefinition getMaxRequestSizePropertyDefinition() {
        return PD_MAX_REQUEST_SIZE;
    }

    public IntegerPropertyDefinition getNumRequestHandlersPropertyDefinition() {
        return PD_NUM_REQUEST_HANDLERS;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return PD_SSL_CERT_NICKNAME;
    }

    public StringPropertyDefinition getSSLCipherSuitePropertyDefinition() {
        return PD_SSL_CIPHER_SUITE;
    }

    public EnumPropertyDefinition<SSLClientAuthPolicy> getSSLClientAuthPolicyPropertyDefinition() {
        return PD_SSL_CLIENT_AUTH_POLICY;
    }

    public StringPropertyDefinition getSSLProtocolPropertyDefinition() {
        return PD_SSL_PROTOCOL;
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return PD_TRUST_MANAGER_PROVIDER;
    }

    public BooleanPropertyDefinition getUseSSLPropertyDefinition() {
        return PD_USE_SSL;
    }

    public BooleanPropertyDefinition getUseTCPKeepAlivePropertyDefinition() {
        return PD_USE_TCP_KEEP_ALIVE;
    }

    public BooleanPropertyDefinition getUseTCPNoDelayPropertyDefinition() {
        return PD_USE_TCP_NO_DELAY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "accept-backlog");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "accept-backlog"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("128");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_ACCEPT_BACKLOG = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ACCEPT_BACKLOG);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-tcp-reuse-address");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "allow-tcp-reuse-address"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_TCP_REUSE_ADDRESS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_TCP_REUSE_ADDRESS);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "buffer-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "buffer-size"));
        provider = new DefinedDefaultBehaviorProvider("4096 bytes");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setUpperLimit("2147483647b");
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1b");
        PD_BUFFER_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BUFFER_SIZE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.http.HTTPConnectionHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.ConnectionHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "keep-stats");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "keep-stats"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_KEEP_STATS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEEP_STATS);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "key-manager-provider");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-manager-provider"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("key-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.and(Conditions.contains("enabled", "true"), Conditions.contains("use-ssl", "true")));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_KEY_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_KEY_MANAGER_PROVIDER.getSourceConstraint());
        builder = IPAddressPropertyDefinition.createBuilder(INSTANCE, "listen-address");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "listen-address"));
        provider = new DefinedDefaultBehaviorProvider("0.0.0.0");
        builder.setDefaultBehaviorProvider(provider);
        PD_LISTEN_ADDRESS = (IPAddressPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_ADDRESS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "listen-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "listen-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_LISTEN_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_PORT);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "max-blocked-write-time-limit");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-blocked-write-time-limit"));
        provider = new DefinedDefaultBehaviorProvider("2 minutes");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_MAX_BLOCKED_WRITE_TIME_LIMIT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_BLOCKED_WRITE_TIME_LIMIT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-concurrent-ops-per-connection");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-concurrent-ops-per-connection"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "max-concurrent-ops-per-connection"));
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_MAX_CONCURRENT_OPS_PER_CONNECTION = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_CONCURRENT_OPS_PER_CONNECTION);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "max-request-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-request-size"));
        provider = new DefinedDefaultBehaviorProvider("5 megabytes");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setUpperLimit("2147483647b");
        PD_MAX_REQUEST_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_REQUEST_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-request-handlers");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "num-request-handlers"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "num-request-handlers"));
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_NUM_REQUEST_HANDLERS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_REQUEST_HANDLERS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cert-nickname");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ssl-cert-nickname"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cert-nickname"));
        PD_SSL_CERT_NICKNAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CERT_NICKNAME);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cipher-suite");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-cipher-suite"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cipher-suite"));
        PD_SSL_CIPHER_SUITE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CIPHER_SUITE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "ssl-client-auth-policy");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ssl-client-auth-policy"));
        provider = new DefinedDefaultBehaviorProvider("optional");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(SSLClientAuthPolicy.class);
        PD_SSL_CLIENT_AUTH_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CLIENT_AUTH_POLICY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-protocol");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-protocol"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-protocol"));
        PD_SSL_PROTOCOL = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_PROTOCOL);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "trust-manager-provider");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-manager-provider"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "trust-manager-provider"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("trust-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.and(Conditions.contains("enabled", "true"), Conditions.contains("use-ssl", "true")));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_TRUST_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_TRUST_MANAGER_PROVIDER.getSourceConstraint());
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-ssl");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "use-ssl"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_SSL = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_SSL);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-tcp-keep-alive");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "use-tcp-keep-alive"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_TCP_KEEP_ALIVE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_TCP_KEEP_ALIVE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-tcp-no-delay");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "use-tcp-no-delay"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_TCP_NO_DELAY = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_TCP_NO_DELAY);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.implies(Conditions.contains("enabled", "true"), Conditions.implies(Conditions.contains("use-ssl", "true"), Conditions.isPresent("key-manager-provider")))));
    }

    private static class HTTPConnectionHandlerCfgServerImpl
    implements HTTPConnectionHandlerCfg {
        private ServerManagedObject<? extends HTTPConnectionHandlerCfg> impl;
        private final int pAcceptBacklog;
        private final SortedSet<AddressMask> pAllowedClient;
        private final boolean pAllowTCPReuseAddress;
        private final long pBufferSize;
        private final SortedSet<AddressMask> pDeniedClient;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final boolean pKeepStats;
        private final String pKeyManagerProvider;
        private final SortedSet<InetAddress> pListenAddress;
        private final int pListenPort;
        private final long pMaxBlockedWriteTimeLimit;
        private final Integer pMaxConcurrentOpsPerConnection;
        private final long pMaxRequestSize;
        private final Integer pNumRequestHandlers;
        private final SortedSet<String> pSSLCertNickname;
        private final SortedSet<String> pSSLCipherSuite;
        private final SSLClientAuthPolicy pSSLClientAuthPolicy;
        private final SortedSet<String> pSSLProtocol;
        private final String pTrustManagerProvider;
        private final boolean pUseSSL;
        private final boolean pUseTCPKeepAlive;
        private final boolean pUseTCPNoDelay;

        private HTTPConnectionHandlerCfgServerImpl(ServerManagedObject<? extends HTTPConnectionHandlerCfg> impl) {
            this.impl = impl;
            this.pAcceptBacklog = impl.getPropertyValue(INSTANCE.getAcceptBacklogPropertyDefinition());
            this.pAllowedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedClientPropertyDefinition());
            this.pAllowTCPReuseAddress = impl.getPropertyValue(INSTANCE.getAllowTCPReuseAddressPropertyDefinition());
            this.pBufferSize = impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
            this.pDeniedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDeniedClientPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeepStats = impl.getPropertyValue(INSTANCE.getKeepStatsPropertyDefinition());
            this.pKeyManagerProvider = impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
            this.pListenAddress = impl.getPropertyValues((PropertyDefinition)INSTANCE.getListenAddressPropertyDefinition());
            this.pListenPort = impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
            this.pMaxBlockedWriteTimeLimit = impl.getPropertyValue(INSTANCE.getMaxBlockedWriteTimeLimitPropertyDefinition());
            this.pMaxConcurrentOpsPerConnection = impl.getPropertyValue(INSTANCE.getMaxConcurrentOpsPerConnectionPropertyDefinition());
            this.pMaxRequestSize = impl.getPropertyValue(INSTANCE.getMaxRequestSizePropertyDefinition());
            this.pNumRequestHandlers = impl.getPropertyValue(INSTANCE.getNumRequestHandlersPropertyDefinition());
            this.pSSLCertNickname = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCertNicknamePropertyDefinition());
            this.pSSLCipherSuite = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCipherSuitePropertyDefinition());
            this.pSSLClientAuthPolicy = impl.getPropertyValue(INSTANCE.getSSLClientAuthPolicyPropertyDefinition());
            this.pSSLProtocol = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLProtocolPropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
            this.pUseSSL = impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
            this.pUseTCPKeepAlive = impl.getPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition());
            this.pUseTCPNoDelay = impl.getPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition());
        }

        @Override
        public void addHTTPChangeListener(ConfigurationChangeListener<HTTPConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeHTTPChangeListener(ConfigurationChangeListener<HTTPConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public int getAcceptBacklog() {
            return this.pAcceptBacklog;
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.pAllowedClient;
        }

        @Override
        public boolean isAllowTCPReuseAddress() {
            return this.pAllowTCPReuseAddress;
        }

        @Override
        public long getBufferSize() {
            return this.pBufferSize;
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.pDeniedClient;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public boolean isKeepStats() {
            return this.pKeepStats;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.pKeyManagerProvider;
        }

        @Override
        public DN getKeyManagerProviderDN() {
            String value = this.getKeyManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getKeyManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.pListenAddress;
        }

        @Override
        public int getListenPort() {
            return this.pListenPort;
        }

        @Override
        public long getMaxBlockedWriteTimeLimit() {
            return this.pMaxBlockedWriteTimeLimit;
        }

        @Override
        public Integer getMaxConcurrentOpsPerConnection() {
            return this.pMaxConcurrentOpsPerConnection;
        }

        @Override
        public long getMaxRequestSize() {
            return this.pMaxRequestSize;
        }

        @Override
        public Integer getNumRequestHandlers() {
            return this.pNumRequestHandlers;
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.pSSLCertNickname;
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.pSSLCipherSuite;
        }

        @Override
        public SSLClientAuthPolicy getSSLClientAuthPolicy() {
            return this.pSSLClientAuthPolicy;
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.pSSLProtocol;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public boolean isUseSSL() {
            return this.pUseSSL;
        }

        @Override
        public boolean isUseTCPKeepAlive() {
            return this.pUseTCPKeepAlive;
        }

        @Override
        public boolean isUseTCPNoDelay() {
            return this.pUseTCPNoDelay;
        }

        @Override
        public Class<? extends HTTPConnectionHandlerCfg> configurationClass() {
            return HTTPConnectionHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class HTTPConnectionHandlerCfgClientImpl
    implements HTTPConnectionHandlerCfgClient {
        private ManagedObject<? extends HTTPConnectionHandlerCfgClient> impl;

        private HTTPConnectionHandlerCfgClientImpl(ManagedObject<? extends HTTPConnectionHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public int getAcceptBacklog() {
            return this.impl.getPropertyValue(INSTANCE.getAcceptBacklogPropertyDefinition());
        }

        @Override
        public void setAcceptBacklog(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getAcceptBacklogPropertyDefinition(), value);
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedClientPropertyDefinition());
        }

        @Override
        public void setAllowedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedClientPropertyDefinition(), values);
        }

        @Override
        public boolean isAllowTCPReuseAddress() {
            return this.impl.getPropertyValue(INSTANCE.getAllowTCPReuseAddressPropertyDefinition());
        }

        @Override
        public void setAllowTCPReuseAddress(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowTCPReuseAddressPropertyDefinition(), value);
        }

        @Override
        public long getBufferSize() {
            return this.impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
        }

        @Override
        public void setBufferSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getBufferSizePropertyDefinition(), value);
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.impl.getPropertyValues(INSTANCE.getDeniedClientPropertyDefinition());
        }

        @Override
        public void setDeniedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getDeniedClientPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public boolean isKeepStats() {
            return this.impl.getPropertyValue(INSTANCE.getKeepStatsPropertyDefinition());
        }

        @Override
        public void setKeepStats(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getKeepStatsPropertyDefinition(), value);
        }

        @Override
        public String getKeyManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
        }

        @Override
        public void setKeyManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition(), value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.impl.getPropertyValues(INSTANCE.getListenAddressPropertyDefinition());
        }

        @Override
        public void setListenAddress(Collection<InetAddress> values) {
            this.impl.setPropertyValues(INSTANCE.getListenAddressPropertyDefinition(), values);
        }

        @Override
        public Integer getListenPort() {
            return this.impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
        }

        @Override
        public void setListenPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getListenPortPropertyDefinition(), value);
        }

        @Override
        public long getMaxBlockedWriteTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getMaxBlockedWriteTimeLimitPropertyDefinition());
        }

        @Override
        public void setMaxBlockedWriteTimeLimit(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMaxBlockedWriteTimeLimitPropertyDefinition(), value);
        }

        @Override
        public Integer getMaxConcurrentOpsPerConnection() {
            return this.impl.getPropertyValue(INSTANCE.getMaxConcurrentOpsPerConnectionPropertyDefinition());
        }

        @Override
        public void setMaxConcurrentOpsPerConnection(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxConcurrentOpsPerConnectionPropertyDefinition(), value);
        }

        @Override
        public long getMaxRequestSize() {
            return this.impl.getPropertyValue(INSTANCE.getMaxRequestSizePropertyDefinition());
        }

        @Override
        public void setMaxRequestSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMaxRequestSizePropertyDefinition(), value);
        }

        @Override
        public Integer getNumRequestHandlers() {
            return this.impl.getPropertyValue(INSTANCE.getNumRequestHandlersPropertyDefinition());
        }

        @Override
        public void setNumRequestHandlers(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getNumRequestHandlersPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition());
        }

        @Override
        public void setSSLCipherSuite(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition(), values);
        }

        @Override
        public SSLClientAuthPolicy getSSLClientAuthPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getSSLClientAuthPolicyPropertyDefinition());
        }

        @Override
        public void setSSLClientAuthPolicy(SSLClientAuthPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getSSLClientAuthPolicyPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.impl.getPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition());
        }

        @Override
        public void setSSLProtocol(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition(), values);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public boolean isUseSSL() {
            return this.impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
        }

        @Override
        public void setUseSSL(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseSSLPropertyDefinition(), value);
        }

        @Override
        public boolean isUseTCPKeepAlive() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition());
        }

        @Override
        public void setUseTCPKeepAlive(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition(), value);
        }

        @Override
        public boolean isUseTCPNoDelay() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition());
        }

        @Override
        public void setUseTCPNoDelay(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends HTTPConnectionHandlerCfgClient, ? extends HTTPConnectionHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum SSLClientAuthPolicy {
        DISABLED("disabled"),
        OPTIONAL("optional"),
        REQUIRED("required");

        private final String name;

        private SSLClientAuthPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

