/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.DebugTargetCfgClient;
import org.forgerock.opendj.server.config.client.FileBasedDebugLogPublisherCfgClient;
import org.forgerock.opendj.server.config.client.LogRetentionPolicyCfgClient;
import org.forgerock.opendj.server.config.client.LogRotationPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.DebugLogPublisherCfgDefn;
import org.forgerock.opendj.server.config.server.DebugLogPublisherCfg;
import org.forgerock.opendj.server.config.server.DebugTargetCfg;
import org.forgerock.opendj.server.config.server.FileBasedDebugLogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogRetentionPolicyCfg;
import org.forgerock.opendj.server.config.server.LogRotationPolicyCfg;

public final class FileBasedDebugLogPublisherCfgDefn
extends ManagedObjectDefinition<FileBasedDebugLogPublisherCfgClient, FileBasedDebugLogPublisherCfg> {
    private static final FileBasedDebugLogPublisherCfgDefn INSTANCE = new FileBasedDebugLogPublisherCfgDefn();
    private static final BooleanPropertyDefinition PD_APPEND;
    private static final BooleanPropertyDefinition PD_ASYNCHRONOUS;
    private static final BooleanPropertyDefinition PD_AUTO_FLUSH;
    private static final SizePropertyDefinition PD_BUFFER_SIZE;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LOG_FILE;
    private static final StringPropertyDefinition PD_LOG_FILE_PERMISSIONS;
    private static final IntegerPropertyDefinition PD_QUEUE_SIZE;
    private static final AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> PD_RETENTION_POLICY;
    private static final AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> PD_ROTATION_POLICY;
    private static final DurationPropertyDefinition PD_TIME_INTERVAL;

    public static FileBasedDebugLogPublisherCfgDefn getInstance() {
        return INSTANCE;
    }

    private FileBasedDebugLogPublisherCfgDefn() {
        super("file-based-debug-log-publisher", DebugLogPublisherCfgDefn.getInstance());
    }

    @Override
    public FileBasedDebugLogPublisherCfgClient createClientConfiguration(ManagedObject<? extends FileBasedDebugLogPublisherCfgClient> impl) {
        return new FileBasedDebugLogPublisherCfgClientImpl(impl);
    }

    @Override
    public FileBasedDebugLogPublisherCfg createServerConfiguration(ServerManagedObject<? extends FileBasedDebugLogPublisherCfg> impl) {
        return new FileBasedDebugLogPublisherCfgServerImpl(impl);
    }

    @Override
    public Class<FileBasedDebugLogPublisherCfg> getServerConfigurationClass() {
        return FileBasedDebugLogPublisherCfg.class;
    }

    public BooleanPropertyDefinition getAppendPropertyDefinition() {
        return PD_APPEND;
    }

    public BooleanPropertyDefinition getAsynchronousPropertyDefinition() {
        return PD_ASYNCHRONOUS;
    }

    public BooleanPropertyDefinition getAutoFlushPropertyDefinition() {
        return PD_AUTO_FLUSH;
    }

    public SizePropertyDefinition getBufferSizePropertyDefinition() {
        return PD_BUFFER_SIZE;
    }

    public BooleanPropertyDefinition getDefaultDebugExceptionsOnlyPropertyDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getDefaultDebugExceptionsOnlyPropertyDefinition();
    }

    public BooleanPropertyDefinition getDefaultIncludeThrowableCausePropertyDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getDefaultIncludeThrowableCausePropertyDefinition();
    }

    public BooleanPropertyDefinition getDefaultOmitMethodEntryArgumentsPropertyDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getDefaultOmitMethodEntryArgumentsPropertyDefinition();
    }

    public BooleanPropertyDefinition getDefaultOmitMethodReturnValuePropertyDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getDefaultOmitMethodReturnValuePropertyDefinition();
    }

    public IntegerPropertyDefinition getDefaultThrowableStackFramesPropertyDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getDefaultThrowableStackFramesPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLogFilePropertyDefinition() {
        return PD_LOG_FILE;
    }

    public StringPropertyDefinition getLogFilePermissionsPropertyDefinition() {
        return PD_LOG_FILE_PERMISSIONS;
    }

    public IntegerPropertyDefinition getQueueSizePropertyDefinition() {
        return PD_QUEUE_SIZE;
    }

    public AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> getRetentionPolicyPropertyDefinition() {
        return PD_RETENTION_POLICY;
    }

    public AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> getRotationPolicyPropertyDefinition() {
        return PD_ROTATION_POLICY;
    }

    public DurationPropertyDefinition getTimeIntervalPropertyDefinition() {
        return PD_TIME_INTERVAL;
    }

    public InstantiableRelationDefinition<DebugTargetCfgClient, DebugTargetCfg> getDebugTargetsRelationDefinition() {
        return DebugLogPublisherCfgDefn.getInstance().getDebugTargetsRelationDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "append");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "append"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_APPEND = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_APPEND);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "asynchronous");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "asynchronous"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ASYNCHRONOUS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ASYNCHRONOUS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "auto-flush");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "auto-flush"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_AUTO_FLUSH = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_AUTO_FLUSH);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "buffer-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "buffer-size"));
        provider = new DefinedDefaultBehaviorProvider("64kb");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_BUFFER_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BUFFER_SIZE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.TextDebugLogPublisher");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.LogPublisher");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-file");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "log-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_LOG_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-file-permissions");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-file-permissions"));
        provider = new DefinedDefaultBehaviorProvider("640");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-7][0-7][0-7])$", "MODE");
        PD_LOG_FILE_PERMISSIONS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FILE_PERMISSIONS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "queue-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "queue-size"));
        provider = new DefinedDefaultBehaviorProvider("5000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_QUEUE_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_QUEUE_SIZE);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "retention-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "retention-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "retention-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-retention-policy");
        PD_RETENTION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RETENTION_POLICY);
        INSTANCE.registerConstraint(PD_RETENTION_POLICY.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "rotation-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "rotation-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "rotation-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-rotation-policy");
        PD_ROTATION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ROTATION_POLICY);
        INSTANCE.registerConstraint(PD_ROTATION_POLICY.getSourceConstraint());
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "time-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "time-interval"));
        provider = new DefinedDefaultBehaviorProvider("5s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_TIME_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TIME_INTERVAL);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class FileBasedDebugLogPublisherCfgServerImpl
    implements FileBasedDebugLogPublisherCfg {
        private ServerManagedObject<? extends FileBasedDebugLogPublisherCfg> impl;
        private final boolean pAppend;
        private final boolean pAsynchronous;
        private final boolean pAutoFlush;
        private final long pBufferSize;
        private final boolean pDefaultDebugExceptionsOnly;
        private final boolean pDefaultIncludeThrowableCause;
        private final boolean pDefaultOmitMethodEntryArguments;
        private final boolean pDefaultOmitMethodReturnValue;
        private final int pDefaultThrowableStackFrames;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pLogFile;
        private final String pLogFilePermissions;
        private final int pQueueSize;
        private final SortedSet<String> pRetentionPolicy;
        private final SortedSet<String> pRotationPolicy;
        private final long pTimeInterval;

        private FileBasedDebugLogPublisherCfgServerImpl(ServerManagedObject<? extends FileBasedDebugLogPublisherCfg> impl) {
            this.impl = impl;
            this.pAppend = impl.getPropertyValue(INSTANCE.getAppendPropertyDefinition());
            this.pAsynchronous = impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
            this.pAutoFlush = impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
            this.pBufferSize = impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
            this.pDefaultDebugExceptionsOnly = impl.getPropertyValue(INSTANCE.getDefaultDebugExceptionsOnlyPropertyDefinition());
            this.pDefaultIncludeThrowableCause = impl.getPropertyValue(INSTANCE.getDefaultIncludeThrowableCausePropertyDefinition());
            this.pDefaultOmitMethodEntryArguments = impl.getPropertyValue(INSTANCE.getDefaultOmitMethodEntryArgumentsPropertyDefinition());
            this.pDefaultOmitMethodReturnValue = impl.getPropertyValue(INSTANCE.getDefaultOmitMethodReturnValuePropertyDefinition());
            this.pDefaultThrowableStackFrames = impl.getPropertyValue(INSTANCE.getDefaultThrowableStackFramesPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLogFile = impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
            this.pLogFilePermissions = impl.getPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition());
            this.pQueueSize = impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
            this.pRetentionPolicy = impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
            this.pRotationPolicy = impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
            this.pTimeInterval = impl.getPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition());
        }

        @Override
        public void addFileBasedDebugChangeListener(ConfigurationChangeListener<FileBasedDebugLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeFileBasedDebugChangeListener(ConfigurationChangeListener<FileBasedDebugLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addDebugChangeListener(ConfigurationChangeListener<DebugLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeDebugChangeListener(ConfigurationChangeListener<DebugLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAppend() {
            return this.pAppend;
        }

        @Override
        public boolean isAsynchronous() {
            return this.pAsynchronous;
        }

        @Override
        public boolean isAutoFlush() {
            return this.pAutoFlush;
        }

        @Override
        public long getBufferSize() {
            return this.pBufferSize;
        }

        @Override
        public boolean isDefaultDebugExceptionsOnly() {
            return this.pDefaultDebugExceptionsOnly;
        }

        @Override
        public boolean isDefaultIncludeThrowableCause() {
            return this.pDefaultIncludeThrowableCause;
        }

        @Override
        public boolean isDefaultOmitMethodEntryArguments() {
            return this.pDefaultOmitMethodEntryArguments;
        }

        @Override
        public boolean isDefaultOmitMethodReturnValue() {
            return this.pDefaultOmitMethodReturnValue;
        }

        @Override
        public int getDefaultThrowableStackFrames() {
            return this.pDefaultThrowableStackFrames;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLogFile() {
            return this.pLogFile;
        }

        @Override
        public String getLogFilePermissions() {
            return this.pLogFilePermissions;
        }

        @Override
        public int getQueueSize() {
            return this.pQueueSize;
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.pRetentionPolicy;
        }

        @Override
        public SortedSet<DN> getRetentionPolicyDNs() {
            SortedSet<String> values = this.getRetentionPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRetentionPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.pRotationPolicy;
        }

        @Override
        public SortedSet<DN> getRotationPolicyDNs() {
            SortedSet<String> values = this.getRotationPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRotationPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public long getTimeInterval() {
            return this.pTimeInterval;
        }

        @Override
        public String[] listDebugTargets() {
            return this.impl.listChildren(INSTANCE.getDebugTargetsRelationDefinition());
        }

        @Override
        public DebugTargetCfg getDebugTarget(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getDebugTargetsRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addDebugTargetAddListener(ConfigurationAddListener<DebugTargetCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getDebugTargetsRelationDefinition(), listener);
        }

        @Override
        public void removeDebugTargetAddListener(ConfigurationAddListener<DebugTargetCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getDebugTargetsRelationDefinition(), listener);
        }

        @Override
        public void addDebugTargetDeleteListener(ConfigurationDeleteListener<DebugTargetCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getDebugTargetsRelationDefinition(), listener);
        }

        @Override
        public void removeDebugTargetDeleteListener(ConfigurationDeleteListener<DebugTargetCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getDebugTargetsRelationDefinition(), listener);
        }

        @Override
        public Class<? extends FileBasedDebugLogPublisherCfg> configurationClass() {
            return FileBasedDebugLogPublisherCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class FileBasedDebugLogPublisherCfgClientImpl
    implements FileBasedDebugLogPublisherCfgClient {
        private ManagedObject<? extends FileBasedDebugLogPublisherCfgClient> impl;

        private FileBasedDebugLogPublisherCfgClientImpl(ManagedObject<? extends FileBasedDebugLogPublisherCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAppend() {
            return this.impl.getPropertyValue(INSTANCE.getAppendPropertyDefinition());
        }

        @Override
        public void setAppend(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAppendPropertyDefinition(), value);
        }

        @Override
        public boolean isAsynchronous() {
            return this.impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
        }

        @Override
        public void setAsynchronous(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAsynchronousPropertyDefinition(), value);
        }

        @Override
        public boolean isAutoFlush() {
            return this.impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
        }

        @Override
        public void setAutoFlush(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAutoFlushPropertyDefinition(), value);
        }

        @Override
        public long getBufferSize() {
            return this.impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
        }

        @Override
        public void setBufferSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getBufferSizePropertyDefinition(), value);
        }

        @Override
        public boolean isDefaultDebugExceptionsOnly() {
            return this.impl.getPropertyValue(INSTANCE.getDefaultDebugExceptionsOnlyPropertyDefinition());
        }

        @Override
        public void setDefaultDebugExceptionsOnly(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDefaultDebugExceptionsOnlyPropertyDefinition(), value);
        }

        @Override
        public boolean isDefaultIncludeThrowableCause() {
            return this.impl.getPropertyValue(INSTANCE.getDefaultIncludeThrowableCausePropertyDefinition());
        }

        @Override
        public void setDefaultIncludeThrowableCause(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDefaultIncludeThrowableCausePropertyDefinition(), value);
        }

        @Override
        public boolean isDefaultOmitMethodEntryArguments() {
            return this.impl.getPropertyValue(INSTANCE.getDefaultOmitMethodEntryArgumentsPropertyDefinition());
        }

        @Override
        public void setDefaultOmitMethodEntryArguments(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDefaultOmitMethodEntryArgumentsPropertyDefinition(), value);
        }

        @Override
        public boolean isDefaultOmitMethodReturnValue() {
            return this.impl.getPropertyValue(INSTANCE.getDefaultOmitMethodReturnValuePropertyDefinition());
        }

        @Override
        public void setDefaultOmitMethodReturnValue(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDefaultOmitMethodReturnValuePropertyDefinition(), value);
        }

        @Override
        public int getDefaultThrowableStackFrames() {
            return this.impl.getPropertyValue(INSTANCE.getDefaultThrowableStackFramesPropertyDefinition());
        }

        @Override
        public void setDefaultThrowableStackFrames(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDefaultThrowableStackFramesPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLogFile() {
            return this.impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
        }

        @Override
        public void setLogFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogFilePropertyDefinition(), value);
        }

        @Override
        public String getLogFilePermissions() {
            return this.impl.getPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition());
        }

        @Override
        public void setLogFilePermissions(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition(), value);
        }

        @Override
        public int getQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
        }

        @Override
        public void setQueueSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getQueueSizePropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
        }

        @Override
        public void setRetentionPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
        }

        @Override
        public void setRotationPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition(), values);
        }

        @Override
        public long getTimeInterval() {
            return this.impl.getPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition());
        }

        @Override
        public void setTimeInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition(), value);
        }

        @Override
        public String[] listDebugTargets() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getDebugTargetsRelationDefinition());
        }

        @Override
        public DebugTargetCfgClient getDebugTarget(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getDebugTargetsRelationDefinition(), name).getConfiguration();
        }

        public <M extends DebugTargetCfgClient> M createDebugTarget(ManagedObjectDefinition<M, ? extends DebugTargetCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((DebugTargetCfgClient)this.impl.createChild(INSTANCE.getDebugTargetsRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeDebugTarget(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getDebugTargetsRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends FileBasedDebugLogPublisherCfgClient, ? extends FileBasedDebugLogPublisherCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

