/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.BcryptPasswordStorageSchemeCfgClient;
import org.forgerock.opendj.server.config.meta.PasswordStorageSchemeCfgDefn;
import org.forgerock.opendj.server.config.server.BcryptPasswordStorageSchemeCfg;
import org.forgerock.opendj.server.config.server.PasswordStorageSchemeCfg;

public final class BcryptPasswordStorageSchemeCfgDefn
extends ManagedObjectDefinition<BcryptPasswordStorageSchemeCfgClient, BcryptPasswordStorageSchemeCfg> {
    private static final BcryptPasswordStorageSchemeCfgDefn INSTANCE = new BcryptPasswordStorageSchemeCfgDefn();
    private static final IntegerPropertyDefinition PD_BCRYPT_COST;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static BcryptPasswordStorageSchemeCfgDefn getInstance() {
        return INSTANCE;
    }

    private BcryptPasswordStorageSchemeCfgDefn() {
        super("bcrypt-password-storage-scheme", PasswordStorageSchemeCfgDefn.getInstance());
    }

    @Override
    public BcryptPasswordStorageSchemeCfgClient createClientConfiguration(ManagedObject<? extends BcryptPasswordStorageSchemeCfgClient> impl) {
        return new BcryptPasswordStorageSchemeCfgClientImpl(impl);
    }

    @Override
    public BcryptPasswordStorageSchemeCfg createServerConfiguration(ServerManagedObject<? extends BcryptPasswordStorageSchemeCfg> impl) {
        return new BcryptPasswordStorageSchemeCfgServerImpl(impl);
    }

    @Override
    public Class<BcryptPasswordStorageSchemeCfg> getServerConfigurationClass() {
        return BcryptPasswordStorageSchemeCfg.class;
    }

    public IntegerPropertyDefinition getBcryptCostPropertyDefinition() {
        return PD_BCRYPT_COST;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PasswordStorageSchemeCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "bcrypt-cost");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "bcrypt-cost"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("12");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(30);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_BCRYPT_COST = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BCRYPT_COST);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.BcryptPasswordStorageScheme");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.PasswordStorageScheme");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
    }

    private static class BcryptPasswordStorageSchemeCfgServerImpl
    implements BcryptPasswordStorageSchemeCfg {
        private ServerManagedObject<? extends BcryptPasswordStorageSchemeCfg> impl;
        private final int pBcryptCost;
        private final boolean pEnabled;
        private final String pJavaClass;

        private BcryptPasswordStorageSchemeCfgServerImpl(ServerManagedObject<? extends BcryptPasswordStorageSchemeCfg> impl) {
            this.impl = impl;
            this.pBcryptCost = impl.getPropertyValue(INSTANCE.getBcryptCostPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addBcryptChangeListener(ConfigurationChangeListener<BcryptPasswordStorageSchemeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeBcryptChangeListener(ConfigurationChangeListener<BcryptPasswordStorageSchemeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PasswordStorageSchemeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PasswordStorageSchemeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public int getBcryptCost() {
            return this.pBcryptCost;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends BcryptPasswordStorageSchemeCfg> configurationClass() {
            return BcryptPasswordStorageSchemeCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class BcryptPasswordStorageSchemeCfgClientImpl
    implements BcryptPasswordStorageSchemeCfgClient {
        private ManagedObject<? extends BcryptPasswordStorageSchemeCfgClient> impl;

        private BcryptPasswordStorageSchemeCfgClientImpl(ManagedObject<? extends BcryptPasswordStorageSchemeCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public int getBcryptCost() {
            return this.impl.getPropertyValue(INSTANCE.getBcryptCostPropertyDefinition());
        }

        @Override
        public void setBcryptCost(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBcryptCostPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends BcryptPasswordStorageSchemeCfgClient, ? extends BcryptPasswordStorageSchemeCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

