/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.ContainsCondition;
import org.forgerock.opendj.config.dsconfig.ArgumentExceptionFactory;
import org.forgerock.opendj.config.dsconfig.CLIProfile;
import org.forgerock.opendj.config.dsconfig.DSConfig;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.config.dsconfig.PropertyEditorModification;
import org.forgerock.opendj.config.dsconfig.PropertyValueEditor;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.util.Pair;

final class SetPropSubCommandHandler
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_ADD = "add";
    private static final String OPTION_DSCFG_LONG_REMOVE = "remove";
    private static final String OPTION_DSCFG_LONG_RESET = "reset";
    private static final String OPTION_DSCFG_LONG_SET = "set";
    private static final Character OPTION_DSCFG_SHORT_ADD = null;
    private static final Character OPTION_DSCFG_SHORT_REMOVE = null;
    private static final Character OPTION_DSCFG_SHORT_RESET = null;
    private static final Character OPTION_DSCFG_SHORT_SET = null;
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final StringArgument propertyAddArgument;
    private final StringArgument propertyRemoveArgument;
    private final StringArgument propertyResetArgument;
    private final StringArgument propertySetArgument;
    private final SubCommand subCommand;

    public static SetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(parser, path.child(r, "DUMMY"), r);
    }

    public static SetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(parser, path.child(r), r);
    }

    public static SetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SetRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(parser, path.child(r), r);
    }

    public static SetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SingletonRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(parser, path.child(r), r);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MenuResult<Void> modifyManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException {
        ManagedObjectDefinition<?, Configuration> d = mo.getManagedObjectDefinition();
        LocalizableMessage ufn = d.getUserFriendlyName();
        PropertyValueEditor editor = new PropertyValueEditor(app, context);
        while (true) {
            if (app.isInteractive()) {
                void var8_14;
                MenuResult<Void> menuResult;
                TreeSet<PropertyDefinition<?>> properties = new TreeSet();
                for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                    if (SetPropSubCommandHandler.cannotDisplay(app, pd)) continue;
                    properties.add(pd);
                }
                MenuResult<Void> menuResult2 = editor.edit(mo, properties, false);
                if (menuResult2.isSuccess() && (menuResult = SetPropSubCommandHandler.checkReferences(app, context, mo, handler)).isAgain()) continue;
                if (var8_14.isQuit()) {
                    if (app.isMenuDrivenMode()) return MenuResult.quit();
                    app.println();
                    app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_MODIFY_FAIL.get((Object)ufn));
                    return MenuResult.quit();
                }
                if (var8_14.isCancel()) {
                    return MenuResult.cancel();
                }
            }
            try {
                if (!mo.isModified()) return MenuResult.success();
                mo.commit();
                if (app.isVerbose() || app.isInteractive()) {
                    app.println();
                    app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_MODIFY_SUCCESS.get((Object)ufn));
                }
                for (PropertyEditorModification propertyEditorModification : editor.getModifications()) {
                    try {
                        handler.getCommandBuilder().addArgument(SetPropSubCommandHandler.createArgument(propertyEditorModification));
                    }
                    catch (ArgumentException ae) {
                        throw new RuntimeException("Unexpected error generating the command builder: " + (Object)((Object)ae), ae);
                    }
                }
                handler.setCommandBuilderUseful(true);
                return MenuResult.success();
            }
            catch (MissingMandatoryPropertiesException e) {
                if (!app.isInteractive()) throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, e.getMessageObject(), (Throwable)e);
                app.errPrintln();
                ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                app.errPrintln();
                if (app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get((Object)ufn), true)) continue;
                return MenuResult.cancel();
            }
            catch (AuthorizationException e) {
                LocalizableMessage localizableMessage = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get((Object)ufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, localizableMessage);
            }
            catch (ConcurrentModificationException e) {
                LocalizableMessage localizableMessage = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_CME.get((Object)ufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, localizableMessage);
            }
            catch (OperationRejectedException e) {
                if (!app.isInteractive()) throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, e.getMessageObject(), (Throwable)e);
                app.errPrintln();
                ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                app.errPrintln();
                if (!app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get((Object)ufn), true)) return MenuResult.cancel();
                continue;
            }
            catch (LdapException e) {
                LocalizableMessage localizableMessage = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_CE.get((Object)ufn, (Object)e.getMessage());
                throw new ClientException(ReturnCode.OTHER, localizableMessage);
            }
            break;
        }
        catch (ManagedObjectAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean cannotDisplay(ConsoleApplication app, PropertyDefinition<?> pd) {
        return pd.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED);
    }

    /*
     * Unable to fully structure code
     */
    private static MenuResult<Void> checkReferences(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException {
        d = mo.getManagedObjectDefinition();
        ufn = d.getUserFriendlyName();
        try {
            for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                if (!(pd instanceof AggregationPropertyDefinition) || !(apd = (AggregationPropertyDefinition)pd).getTargetNeedsEnablingCondition().evaluate(context, mo)) continue;
                for (String name : mo.getPropertyValues(apd)) {
                    path = apd.getChildPath(name);
                    rufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    try {
                        ref = context.getManagedObject(path);
                    }
                    catch (DefinitionDecodingException e) {
                        msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get((Object)rufn, (Object)rufn, (Object)rufn);
                        throw new ClientException(ReturnCode.OTHER, msg);
                    }
                    catch (ManagedObjectDecodingException e) {
                        msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get((Object)rufn);
                        throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
                    }
                    catch (ManagedObjectNotFoundException e) {
                        msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get((Object)rufn);
                        throw new ClientException(ReturnCode.NO_SUCH_OBJECT, msg);
                    }
                    condition = apd.getTargetIsEnabledCondition();
                    while (!condition.evaluate(context, ref)) {
                        isBadReference = true;
                        if (condition instanceof ContainsCondition) {
                            cvc = (ContainsCondition)condition;
                            app.println();
                            if (app.confirmAction(DsconfigMessages.INFO_EDITOR_PROMPT_ENABLED_REFERENCED_COMPONENT.get((Object)rufn, (Object)name, (Object)ufn), true)) {
                                cvc.setPropertyValue(ref);
                                try {
                                    ref.commit();
                                    if (app instanceof DSConfig && app.isInteractive()) {
                                        dsConfig = (DSConfig)app;
                                        subCommandName = "set-" + path.getRelationDefinition().getName() + "-prop";
                                        builder = dsConfig.getCommandBuilder(subCommandName);
                                        if (path.getRelationDefinition() instanceof InstantiableRelationDefinition) {
                                            argName = CLIProfile.getInstance().getNamingArgument(path.getRelationDefinition());
                                            try {
                                                arg = ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)argName).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME.get((Object)d.getUserFriendlyName()))).valuePlaceholder(DsconfigMessages.INFO_NAME_PLACEHOLDER.get())).buildArgument();
                                                arg.addValue(name);
                                                builder.addArgument((Argument)arg);
                                            }
                                            catch (Throwable t) {
                                                throw new RuntimeException("Unexpected error: " + t, t);
                                            }
                                        }
                                        try {
                                            arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"set").shortIdentifier(SetPropSubCommandHandler.OPTION_DSCFG_SHORT_SET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildArgument();
                                            propertyDefinition = cvc.getPropertyDefinition();
                                            arg.addValue(propertyDefinition.getName() + ':' + SetPropSubCommandHandler.castAndGetArgumentValue(propertyDefinition, cvc.getValue()));
                                            builder.addArgument((Argument)arg);
                                        }
                                        catch (Throwable t) {
                                            throw new RuntimeException("Unexpected error: " + t, t);
                                        }
                                        dsConfig.printCommandBuilder(builder);
                                    }
                                    isBadReference = false;
                                }
                                catch (MissingMandatoryPropertiesException e) {
                                    app.errPrintln();
                                    ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                                    app.errPrintln();
                                    if (!app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT.get((Object)rufn), true)) ** GOTO lbl90
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl90
                                    isBadReference = false;
                                }
                                catch (ConcurrentModificationException e) {
                                    msg = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_CME.get((Object)ufn);
                                    throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
                                }
                                catch (OperationRejectedException e) {
                                    app.errPrintln();
                                    ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                                    app.errPrintln();
                                    if (!app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT.get((Object)rufn), true)) ** GOTO lbl90
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl90
                                    isBadReference = false;
                                }
                                catch (ManagedObjectAlreadyExistsException e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                        } else {
                            app.println();
                            if (app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_TO_ENABLE.get((Object)rufn, (Object)name, (Object)ufn), true)) {
                                result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                if (result.isQuit()) {
                                    return result;
                                }
                                if (result.isSuccess()) {
                                    isBadReference = false;
                                }
                            }
                        }
lbl90:
                        // 13 sources

                        if (!isBadReference) continue;
                        app.errPrintln();
                        app.errPrintln(DsconfigMessages.ERR_SET_REFERENCED_COMPONENT_DISABLED.get((Object)ufn, (Object)rufn));
                        app.errPrintln();
                        if (app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get((Object)ufn), true)) {
                            return MenuResult.again();
                        }
                        return MenuResult.cancel();
                    }
                }
            }
        }
        catch (AuthorizationException e) {
            msg = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get((Object)ufn);
            throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
        }
        catch (LdapException e) {
            msg = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_CE.get((Object)ufn, (Object)e.getMessage());
            throw new ClientException(ReturnCode.OTHER, msg);
        }
        return MenuResult.success();
    }

    private SetPropSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> r) throws ArgumentException {
        this.path = path;
        String name = "set-" + r.getName() + "-prop";
        LocalizableMessage description = DsconfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_SETPROP.get((Object)r.getChildDefinition().getUserFriendlyName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.namingArgs = this.createNamingArgs(this.subCommand, path, false);
        this.propertySetArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_SET).shortIdentifier(OPTION_DSCFG_SHORT_SET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand);
        this.propertyResetArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_RESET).shortIdentifier(OPTION_DSCFG_SHORT_RESET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_RESET_PROP.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_PROPERTY_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand);
        this.propertyAddArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_ADD).shortIdentifier(OPTION_DSCFG_SHORT_ADD)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_ADD_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand);
        this.propertyRemoveArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_REMOVE).shortIdentifier(OPTION_DSCFG_SHORT_REMOVE)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand);
        this.addTags(path.getManagedObjectDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.path.getRelationDefinition();
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, LDAPManagementContextFactory factory) throws ArgumentException, ClientException {
        PropertyDefinition<?> pd;
        String value;
        String propertyName;
        Pair<String, String> pair;
        MenuResult<ManagedObject<?>> result;
        List<String> names = this.getNamingArgValues(app, this.namingArgs);
        this.getCommandBuilder().clearArguments();
        this.setCommandBuilderUseful(false);
        this.updateCommandBuilderWithSubCommand();
        LocalizableMessage ufn = this.path.getRelationDefinition().getUserFriendlyName();
        ManagementContext context = factory.getManagementContext();
        try {
            result = this.getManagedObject(app, context, this.path, names);
        }
        catch (AuthorizationException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get((Object)ufn);
            throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
        }
        catch (DefinitionDecodingException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get((Object)ufn, (Object)ufn, (Object)ufn);
            throw new ClientException(ReturnCode.OTHER, msg);
        }
        catch (ManagedObjectDecodingException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get((Object)ufn);
            throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_CME.get((Object)ufn);
            throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            String objName = names.get(names.size() - 1);
            ArgumentException except = null;
            if (objName == null) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_FINDER_NO_CHILDREN_NULL.get();
                except = new ArgumentException(msg);
            } else {
                except = ArgumentExceptionFactory.unknownValueForChildComponent("\"" + objName + "\"");
            }
            if (app.isInteractive()) {
                app.errPrintln();
                app.errPrintln(except.getMessageObject());
                return MenuResult.cancel();
            }
            throw except;
        }
        catch (LdapException e) {
            throw new ClientException(ReturnCode.OTHER, LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
        }
        if (result.isQuit()) {
            if (!app.isMenuDrivenMode()) {
                app.println();
                app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_MODIFY_FAIL.get((Object)ufn));
            }
            return MenuResult.quit();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        ManagedObject child = (ManagedObject)result.getValue();
        ManagedObjectDefinition d = child.getManagedObjectDefinition();
        HashMap<String, ModificationType> lastModTypes = new HashMap<String, ModificationType>();
        HashMap<PropertyDefinition, Set> changes = new HashMap<PropertyDefinition, Set>();
        for (String string : this.propertyResetArgument.getValues()) {
            if (string.contains(":")) {
                throw ArgumentExceptionFactory.unableToResetPropertyWithValue(string, OPTION_DSCFG_LONG_RESET);
            }
            PropertyDefinition<?> pd2 = this.getPropertyDefinition(d, string);
            if (pd2.hasOption(PropertyOption.MANDATORY) && pd2.getDefaultBehaviorProvider() instanceof UndefinedDefaultBehaviorProvider) {
                throw ArgumentExceptionFactory.unableToResetMandatoryProperty(d, string, OPTION_DSCFG_LONG_SET);
            }
            lastModTypes.put(string, ModificationType.SET);
            this.modifyPropertyValues(child, pd2, changes, ModificationType.SET, null);
        }
        for (String string : this.propertySetArgument.getValues()) {
            pair = this.parseValue(string);
            propertyName = (String)pair.getFirst();
            value = (String)pair.getSecond();
            pd = this.getPropertyDefinition(d, propertyName);
            if (lastModTypes.containsKey(propertyName)) {
                this.modifyPropertyValues(child, pd, changes, ModificationType.ADD, value);
                continue;
            }
            lastModTypes.put(propertyName, ModificationType.SET);
            this.modifyPropertyValues(child, pd, changes, ModificationType.SET, value);
        }
        for (String string : this.propertyRemoveArgument.getValues()) {
            pair = this.parseValue(string);
            propertyName = (String)pair.getFirst();
            value = (String)pair.getSecond();
            pd = this.getPropertyDefinition(d, propertyName);
            if (lastModTypes.containsKey(propertyName) && lastModTypes.get(propertyName) == ModificationType.SET) {
                throw ArgumentExceptionFactory.incompatiblePropertyModification(string);
            }
            lastModTypes.put(propertyName, ModificationType.REMOVE);
            this.modifyPropertyValues(child, pd, changes, ModificationType.REMOVE, value);
        }
        for (String string : this.propertyAddArgument.getValues()) {
            pair = this.parseValue(string);
            propertyName = (String)pair.getFirst();
            value = (String)pair.getSecond();
            pd = this.getPropertyDefinition(d, propertyName);
            if (lastModTypes.containsKey(propertyName) && lastModTypes.get(propertyName) == ModificationType.SET) {
                throw ArgumentExceptionFactory.incompatiblePropertyModification(string);
            }
            lastModTypes.put(propertyName, ModificationType.ADD);
            this.modifyPropertyValues(child, pd, changes, ModificationType.ADD, value);
        }
        for (Map.Entry entry : changes.entrySet()) {
            try {
                child.setPropertyValues((PropertyDefinition)entry.getKey(), (Collection)entry.getValue());
            }
            catch (PropertyException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            this.setCommandBuilderUseful(true);
        }
        MenuResult<Void> result2 = SetPropSubCommandHandler.modifyManagedObject(app, context, child, this);
        if (result2.isCancel()) {
            return MenuResult.cancel();
        }
        if (result2.isQuit()) {
            return MenuResult.quit();
        }
        if (this.propertyResetArgument.hasValue()) {
            this.getCommandBuilder().addArgument((Argument)this.propertyResetArgument);
        }
        if (this.propertySetArgument.hasValue()) {
            this.getCommandBuilder().addArgument((Argument)this.propertySetArgument);
        }
        if (this.propertyAddArgument.hasValue()) {
            this.getCommandBuilder().addArgument((Argument)this.propertyAddArgument);
        }
        if (this.propertyRemoveArgument.hasValue()) {
            this.getCommandBuilder().addArgument((Argument)this.propertyRemoveArgument);
        }
        return MenuResult.success((Object)0);
    }

    private Pair<String, String> parseValue(String m) throws ArgumentException {
        int sep = m.indexOf(58);
        if (sep < 0) {
            throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
        }
        if (sep == 0) {
            throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
        }
        String propertyName = m.substring(0, sep);
        String value = m.substring(sep + 1, m.length());
        if (value.length() == 0) {
            throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
        }
        return Pair.of((Object)propertyName, (Object)value);
    }

    private PropertyDefinition<?> getPropertyDefinition(ManagedObjectDefinition<?, ?> def, String propertyName) throws ArgumentException {
        try {
            return def.getPropertyDefinition(propertyName);
        }
        catch (IllegalArgumentException e) {
            throw ArgumentExceptionFactory.unknownProperty(def, propertyName);
        }
    }

    private <T> void modifyPropertyValues(ManagedObject<?> mo, PropertyDefinition<T> pd, Map<PropertyDefinition, Set> changes, ModificationType modType, String s) throws ArgumentException {
        SortedSet<T> values = changes.get(pd);
        if (values == null) {
            values = mo.getPropertyValues(pd);
        }
        if (s == null || s.length() == 0) {
            values.clear();
        } else {
            T value;
            try {
                value = pd.decodeValue(s);
            }
            catch (PropertyException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, mo.getManagedObjectDefinition());
            }
            switch (modType) {
                case ADD: {
                    values.add(value);
                    break;
                }
                case REMOVE: {
                    if (values.remove(value)) break;
                    throw ArgumentExceptionFactory.unknownValueForMultiValuedProperty(s, pd.getName());
                }
                case SET: {
                    values = new TreeSet<T>(pd);
                    values.add(value);
                }
            }
        }
        changes.put(pd, values);
    }

    private static <T> Argument createArgument(PropertyEditorModification<T> mod) throws ArgumentException {
        StringArgument arg;
        PropertyDefinition<T> propertyDefinition = mod.getPropertyDefinition();
        String propName = propertyDefinition.getName();
        switch (mod.getType()) {
            case RESET: {
                arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_RESET).shortIdentifier(OPTION_DSCFG_SHORT_RESET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_RESET_PROP.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_PROPERTY_PLACEHOLDER.get())).buildArgument();
                arg.addValue(propName);
                break;
            }
            case REMOVE: {
                arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_REMOVE).shortIdentifier(OPTION_DSCFG_SHORT_REMOVE)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildArgument();
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + SetPropSubCommandHandler.getArgumentValue(propertyDefinition, value));
                }
                break;
            }
            case ADD: {
                arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_ADD).shortIdentifier(OPTION_DSCFG_SHORT_ADD)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_ADD_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildArgument();
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + SetPropSubCommandHandler.getArgumentValue(propertyDefinition, value));
                }
                break;
            }
            case SET: {
                arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_SET).shortIdentifier(OPTION_DSCFG_SHORT_SET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildArgument();
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + SetPropSubCommandHandler.getArgumentValue(propertyDefinition, value));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown modification type: " + (Object)((Object)mod.getType()));
            }
        }
        return arg;
    }

    private static enum ModificationType {
        ADD,
        REMOVE,
        SET;

    }
}

