/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.conditions;

import java.util.Arrays;
import java.util.List;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.conditions.Condition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.util.Reject;

final class ANDCondition
implements Condition {
    private final List<Condition> conditions;

    public ANDCondition(Condition ... conditions) {
        Reject.ifNull((Object[])conditions);
        this.conditions = Arrays.asList(conditions);
    }

    @Override
    public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws LdapException {
        for (Condition condition : this.conditions) {
            if (condition.evaluate(context, managedObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
        for (Condition condition : this.conditions) {
            if (condition.evaluate(managedObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        for (Condition condition : this.conditions) {
            condition.initialize(d);
        }
    }
}

