/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.client.spi.Property;

public final class PropertySet {
    private final Map<PropertyDefinition<?>, MyProperty<?>> properties = new HashMap();

    public <T> void addProperty(PropertyDefinition<T> pd, Collection<T> defaultValues, Collection<T> activeValues) {
        MyProperty<T> p = new MyProperty<T>(pd, defaultValues, activeValues);
        this.properties.put(pd, p);
    }

    public <T> Property<T> getProperty(PropertyDefinition<T> d) {
        if (!this.properties.containsKey(d)) {
            throw new IllegalArgumentException("Unknown property " + d.getName());
        }
        return this.properties.get(d);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (Map.Entry<PropertyDefinition<?>, MyProperty<?>> entry : this.properties.entrySet()) {
            builder.append(entry.getKey().getName());
            builder.append('=');
            builder.append(entry.getValue());
            builder.append(' ');
        }
        builder.append('}');
        return builder.toString();
    }

    void commit() {
        for (MyProperty<?> p : this.properties.values()) {
            p.commit();
        }
    }

    <T> void setPropertyValues(PropertyDefinition<T> d, Collection<T> values) {
        MyProperty property = (MyProperty)this.getProperty(d);
        if (values.size() > 1 && !d.hasOption(PropertyOption.MULTI_VALUED)) {
            throw PropertyException.propertyIsSingleValuedException(d);
        }
        if (values.isEmpty() && d.hasOption(PropertyOption.MANDATORY) && property.getDefaultValues().isEmpty()) {
            throw PropertyException.propertyIsMandatoryException(d);
        }
        for (T e : values) {
            if (e == null) {
                throw new NullPointerException();
            }
            d.validateValue(e);
        }
        property.setPendingValues(values);
    }

    private static final class MyProperty<T>
    implements Property<T> {
        private final SortedSet<T> activeValues;
        private final PropertyDefinition<T> d;
        private final SortedSet<T> defaultValues;
        private final SortedSet<T> pendingValues;

        public MyProperty(PropertyDefinition<T> pd, Collection<T> defaultValues, Collection<T> activeValues) {
            this.d = pd;
            TreeSet<T> sortedDefaultValues = new TreeSet<T>(pd);
            sortedDefaultValues.addAll(defaultValues);
            this.defaultValues = Collections.unmodifiableSortedSet(sortedDefaultValues);
            this.activeValues = new TreeSet<T>(pd);
            this.activeValues.addAll(activeValues);
            this.pendingValues = new TreeSet<T>(this.activeValues);
        }

        public void commit() {
            this.activeValues.clear();
            this.activeValues.addAll(this.pendingValues);
        }

        @Override
        public SortedSet<T> getActiveValues() {
            return Collections.unmodifiableSortedSet(this.activeValues);
        }

        @Override
        public SortedSet<T> getDefaultValues() {
            return this.defaultValues;
        }

        @Override
        public SortedSet<T> getEffectiveValues() {
            SortedSet<T> values = this.getPendingValues();
            if (values.isEmpty()) {
                values = this.getDefaultValues();
            }
            return values;
        }

        @Override
        public SortedSet<T> getPendingValues() {
            return Collections.unmodifiableSortedSet(this.pendingValues);
        }

        @Override
        public PropertyDefinition<T> getPropertyDefinition() {
            return this.d;
        }

        @Override
        public boolean isEmpty() {
            return this.pendingValues.isEmpty();
        }

        @Override
        public boolean isModified() {
            return this.activeValues.size() != this.pendingValues.size() || !this.activeValues.containsAll(this.pendingValues);
        }

        public void setPendingValues(Collection<T> c) {
            this.pendingValues.clear();
            this.pendingValues.addAll(c);
        }

        public String toString() {
            return this.getEffectiveValues().toString();
        }

        @Override
        public boolean wasEmpty() {
            return this.activeValues.isEmpty();
        }
    }
}

