/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.ConfigurationFramework;

public final class ManagedObjectDefinitionResource {
    private final Map<AbstractManagedObjectDefinition<?, ?>, Properties> properties = new HashMap();
    private final String prefix;

    public static ManagedObjectDefinitionResource createForProfile(String profile) {
        return new ManagedObjectDefinitionResource("config.profiles." + profile);
    }

    private ManagedObjectDefinitionResource(String prefix) {
        this.prefix = prefix;
    }

    public String getString(AbstractManagedObjectDefinition<?, ?> d, String key) {
        if (d.isTop()) {
            throw new UnsupportedOperationException("Profile resources are not available for the Top configuration definition");
        }
        Properties p = this.getProperties(d);
        String result = p.getProperty(key);
        if (result == null) {
            String baseName = this.prefix + "." + d.getClass().getName();
            String path = baseName.replace('.', '/') + ".properties";
            throw new MissingResourceException("Can't find resource " + path + ", key " + key, baseName, key);
        }
        return result;
    }

    private synchronized Properties getProperties(AbstractManagedObjectDefinition<?, ?> d) {
        Properties p = this.properties.get(d);
        if (p == null) {
            String baseName = this.prefix + "." + d.getClass().getName();
            String path = baseName.replace('.', '/') + ".properties";
            InputStream stream = ConfigurationFramework.getInstance().getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                throw new MissingResourceException("Can't find resource " + path, baseName, "");
            }
            p = new Properties();
            try (BufferedInputStream is = new BufferedInputStream(stream);){
                p.load(is);
            }
            catch (IOException e) {
                throw new MissingResourceException("Can't load resource " + path + " due to IO exception: " + e.getMessage(), baseName, "");
            }
            this.properties.put(d, p);
        }
        return p;
    }
}

