/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class EnumPropertyDefinition<E extends Enum<E>>
extends PropertyDefinition<E> {
    private final Class<E> enumClass;
    private final Map<String, E> decodeMap;

    public static <E extends Enum<E>> Builder<E> createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private EnumPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<E> defaultBehavior, Class<E> enumClass) {
        super(d, enumClass, propertyName, options, adminAction, defaultBehavior);
        this.enumClass = enumClass;
        this.decodeMap = new HashMap<String, E>();
        for (Enum value : EnumSet.allOf(enumClass)) {
            String s = value.toString().trim().toLowerCase();
            this.decodeMap.put(s, value);
        }
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitEnum(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, E value, P p) {
        return v.visitEnum(this, value, p);
    }

    @Override
    public E decodeValue(String value) {
        Reject.ifNull((Object)value);
        String nvalue = value.trim().toLowerCase();
        Enum eValue = (Enum)this.decodeMap.get(nvalue);
        if (eValue != null) {
            return (E)eValue;
        }
        throw PropertyException.illegalPropertyValueException(this, value);
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    public final LocalizableMessage getValueSynopsis(E value) {
        return this.getValueSynopsis(Locale.getDefault(), value);
    }

    public final LocalizableMessage getValueSynopsis(Locale locale, E value) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.getName() + ".syntax.enumeration.value." + value + ".synopsis";
        try {
            return resource.getMessage(this.getManagedObjectDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    @Override
    public String normalizeValue(E value) {
        Reject.ifNull(value);
        return ((Enum)value).toString().trim().toLowerCase();
    }

    @Override
    public void validateValue(E value) {
        Reject.ifNull(value);
    }

    public static final class Builder<E extends Enum<E>>
    extends PropertyDefinition.AbstractBuilder<E, EnumPropertyDefinition<E>> {
        private Class<E> enumClass = null;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setEnumClass(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        protected EnumPropertyDefinition<E> buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<E> defaultBehavior) {
            if (this.enumClass == null) {
                throw new IllegalStateException("Enumeration class undefined");
            }
            return new EnumPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.enumClass);
        }
    }
}

