/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.LDAPProfile;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigExceptionFactory;
import org.forgerock.opendj.config.server.ConstraintViolationException;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.config.server.ServerManagedObjectDecodingException;
import org.forgerock.opendj.config.server.ServerManagementContext;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;

public final class AdminTestCaseUtils {
    private static final String DUMMY_TEST_RELATION = "*dummy*test*relation*";
    private static boolean isProfileRegistered;

    private AdminTestCaseUtils() {
    }

    public static <S extends Configuration> S getConfiguration(ServerManagementContext context, AbstractManagedObjectDefinition<?, S> definition, Entry entry) throws ConfigException {
        try {
            ServerManagedObject managedObject = context.decode(AdminTestCaseUtils.getPath(definition), entry);
            managedObject.ensureIsUsable();
            return (S)managedObject.getConfiguration();
        }
        catch (DefinitionDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(entry.getName(), e);
        }
        catch (ServerManagedObjectDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(e);
        }
        catch (ConstraintViolationException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(e);
        }
    }

    private static synchronized <C extends ConfigurationClient, S extends Configuration> ManagedObjectPath<C, S> getPath(AbstractManagedObjectDefinition<C, S> d) {
        if (!isProfileRegistered) {
            LDAPProfile.Wrapper profile = new LDAPProfile.Wrapper(){

                public String getRelationRDNSequence(RelationDefinition<?, ?> r) {
                    if (AdminTestCaseUtils.DUMMY_TEST_RELATION.equals(r.getName())) {
                        return "cn=dummy configuration,cn=config";
                    }
                    return null;
                }
            };
            LDAPProfile.getInstance().pushWrapper(profile);
            isProfileRegistered = true;
        }
        SingletonRelationDefinition.Builder builder = new SingletonRelationDefinition.Builder((AbstractManagedObjectDefinition)RootCfgDefn.getInstance(), DUMMY_TEST_RELATION, d);
        ManagedObjectPath root = ManagedObjectPath.emptyPath();
        return root.child((SingletonRelationDefinition)builder.getInstance());
    }
}

