/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.TreeSet;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class ConfigurationMock {
    private static final ConfigAnswer CONFIG_ANSWER = new ConfigAnswer();

    public static <T extends Configuration> T mockCfg(Class<T> configClass) {
        return (T)((Configuration)Mockito.mock(configClass, (Answer)CONFIG_ANSWER));
    }

    private static class MockProviderVisitor<T>
    implements DefaultBehaviorProviderVisitor<T, Collection<T>, Void> {
        private PropertyDefinition<T> propertyDef;

        MockProviderVisitor(PropertyDefinition<T> propertyDef) {
            this.propertyDef = propertyDef;
        }

        public Collection<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> provider, Void p) {
            return null;
        }

        public Collection<T> visitAlias(AliasDefaultBehaviorProvider<T> provider, Void p) {
            return null;
        }

        public Collection<T> visitDefined(DefinedDefaultBehaviorProvider<T> provider, Void p) {
            TreeSet<Object> values = new TreeSet<Object>();
            for (String stringValue : provider.getDefaultValues()) {
                values.add(this.propertyDef.decodeValue(stringValue));
            }
            return values;
        }

        public Collection<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
            return null;
        }

        public Collection<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
            return null;
        }
    }

    private static class ConfigAnswer
    extends ReturnsEmptyValues {
        private static final long serialVersionUID = 1L;

        private ConfigAnswer() {
        }

        public Object answer(InvocationOnMock invocation) {
            try {
                Class<?> propertyReturnType;
                String definitionClassName = this.toDefinitionClassName(invocation.getMethod().getDeclaringClass().getName());
                Class<?> definitionClass = Class.forName(definitionClassName);
                ManagedObjectDefinition definition = (ManagedObjectDefinition)definitionClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                String invokedMethodName = invocation.getMethod().getName();
                if (!this.isGetterMethod(invokedMethodName)) {
                    return this.answerFromDefaultMockitoBehavior(invocation);
                }
                Method getPropertyDefMethod = this.getPropertyDefinitionMethod(definitionClass, invokedMethodName);
                Object defaultValue = this.getDefaultValue(definition, getPropertyDefMethod, propertyReturnType = this.getPropertyReturnType(getPropertyDefMethod));
                if (defaultValue != null) {
                    return defaultValue;
                }
                return this.answerFromDefaultMockitoBehavior(invocation);
            }
            catch (Exception e) {
                return this.answerFromDefaultMockitoBehavior(invocation);
            }
        }

        private Object answerFromDefaultMockitoBehavior(InvocationOnMock invocation) {
            return super.answer(invocation);
        }

        private boolean isGetterMethod(String invokedMethodName) {
            return invokedMethodName.startsWith("get") || invokedMethodName.startsWith("is");
        }

        private Method getPropertyDefinitionMethod(Class<?> definitionClass, String invokedMethodName) throws SecurityException, NoSuchMethodException {
            return definitionClass.getMethod(invokedMethodName.replaceAll("^is", "get") + "PropertyDefinition", new Class[0]);
        }

        private Class<?> getPropertyReturnType(Method getPropertyDefMethod) {
            Class<?> returnClass = getPropertyDefMethod.getReturnType();
            return ((ParameterizedType)returnClass.getGenericSuperclass()).getActualTypeArguments()[0].getClass();
        }

        private String toDefinitionClassName(String configClassName) {
            int finalDot = configClassName.lastIndexOf(46);
            return configClassName.substring(0, finalDot - 6) + "meta." + configClassName.substring(finalDot + 1) + "Defn";
        }

        private <T> Object getDefaultValue(ManagedObjectDefinition<?, ?> definition, Method getPropertyDefMethod, Class<T> propertyReturnClass) throws Exception {
            MockProviderVisitor visitor;
            PropertyDefinition propertyDefinition = (PropertyDefinition)getPropertyDefMethod.invoke(definition, new Object[0]);
            DefaultBehaviorProvider defaultBehaviorProvider = (DefaultBehaviorProvider)propertyDefinition.getClass().getMethod("getDefaultBehaviorProvider", new Class[0]).invoke((Object)propertyDefinition, new Object[0]);
            Collection values = (Collection)defaultBehaviorProvider.accept(visitor = new MockProviderVisitor(propertyDefinition), null);
            if (values == null) {
                return null;
            }
            if (propertyDefinition.hasOption(PropertyOption.MULTI_VALUED)) {
                return values;
            }
            return values.iterator().next();
        }
    }
}

