/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.SambaPasswordPluginCfgClient;
import org.forgerock.opendj.server.config.meta.PluginCfgDefn;
import org.forgerock.opendj.server.config.server.PluginCfg;
import org.forgerock.opendj.server.config.server.SambaPasswordPluginCfg;

public final class SambaPasswordPluginCfgDefn
extends ManagedObjectDefinition<SambaPasswordPluginCfgClient, SambaPasswordPluginCfg> {
    private static final SambaPasswordPluginCfgDefn INSTANCE = new SambaPasswordPluginCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final EnumPropertyDefinition<PluginCfgDefn.PluginType> PD_PLUGIN_TYPE;
    private static final EnumPropertyDefinition<PwdSyncPolicy> PD_PWD_SYNC_POLICY;
    private static final DNPropertyDefinition PD_SAMBA_ADMINISTRATOR_DN;

    public static SambaPasswordPluginCfgDefn getInstance() {
        return INSTANCE;
    }

    private SambaPasswordPluginCfgDefn() {
        super("samba-password-plugin", PluginCfgDefn.getInstance());
    }

    @Override
    public SambaPasswordPluginCfgClient createClientConfiguration(ManagedObject<? extends SambaPasswordPluginCfgClient> impl) {
        return new SambaPasswordPluginCfgClientImpl(impl);
    }

    @Override
    public SambaPasswordPluginCfg createServerConfiguration(ServerManagedObject<? extends SambaPasswordPluginCfg> impl) {
        return new SambaPasswordPluginCfgServerImpl(impl);
    }

    @Override
    public Class<SambaPasswordPluginCfg> getServerConfigurationClass() {
        return SambaPasswordPluginCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PluginCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getInvokeForInternalOperationsPropertyDefinition() {
        return PluginCfgDefn.getInstance().getInvokeForInternalOperationsPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<PluginCfgDefn.PluginType> getPluginTypePropertyDefinition() {
        return PD_PLUGIN_TYPE;
    }

    public EnumPropertyDefinition<PwdSyncPolicy> getPwdSyncPolicyPropertyDefinition() {
        return PD_PWD_SYNC_POLICY;
    }

    public DNPropertyDefinition getSambaAdministratorDNPropertyDefinition() {
        return PD_SAMBA_ADMINISTRATOR_DN;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.plugins.SambaPasswordPlugin");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.plugin.DirectoryServerPlugin");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "plugin-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "plugin-type"));
        provider = new DefinedDefaultBehaviorProvider("preoperationmodify", "postoperationextended");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(PluginCfgDefn.PluginType.class);
        PD_PLUGIN_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PLUGIN_TYPE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "pwd-sync-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "pwd-sync-policy"));
        provider = new DefinedDefaultBehaviorProvider("sync-nt-password");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(PwdSyncPolicy.class);
        PD_PWD_SYNC_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PWD_SYNC_POLICY);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "samba-administrator-dn");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "samba-administrator-dn"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "samba-administrator-dn"));
        PD_SAMBA_ADMINISTRATOR_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SAMBA_ADMINISTRATOR_DN);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class SambaPasswordPluginCfgServerImpl
    implements SambaPasswordPluginCfg {
        private ServerManagedObject<? extends SambaPasswordPluginCfg> impl;
        private final boolean pEnabled;
        private final boolean pInvokeForInternalOperations;
        private final String pJavaClass;
        private final SortedSet<PluginCfgDefn.PluginType> pPluginType;
        private final SortedSet<PwdSyncPolicy> pPwdSyncPolicy;
        private final DN pSambaAdministratorDN;

        private SambaPasswordPluginCfgServerImpl(ServerManagedObject<? extends SambaPasswordPluginCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pInvokeForInternalOperations = impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pPluginType = impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
            this.pPwdSyncPolicy = impl.getPropertyValues(INSTANCE.getPwdSyncPolicyPropertyDefinition());
            this.pSambaAdministratorDN = impl.getPropertyValue(INSTANCE.getSambaAdministratorDNPropertyDefinition());
        }

        @Override
        public void addSambaPasswordChangeListener(ConfigurationChangeListener<SambaPasswordPluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeSambaPasswordChangeListener(ConfigurationChangeListener<SambaPasswordPluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.pInvokeForInternalOperations;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.pPluginType;
        }

        @Override
        public SortedSet<PwdSyncPolicy> getPwdSyncPolicy() {
            return this.pPwdSyncPolicy;
        }

        @Override
        public DN getSambaAdministratorDN() {
            return this.pSambaAdministratorDN;
        }

        @Override
        public Class<? extends SambaPasswordPluginCfg> configurationClass() {
            return SambaPasswordPluginCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class SambaPasswordPluginCfgClientImpl
    implements SambaPasswordPluginCfgClient {
        private ManagedObject<? extends SambaPasswordPluginCfgClient> impl;

        private SambaPasswordPluginCfgClientImpl(ManagedObject<? extends SambaPasswordPluginCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
        }

        @Override
        public void setInvokeForInternalOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
        }

        @Override
        public void setPluginType(Collection<PluginCfgDefn.PluginType> values) {
            this.impl.setPropertyValues(INSTANCE.getPluginTypePropertyDefinition(), values);
        }

        @Override
        public SortedSet<PwdSyncPolicy> getPwdSyncPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getPwdSyncPolicyPropertyDefinition());
        }

        @Override
        public void setPwdSyncPolicy(Collection<PwdSyncPolicy> values) {
            this.impl.setPropertyValues(INSTANCE.getPwdSyncPolicyPropertyDefinition(), values);
        }

        @Override
        public DN getSambaAdministratorDN() {
            return this.impl.getPropertyValue(INSTANCE.getSambaAdministratorDNPropertyDefinition());
        }

        @Override
        public void setSambaAdministratorDN(DN value) {
            this.impl.setPropertyValue(INSTANCE.getSambaAdministratorDNPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends SambaPasswordPluginCfgClient, ? extends SambaPasswordPluginCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum PwdSyncPolicy {
        SYNC_LM_PASSWORD("sync-lm-password"),
        SYNC_NT_PASSWORD("sync-nt-password");

        private final String name;

        private PwdSyncPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

