/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.LDAPProfile;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.ManagedObjectPathSerializer;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RDN;

final class DNBuilder
implements ManagedObjectPathSerializer {
    private final LinkedList<RDN> rdns = new LinkedList();
    private final LDAPProfile profile;

    static DN create(ManagedObjectPath<?, ?> path, LDAPProfile profile) {
        DNBuilder builder = new DNBuilder(profile);
        path.serialize(builder);
        return builder.build();
    }

    static DN create(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> relation, LDAPProfile profile) {
        DNBuilder builder = new DNBuilder(profile);
        path.serialize(builder);
        builder.appendManagedObjectPathElement(relation);
        return builder.build();
    }

    static DN create(ManagedObjectPath<?, ?> path, SetRelationDefinition<?, ?> relation, LDAPProfile profile) {
        DNBuilder builder = new DNBuilder(profile);
        path.serialize(builder);
        builder.appendManagedObjectPathElement(relation);
        return builder.build();
    }

    private DNBuilder(LDAPProfile profile) {
        this.profile = profile;
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
        this.appendManagedObjectPathElement(r);
        String type = this.profile.getRelationChildRDNType(r);
        RDN rdn = new RDN(type, (Object)name.trim());
        this.rdns.add(rdn);
    }

    private void appendManagedObjectPathElement(RelationDefinition<?, ?> r) {
        DN dn = DN.valueOf((String)this.profile.getRelationRDNSequence(r));
        List<RDN> rdnsOfDn = this.getRdnsInBigEndianOrder(dn);
        this.rdns.addAll(rdnsOfDn);
    }

    private List<RDN> getRdnsInBigEndianOrder(DN dn) {
        ArrayList<RDN> rdnsOfDn = new ArrayList<RDN>();
        for (RDN rdn : dn) {
            rdnsOfDn.add(rdn);
        }
        Collections.reverse(rdnsOfDn);
        return rdnsOfDn;
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SetRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
        String type = this.profile.getRelationChildRDNType(r);
        RDN rdn = new RDN(type, (Object)d.getName());
        this.rdns.add(rdn);
    }

    private DN build() {
        DN dn = DN.rootDN();
        for (RDN rdn : this.rdns) {
            dn = dn.child(rdn);
        }
        return dn;
    }
}

