/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client;

import java.util.SortedSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.client.spi.Driver;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.RootCfgClient;

public abstract class DriverBasedManagementContext
implements ManagementContext {
    protected DriverBasedManagementContext() {
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, String name) throws ManagedObjectNotFoundException, OperationRejectedException, LdapException {
        return this.getDriver().deleteManagedObject(parent, rd, name);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, OptionalRelationDefinition<C, S> rd) throws ManagedObjectNotFoundException, OperationRejectedException, LdapException {
        return this.getDriver().deleteManagedObject(parent, rd);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd, String name) throws ManagedObjectNotFoundException, OperationRejectedException, LdapException {
        return this.getDriver().deleteManagedObject(parent, rd, name);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getManagedObject(ManagedObjectPath<C, S> path) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, LdapException {
        if (path.isEmpty()) {
            return this.getRootConfigurationManagedObject();
        }
        return this.getDriver().getManagedObject(path);
    }

    @Override
    public final <P> P getPropertyValue(ManagedObjectPath<?, ?> path, PropertyDefinition<P> pd) throws DefinitionDecodingException, LdapException, ManagedObjectNotFoundException {
        SortedSet<P> values = this.getPropertyValues(path, pd);
        if (values.isEmpty()) {
            return null;
        }
        return (P)values.iterator().next();
    }

    @Override
    public final <P> SortedSet<P> getPropertyValues(ManagedObjectPath<?, ?> path, PropertyDefinition<P> pd) throws DefinitionDecodingException, LdapException, ManagedObjectNotFoundException {
        return this.getDriver().getPropertyValues(path, pd);
    }

    @Override
    public final RootCfgClient getRootConfiguration() {
        return this.getRootConfigurationManagedObject().getConfiguration();
    }

    @Override
    public final ManagedObject<RootCfgClient> getRootConfigurationManagedObject() {
        return this.getDriver().getRootConfigurationManagedObject();
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd) throws ManagedObjectNotFoundException, LdapException {
        return this.listManagedObjects(parent, rd, rd.getChildDefinition());
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws ManagedObjectNotFoundException, LdapException {
        return this.getDriver().listManagedObjects(parent, rd, d);
    }

    @Override
    public final <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd) throws ManagedObjectNotFoundException, LdapException {
        return this.getDriver().listManagedObjects(parent, rd, rd.getChildDefinition());
    }

    @Override
    public final boolean managedObjectExists(ManagedObjectPath<?, ?> path) throws ManagedObjectNotFoundException, LdapException {
        return this.getDriver().managedObjectExists(path);
    }

    protected abstract Driver getDriver();

    @Override
    public final void close() {
        this.getDriver().close();
    }
}

