/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionUsageBuilder;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;

public final class ArgumentExceptionFactory {
    public static ClientException adaptIllegalManagedObjectNameException(IllegalManagedObjectNameException e, AbstractManagedObjectDefinition<?, ?> d) {
        String illegalName = e.getIllegalName();
        PropertyDefinition<?> pd = e.getNamingPropertyDefinition();
        if (illegalName.length() == 0) {
            LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_EMPTY.get((Object)d.getUserFriendlyPluralName());
            return new ClientException(ReturnCode.ERROR_USER_DATA, message);
        }
        if (illegalName.trim().length() == 0) {
            LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_BLANK.get((Object)d.getUserFriendlyPluralName());
            return new ClientException(ReturnCode.ERROR_USER_DATA, message);
        }
        if (pd != null) {
            try {
                pd.decodeValue(illegalName);
            }
            catch (PropertyException e1) {
                PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
                LocalizableMessage syntax = b.getUsage(pd);
                LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_SYNTAX.get((Object)illegalName, (Object)d.getUserFriendlyName(), (Object)syntax);
                return new ClientException(ReturnCode.ERROR_USER_DATA, message);
            }
        }
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_UNKNOWN.get((Object)illegalName, (Object)d.getUserFriendlyName());
        return new ClientException(ReturnCode.ERROR_USER_DATA, message);
    }

    public static ArgumentException adaptPropertyException(PropertyException e, AbstractManagedObjectDefinition<?, ?> d) {
        return new ArgumentException(e.getMessageObject());
    }

    public static void displayManagedObjectDecodingException(ConsoleApplication app, ManagedObjectDecodingException e) {
        ManagedObjectDefinition<?, Configuration> d = e.getPartialManagedObject().getManagedObjectDefinition();
        LocalizableMessage ufn = d.getUserFriendlyName();
        LocalizableMessage msg = e.getCauses().size() == 1 ? DsconfigMessages.ERR_GET_HEADING_MODE_SINGLE.get((Object)ufn) : DsconfigMessages.ERR_GET_HEADING_MODE_PLURAL.get((Object)ufn);
        app.errPrintln(msg);
        app.errPrintln();
        TableBuilder builder = new TableBuilder();
        for (PropertyException pe : e.getCauses()) {
            ArgumentException ae = ArgumentExceptionFactory.adaptPropertyException(pe, d);
            builder.startRow();
            builder.appendCell((Object)"*");
            builder.appendCell((Object)ae.getMessage());
        }
        TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setColumnWidth(1, 0);
        printer.setIndentWidth(4);
        builder.print((TablePrinter)printer);
    }

    public static void displayMissingMandatoryPropertyException(ConsoleApplication app, MissingMandatoryPropertiesException e) {
        boolean onePropertyMissing;
        LocalizableMessage ufn = e.getUserFriendlyName();
        boolean bl = onePropertyMissing = e.getCauses().size() == 1;
        LocalizableMessage msg = e.isCreate() ? (onePropertyMissing ? DsconfigMessages.ERR_CREATE_HEADING_MMPE_SINGLE.get((Object)ufn) : DsconfigMessages.ERR_CREATE_HEADING_MMPE_PLURAL.get((Object)ufn)) : (onePropertyMissing ? DsconfigMessages.ERR_MODIFY_HEADING_MMPE_SINGLE.get((Object)ufn) : DsconfigMessages.ERR_MODIFY_HEADING_MMPE_PLURAL.get((Object)ufn));
        app.errPrintln(msg);
        app.errPrintln();
        TableBuilder builder = new TableBuilder();
        builder.addSortKey(0);
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_SYNTAX.get());
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        for (PropertyException pe : e.getCauses()) {
            PropertyDefinition<?> pd = pe.getPropertyDefinition();
            builder.startRow();
            builder.appendCell((Object)pd.getName());
            builder.appendCell((Object)b.getUsage(pd));
        }
        TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
        printer.setDisplayHeadings(true);
        printer.setColumnWidth(1, 0);
        printer.setIndentWidth(4);
        builder.print((TablePrinter)printer);
    }

    public static void displayOperationRejectedException(ConsoleApplication app, OperationRejectedException e) {
        LocalizableMessage msg;
        LocalizableMessage ufn = e.getUserFriendlyName();
        boolean singleMessage = e.getMessages().size() == 1;
        switch (e.getOperationType()) {
            case CREATE: {
                msg = singleMessage ? DsconfigMessages.ERR_DSCFG_ERROR_CREATE_ORE_SINGLE.get((Object)ufn) : DsconfigMessages.ERR_DSCFG_ERROR_CREATE_ORE_PLURAL.get((Object)ufn);
                break;
            }
            case DELETE: {
                msg = singleMessage ? DsconfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_SINGLE.get((Object)ufn) : DsconfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_PLURAL.get((Object)ufn);
                break;
            }
            default: {
                msg = singleMessage ? DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_ORE_SINGLE.get((Object)ufn) : DsconfigMessages.ERR_DSCFG_ERROR_MODIFY_ORE_PLURAL.get((Object)ufn);
            }
        }
        app.errPrintln(msg);
        app.errPrintln();
        TableBuilder builder = new TableBuilder();
        for (LocalizableMessage reason : e.getMessages()) {
            builder.startRow();
            builder.appendCell((Object)"*");
            builder.appendCell((Object)reason);
        }
        TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setColumnWidth(1, 0);
        printer.setIndentWidth(4);
        builder.print((TablePrinter)printer);
    }

    public static ArgumentException incompatiblePropertyModification(String arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_INCOMPATIBLE_PROPERTY_MOD.get((Object)arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingBindPassword(String bindDN) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_PASSWORD.get((Object)bindDN);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingBindPassword(char[] bindDN) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_PASSWORD.get((Object)bindDN);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingMandatoryNonInteractiveArgument(Argument arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_MISSING_NON_INTERACTIVE_ARG.get((Object)arg.getLongIdentifier());
        return new ArgumentException(msg);
    }

    public static ArgumentException missingNameInPropertyArgument(String arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_VALUE.get((Object)arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingNameInPropertyModification(String arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD.get((Object)arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingSeparatorInPropertyArgument(String arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_VALUE.get((Object)arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingSeparatorInPropertyModification(String arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_MOD.get((Object)arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingValueInPropertyArgument(String arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_VALUE_IN_PROPERTY_VALUE.get((Object)arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingValueInPropertyModification(String arg) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD.get((Object)arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException unableToReadConnectionParameters(Exception cause) {
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_CANNOT_READ_CONNECTION_PARAMETERS.get((Object)cause.getMessage());
        return new ArgumentException(message, (Throwable)cause);
    }

    public static ArgumentException unableToReadBindPasswordInteractively() {
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_BIND_PASSWORD_NONINTERACTIVE.get();
        return new ArgumentException(message);
    }

    public static ArgumentException unableToResetMandatoryProperty(AbstractManagedObjectDefinition<?, ?> d, String name, String setOption) {
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_UNABLE_TO_RESET_MANDATORY_PROPERTY.get((Object)d.getUserFriendlyPluralName(), (Object)name, (Object)setOption);
        return new ArgumentException(message);
    }

    public static ArgumentException unableToResetPropertyWithValue(String name, String resetOption) {
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_UNABLE_TO_RESET_PROPERTY_WITH_VALUE.get((Object)resetOption, (Object)name, (Object)resetOption);
        return new ArgumentException(message);
    }

    public static ArgumentException unableToSetNamingProperty(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_UNABLE_TO_SET_NAMING_PROPERTY.get((Object)pd.getName(), (Object)d.getUserFriendlyName());
        return new ArgumentException(message);
    }

    public static ArgumentException unknownCategory(String categoryName) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CATEGORY_UNRECOGNIZED.get((Object)categoryName);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownProperty(AbstractManagedObjectDefinition<?, ?> d, String name) {
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED.get((Object)name, (Object)d.getUserFriendlyPluralName());
        return new ArgumentException(message);
    }

    public static ArgumentException unknownProperty(String name) {
        LocalizableMessage message = DsconfigMessages.ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED_NO_DEFN.get((Object)name);
        return new ArgumentException(message);
    }

    public static ArgumentException unknownSubType(RelationDefinition<?, ?> r, String typeName, String typeUsage) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_SUB_TYPE_UNRECOGNIZED.get((Object)typeName, (Object)r.getUserFriendlyName(), (Object)typeUsage);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownTypeForCategory(String typeName, String categoryName) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CATEGORY_TYPE_UNRECOGNIZED.get((Object)typeName, (Object)categoryName);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownValueForMultiValuedProperty(String value, String propertyName) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_VALUE_DOES_NOT_EXIST.get((Object)value, (Object)propertyName);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownValueForChildComponent(String componentName) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_FINDER_NO_CHILDREN.get((Object)componentName);
        return new ArgumentException(msg);
    }

    public static ClientException wrongManagedObjectType(RelationDefinition<?, ?> r, ManagedObjectDefinition<?, ?> d, String subcommandName) {
        LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_TYPE_UNRECOGNIZED_FOR_SUBCOMMAND.get((Object)d.getUserFriendlyName(), (Object)subcommandName);
        return new ClientException(ReturnCode.ERROR_USER_DATA, msg);
    }

    private ArgumentExceptionFactory() {
    }
}

