/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.BackendCfgClient;
import org.forgerock.opendj.server.config.server.BackendCfg;

public final class BackendCfgDefn
extends ManagedObjectDefinition<BackendCfgClient, BackendCfg> {
    private static final BackendCfgDefn INSTANCE = new BackendCfgDefn();
    private static final StringPropertyDefinition PD_BACKEND_ID;
    private static final DNPropertyDefinition PD_BASE_DN;
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final EnumPropertyDefinition<WritabilityMode> PD_WRITABILITY_MODE;

    public static BackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private BackendCfgDefn() {
        super("backend", TopCfgDefn.getInstance());
    }

    @Override
    public BackendCfgClient createClientConfiguration(ManagedObject<? extends BackendCfgClient> impl) {
        return new BackendCfgClientImpl(impl);
    }

    @Override
    public BackendCfg createServerConfiguration(ServerManagedObject<? extends BackendCfg> impl) {
        return new BackendCfgServerImpl(impl);
    }

    @Override
    public Class<BackendCfg> getServerConfigurationClass() {
        return BackendCfg.class;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return PD_BACKEND_ID;
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return PD_BASE_DN;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<WritabilityMode> getWritabilityModePropertyDefinition() {
        return PD_WRITABILITY_MODE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "backend-id");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-id"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BACKEND_ID = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_ID);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "base-dn");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "base-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BASE_DN);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.Backend");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "writability-mode");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "writability-mode"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(WritabilityMode.class);
        PD_WRITABILITY_MODE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WRITABILITY_MODE);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    private static class BackendCfgServerImpl
    implements BackendCfg {
        private ServerManagedObject<? extends BackendCfg> impl;
        private final String pBackendId;
        private final SortedSet<DN> pBaseDN;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final WritabilityMode pWritabilityMode;

        private BackendCfgServerImpl(ServerManagedObject<? extends BackendCfg> impl) {
            this.impl = impl;
            this.pBackendId = impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pWritabilityMode = impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getBackendId() {
            return this.pBackendId;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public WritabilityMode getWritabilityMode() {
            return this.pWritabilityMode;
        }

        @Override
        public Class<? extends BackendCfg> configurationClass() {
            return BackendCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class BackendCfgClientImpl
    implements BackendCfgClient {
        private ManagedObject<? extends BackendCfgClient> impl;

        private BackendCfgClientImpl(ManagedObject<? extends BackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public WritabilityMode getWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void setWritabilityMode(WritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getWritabilityModePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends BackendCfgClient, ? extends BackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum WritabilityMode {
        DISABLED("disabled"),
        ENABLED("enabled"),
        INTERNAL_ONLY("internal-only");

        private final String name;

        private WritabilityMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

