/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConstraintViolationException;
import org.forgerock.opendj.config.server.ServerManagedObjectDecodingException;
import org.forgerock.opendj.ldap.DN;

final class ConfigExceptionFactory {
    private static final ConfigExceptionFactory INSTANCE = new ConfigExceptionFactory();

    private ConfigExceptionFactory() {
    }

    public static ConfigExceptionFactory getInstance() {
        return INSTANCE;
    }

    public ConfigException createDecodingExceptionAdaptor(DN dn, DefinitionDecodingException e) {
        LocalizableMessage message = ConfigMessages.ERR_ADMIN_MANAGED_OBJECT_DECODING_PROBLEM.get((Object)String.valueOf(dn), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
        return new ConfigException(message, (Throwable)e);
    }

    public ConfigException createDecodingExceptionAdaptor(ServerManagedObjectDecodingException e) {
        DN dn = e.getPartialManagedObject().getDN();
        LocalizableMessage message = ConfigMessages.ERR_ADMIN_MANAGED_OBJECT_DECODING_PROBLEM.get((Object)String.valueOf(dn), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
        return new ConfigException(message, (Throwable)e);
    }

    public ConfigException createDecodingExceptionAdaptor(ConstraintViolationException e) {
        DN dn = e.getManagedObject().getDN();
        LocalizableMessage message = ConfigMessages.ERR_ADMIN_MANAGED_OBJECT_DECODING_PROBLEM.get((Object)String.valueOf(dn), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
        return new ConfigException(message, (Throwable)e);
    }

    public ConfigException createClassLoadingExceptionAdaptor(DN dn, String className, Exception e) {
        LocalizableMessage message = ConfigMessages.ERR_ADMIN_CANNOT_INSTANTIATE_CLASS.get((Object)String.valueOf(className), (Object)String.valueOf(dn), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
        return new ConfigException(message, (Throwable)e);
    }
}

