/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.AddressMask;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.AccessLogFilteringCriteriaCfgClient;
import org.forgerock.opendj.server.config.server.AccessLogFilteringCriteriaCfg;

public final class AccessLogFilteringCriteriaCfgDefn
extends ManagedObjectDefinition<AccessLogFilteringCriteriaCfgClient, AccessLogFilteringCriteriaCfg> {
    private static final AccessLogFilteringCriteriaCfgDefn INSTANCE = new AccessLogFilteringCriteriaCfgDefn();
    private static final IPAddressMaskPropertyDefinition PD_CONNECTION_CLIENT_ADDRESS_EQUAL_TO;
    private static final IPAddressMaskPropertyDefinition PD_CONNECTION_CLIENT_ADDRESS_NOT_EQUAL_TO;
    private static final IntegerPropertyDefinition PD_CONNECTION_PORT_EQUAL_TO;
    private static final StringPropertyDefinition PD_CONNECTION_PROTOCOL_EQUAL_TO;
    private static final EnumPropertyDefinition<LogRecordType> PD_LOG_RECORD_TYPE;
    private static final StringPropertyDefinition PD_REQUEST_TARGET_DN_EQUAL_TO;
    private static final StringPropertyDefinition PD_REQUEST_TARGET_DN_NOT_EQUAL_TO;
    private static final IntegerPropertyDefinition PD_RESPONSE_ETIME_GREATER_THAN;
    private static final IntegerPropertyDefinition PD_RESPONSE_ETIME_LESS_THAN;
    private static final IntegerPropertyDefinition PD_RESPONSE_RESULT_CODE_EQUAL_TO;
    private static final IntegerPropertyDefinition PD_RESPONSE_RESULT_CODE_NOT_EQUAL_TO;
    private static final BooleanPropertyDefinition PD_SEARCH_RESPONSE_IS_INDEXED;
    private static final IntegerPropertyDefinition PD_SEARCH_RESPONSE_NENTRIES_GREATER_THAN;
    private static final IntegerPropertyDefinition PD_SEARCH_RESPONSE_NENTRIES_LESS_THAN;
    private static final StringPropertyDefinition PD_USER_DN_EQUAL_TO;
    private static final StringPropertyDefinition PD_USER_DN_NOT_EQUAL_TO;
    private static final DNPropertyDefinition PD_USER_IS_MEMBER_OF;
    private static final DNPropertyDefinition PD_USER_IS_NOT_MEMBER_OF;

    public static AccessLogFilteringCriteriaCfgDefn getInstance() {
        return INSTANCE;
    }

    private AccessLogFilteringCriteriaCfgDefn() {
        super("access-log-filtering-criteria", TopCfgDefn.getInstance());
    }

    @Override
    public AccessLogFilteringCriteriaCfgClient createClientConfiguration(ManagedObject<? extends AccessLogFilteringCriteriaCfgClient> impl) {
        return new AccessLogFilteringCriteriaCfgClientImpl(impl);
    }

    @Override
    public AccessLogFilteringCriteriaCfg createServerConfiguration(ServerManagedObject<? extends AccessLogFilteringCriteriaCfg> impl) {
        return new AccessLogFilteringCriteriaCfgServerImpl(impl);
    }

    @Override
    public Class<AccessLogFilteringCriteriaCfg> getServerConfigurationClass() {
        return AccessLogFilteringCriteriaCfg.class;
    }

    public IPAddressMaskPropertyDefinition getConnectionClientAddressEqualToPropertyDefinition() {
        return PD_CONNECTION_CLIENT_ADDRESS_EQUAL_TO;
    }

    public IPAddressMaskPropertyDefinition getConnectionClientAddressNotEqualToPropertyDefinition() {
        return PD_CONNECTION_CLIENT_ADDRESS_NOT_EQUAL_TO;
    }

    public IntegerPropertyDefinition getConnectionPortEqualToPropertyDefinition() {
        return PD_CONNECTION_PORT_EQUAL_TO;
    }

    public StringPropertyDefinition getConnectionProtocolEqualToPropertyDefinition() {
        return PD_CONNECTION_PROTOCOL_EQUAL_TO;
    }

    public EnumPropertyDefinition<LogRecordType> getLogRecordTypePropertyDefinition() {
        return PD_LOG_RECORD_TYPE;
    }

    public StringPropertyDefinition getRequestTargetDNEqualToPropertyDefinition() {
        return PD_REQUEST_TARGET_DN_EQUAL_TO;
    }

    public StringPropertyDefinition getRequestTargetDNNotEqualToPropertyDefinition() {
        return PD_REQUEST_TARGET_DN_NOT_EQUAL_TO;
    }

    public IntegerPropertyDefinition getResponseEtimeGreaterThanPropertyDefinition() {
        return PD_RESPONSE_ETIME_GREATER_THAN;
    }

    public IntegerPropertyDefinition getResponseEtimeLessThanPropertyDefinition() {
        return PD_RESPONSE_ETIME_LESS_THAN;
    }

    public IntegerPropertyDefinition getResponseResultCodeEqualToPropertyDefinition() {
        return PD_RESPONSE_RESULT_CODE_EQUAL_TO;
    }

    public IntegerPropertyDefinition getResponseResultCodeNotEqualToPropertyDefinition() {
        return PD_RESPONSE_RESULT_CODE_NOT_EQUAL_TO;
    }

    public BooleanPropertyDefinition getSearchResponseIsIndexedPropertyDefinition() {
        return PD_SEARCH_RESPONSE_IS_INDEXED;
    }

    public IntegerPropertyDefinition getSearchResponseNentriesGreaterThanPropertyDefinition() {
        return PD_SEARCH_RESPONSE_NENTRIES_GREATER_THAN;
    }

    public IntegerPropertyDefinition getSearchResponseNentriesLessThanPropertyDefinition() {
        return PD_SEARCH_RESPONSE_NENTRIES_LESS_THAN;
    }

    public StringPropertyDefinition getUserDNEqualToPropertyDefinition() {
        return PD_USER_DN_EQUAL_TO;
    }

    public StringPropertyDefinition getUserDNNotEqualToPropertyDefinition() {
        return PD_USER_DN_NOT_EQUAL_TO;
    }

    public DNPropertyDefinition getUserIsMemberOfPropertyDefinition() {
        return PD_USER_IS_MEMBER_OF;
    }

    public DNPropertyDefinition getUserIsNotMemberOfPropertyDefinition() {
        return PD_USER_IS_NOT_MEMBER_OF;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IPAddressMaskPropertyDefinition.createBuilder(INSTANCE, "connection-client-address-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "connection-client-address-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_CONNECTION_CLIENT_ADDRESS_EQUAL_TO = (IPAddressMaskPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONNECTION_CLIENT_ADDRESS_EQUAL_TO);
        builder = IPAddressMaskPropertyDefinition.createBuilder(INSTANCE, "connection-client-address-not-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "connection-client-address-not-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_CONNECTION_CLIENT_ADDRESS_NOT_EQUAL_TO = (IPAddressMaskPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONNECTION_CLIENT_ADDRESS_NOT_EQUAL_TO);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "connection-port-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "connection-port-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_CONNECTION_PORT_EQUAL_TO = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONNECTION_PORT_EQUAL_TO);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "connection-protocol-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "connection-protocol-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("[a-zA-Z0-9]+", "NAME");
        PD_CONNECTION_PROTOCOL_EQUAL_TO = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONNECTION_PROTOCOL_EQUAL_TO);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "log-record-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-record-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(LogRecordType.class);
        PD_LOG_RECORD_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_RECORD_TYPE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "request-target-dn-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "request-target-dn-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_REQUEST_TARGET_DN_EQUAL_TO = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REQUEST_TARGET_DN_EQUAL_TO);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "request-target-dn-not-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "request-target-dn-not-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_REQUEST_TARGET_DN_NOT_EQUAL_TO = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REQUEST_TARGET_DN_NOT_EQUAL_TO);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "response-etime-greater-than");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "response-etime-greater-than"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_RESPONSE_ETIME_GREATER_THAN = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RESPONSE_ETIME_GREATER_THAN);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "response-etime-less-than");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "response-etime-less-than"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_RESPONSE_ETIME_LESS_THAN = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RESPONSE_ETIME_LESS_THAN);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "response-result-code-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "response-result-code-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_RESPONSE_RESULT_CODE_EQUAL_TO = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RESPONSE_RESULT_CODE_EQUAL_TO);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "response-result-code-not-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "response-result-code-not-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_RESPONSE_RESULT_CODE_NOT_EQUAL_TO = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RESPONSE_RESULT_CODE_NOT_EQUAL_TO);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "search-response-is-indexed");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "search-response-is-indexed"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_SEARCH_RESPONSE_IS_INDEXED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SEARCH_RESPONSE_IS_INDEXED);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "search-response-nentries-greater-than");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "search-response-nentries-greater-than"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_SEARCH_RESPONSE_NENTRIES_GREATER_THAN = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SEARCH_RESPONSE_NENTRIES_GREATER_THAN);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "search-response-nentries-less-than");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "search-response-nentries-less-than"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_SEARCH_RESPONSE_NENTRIES_LESS_THAN = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SEARCH_RESPONSE_NENTRIES_LESS_THAN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "user-dn-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "user-dn-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_USER_DN_EQUAL_TO = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USER_DN_EQUAL_TO);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "user-dn-not-equal-to");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "user-dn-not-equal-to"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_USER_DN_NOT_EQUAL_TO = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USER_DN_NOT_EQUAL_TO);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "user-is-member-of");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "user-is-member-of"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_USER_IS_MEMBER_OF = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USER_IS_MEMBER_OF);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "user-is-not-member-of");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "user-is-not-member-of"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_USER_IS_NOT_MEMBER_OF = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USER_IS_NOT_MEMBER_OF);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class AccessLogFilteringCriteriaCfgServerImpl
    implements AccessLogFilteringCriteriaCfg {
        private ServerManagedObject<? extends AccessLogFilteringCriteriaCfg> impl;
        private final SortedSet<AddressMask> pConnectionClientAddressEqualTo;
        private final SortedSet<AddressMask> pConnectionClientAddressNotEqualTo;
        private final SortedSet<Integer> pConnectionPortEqualTo;
        private final SortedSet<String> pConnectionProtocolEqualTo;
        private final SortedSet<LogRecordType> pLogRecordType;
        private final SortedSet<String> pRequestTargetDNEqualTo;
        private final SortedSet<String> pRequestTargetDNNotEqualTo;
        private final Integer pResponseEtimeGreaterThan;
        private final Integer pResponseEtimeLessThan;
        private final SortedSet<Integer> pResponseResultCodeEqualTo;
        private final SortedSet<Integer> pResponseResultCodeNotEqualTo;
        private final Boolean pSearchResponseIsIndexed;
        private final Integer pSearchResponseNentriesGreaterThan;
        private final Integer pSearchResponseNentriesLessThan;
        private final SortedSet<String> pUserDNEqualTo;
        private final SortedSet<String> pUserDNNotEqualTo;
        private final SortedSet<DN> pUserIsMemberOf;
        private final SortedSet<DN> pUserIsNotMemberOf;

        private AccessLogFilteringCriteriaCfgServerImpl(ServerManagedObject<? extends AccessLogFilteringCriteriaCfg> impl) {
            this.impl = impl;
            this.pConnectionClientAddressEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getConnectionClientAddressEqualToPropertyDefinition());
            this.pConnectionClientAddressNotEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getConnectionClientAddressNotEqualToPropertyDefinition());
            this.pConnectionPortEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getConnectionPortEqualToPropertyDefinition());
            this.pConnectionProtocolEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getConnectionProtocolEqualToPropertyDefinition());
            this.pLogRecordType = impl.getPropertyValues(INSTANCE.getLogRecordTypePropertyDefinition());
            this.pRequestTargetDNEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getRequestTargetDNEqualToPropertyDefinition());
            this.pRequestTargetDNNotEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getRequestTargetDNNotEqualToPropertyDefinition());
            this.pResponseEtimeGreaterThan = impl.getPropertyValue(INSTANCE.getResponseEtimeGreaterThanPropertyDefinition());
            this.pResponseEtimeLessThan = impl.getPropertyValue(INSTANCE.getResponseEtimeLessThanPropertyDefinition());
            this.pResponseResultCodeEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getResponseResultCodeEqualToPropertyDefinition());
            this.pResponseResultCodeNotEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getResponseResultCodeNotEqualToPropertyDefinition());
            this.pSearchResponseIsIndexed = impl.getPropertyValue(INSTANCE.getSearchResponseIsIndexedPropertyDefinition());
            this.pSearchResponseNentriesGreaterThan = impl.getPropertyValue(INSTANCE.getSearchResponseNentriesGreaterThanPropertyDefinition());
            this.pSearchResponseNentriesLessThan = impl.getPropertyValue(INSTANCE.getSearchResponseNentriesLessThanPropertyDefinition());
            this.pUserDNEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getUserDNEqualToPropertyDefinition());
            this.pUserDNNotEqualTo = impl.getPropertyValues((PropertyDefinition)INSTANCE.getUserDNNotEqualToPropertyDefinition());
            this.pUserIsMemberOf = impl.getPropertyValues((PropertyDefinition)INSTANCE.getUserIsMemberOfPropertyDefinition());
            this.pUserIsNotMemberOf = impl.getPropertyValues((PropertyDefinition)INSTANCE.getUserIsNotMemberOfPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<AddressMask> getConnectionClientAddressEqualTo() {
            return this.pConnectionClientAddressEqualTo;
        }

        @Override
        public SortedSet<AddressMask> getConnectionClientAddressNotEqualTo() {
            return this.pConnectionClientAddressNotEqualTo;
        }

        @Override
        public SortedSet<Integer> getConnectionPortEqualTo() {
            return this.pConnectionPortEqualTo;
        }

        @Override
        public SortedSet<String> getConnectionProtocolEqualTo() {
            return this.pConnectionProtocolEqualTo;
        }

        @Override
        public SortedSet<LogRecordType> getLogRecordType() {
            return this.pLogRecordType;
        }

        @Override
        public SortedSet<String> getRequestTargetDNEqualTo() {
            return this.pRequestTargetDNEqualTo;
        }

        @Override
        public SortedSet<String> getRequestTargetDNNotEqualTo() {
            return this.pRequestTargetDNNotEqualTo;
        }

        @Override
        public Integer getResponseEtimeGreaterThan() {
            return this.pResponseEtimeGreaterThan;
        }

        @Override
        public Integer getResponseEtimeLessThan() {
            return this.pResponseEtimeLessThan;
        }

        @Override
        public SortedSet<Integer> getResponseResultCodeEqualTo() {
            return this.pResponseResultCodeEqualTo;
        }

        @Override
        public SortedSet<Integer> getResponseResultCodeNotEqualTo() {
            return this.pResponseResultCodeNotEqualTo;
        }

        @Override
        public Boolean isSearchResponseIsIndexed() {
            return this.pSearchResponseIsIndexed;
        }

        @Override
        public Integer getSearchResponseNentriesGreaterThan() {
            return this.pSearchResponseNentriesGreaterThan;
        }

        @Override
        public Integer getSearchResponseNentriesLessThan() {
            return this.pSearchResponseNentriesLessThan;
        }

        @Override
        public SortedSet<String> getUserDNEqualTo() {
            return this.pUserDNEqualTo;
        }

        @Override
        public SortedSet<String> getUserDNNotEqualTo() {
            return this.pUserDNNotEqualTo;
        }

        @Override
        public SortedSet<DN> getUserIsMemberOf() {
            return this.pUserIsMemberOf;
        }

        @Override
        public SortedSet<DN> getUserIsNotMemberOf() {
            return this.pUserIsNotMemberOf;
        }

        @Override
        public Class<? extends AccessLogFilteringCriteriaCfg> configurationClass() {
            return AccessLogFilteringCriteriaCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class AccessLogFilteringCriteriaCfgClientImpl
    implements AccessLogFilteringCriteriaCfgClient {
        private ManagedObject<? extends AccessLogFilteringCriteriaCfgClient> impl;

        private AccessLogFilteringCriteriaCfgClientImpl(ManagedObject<? extends AccessLogFilteringCriteriaCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<AddressMask> getConnectionClientAddressEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getConnectionClientAddressEqualToPropertyDefinition());
        }

        @Override
        public void setConnectionClientAddressEqualTo(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getConnectionClientAddressEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<AddressMask> getConnectionClientAddressNotEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getConnectionClientAddressNotEqualToPropertyDefinition());
        }

        @Override
        public void setConnectionClientAddressNotEqualTo(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getConnectionClientAddressNotEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<Integer> getConnectionPortEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getConnectionPortEqualToPropertyDefinition());
        }

        @Override
        public void setConnectionPortEqualTo(Collection<Integer> values) {
            this.impl.setPropertyValues(INSTANCE.getConnectionPortEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getConnectionProtocolEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getConnectionProtocolEqualToPropertyDefinition());
        }

        @Override
        public void setConnectionProtocolEqualTo(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getConnectionProtocolEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<LogRecordType> getLogRecordType() {
            return this.impl.getPropertyValues(INSTANCE.getLogRecordTypePropertyDefinition());
        }

        @Override
        public void setLogRecordType(Collection<LogRecordType> values) {
            this.impl.setPropertyValues(INSTANCE.getLogRecordTypePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRequestTargetDNEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getRequestTargetDNEqualToPropertyDefinition());
        }

        @Override
        public void setRequestTargetDNEqualTo(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRequestTargetDNEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRequestTargetDNNotEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getRequestTargetDNNotEqualToPropertyDefinition());
        }

        @Override
        public void setRequestTargetDNNotEqualTo(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRequestTargetDNNotEqualToPropertyDefinition(), values);
        }

        @Override
        public Integer getResponseEtimeGreaterThan() {
            return this.impl.getPropertyValue(INSTANCE.getResponseEtimeGreaterThanPropertyDefinition());
        }

        @Override
        public void setResponseEtimeGreaterThan(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getResponseEtimeGreaterThanPropertyDefinition(), value);
        }

        @Override
        public Integer getResponseEtimeLessThan() {
            return this.impl.getPropertyValue(INSTANCE.getResponseEtimeLessThanPropertyDefinition());
        }

        @Override
        public void setResponseEtimeLessThan(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getResponseEtimeLessThanPropertyDefinition(), value);
        }

        @Override
        public SortedSet<Integer> getResponseResultCodeEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getResponseResultCodeEqualToPropertyDefinition());
        }

        @Override
        public void setResponseResultCodeEqualTo(Collection<Integer> values) {
            this.impl.setPropertyValues(INSTANCE.getResponseResultCodeEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<Integer> getResponseResultCodeNotEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getResponseResultCodeNotEqualToPropertyDefinition());
        }

        @Override
        public void setResponseResultCodeNotEqualTo(Collection<Integer> values) {
            this.impl.setPropertyValues(INSTANCE.getResponseResultCodeNotEqualToPropertyDefinition(), values);
        }

        @Override
        public Boolean isSearchResponseIsIndexed() {
            return this.impl.getPropertyValue(INSTANCE.getSearchResponseIsIndexedPropertyDefinition());
        }

        @Override
        public void setSearchResponseIsIndexed(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSearchResponseIsIndexedPropertyDefinition(), value);
        }

        @Override
        public Integer getSearchResponseNentriesGreaterThan() {
            return this.impl.getPropertyValue(INSTANCE.getSearchResponseNentriesGreaterThanPropertyDefinition());
        }

        @Override
        public void setSearchResponseNentriesGreaterThan(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getSearchResponseNentriesGreaterThanPropertyDefinition(), value);
        }

        @Override
        public Integer getSearchResponseNentriesLessThan() {
            return this.impl.getPropertyValue(INSTANCE.getSearchResponseNentriesLessThanPropertyDefinition());
        }

        @Override
        public void setSearchResponseNentriesLessThan(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getSearchResponseNentriesLessThanPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getUserDNEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getUserDNEqualToPropertyDefinition());
        }

        @Override
        public void setUserDNEqualTo(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getUserDNEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getUserDNNotEqualTo() {
            return this.impl.getPropertyValues(INSTANCE.getUserDNNotEqualToPropertyDefinition());
        }

        @Override
        public void setUserDNNotEqualTo(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getUserDNNotEqualToPropertyDefinition(), values);
        }

        @Override
        public SortedSet<DN> getUserIsMemberOf() {
            return this.impl.getPropertyValues(INSTANCE.getUserIsMemberOfPropertyDefinition());
        }

        @Override
        public void setUserIsMemberOf(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getUserIsMemberOfPropertyDefinition(), values);
        }

        @Override
        public SortedSet<DN> getUserIsNotMemberOf() {
            return this.impl.getPropertyValues(INSTANCE.getUserIsNotMemberOfPropertyDefinition());
        }

        @Override
        public void setUserIsNotMemberOf(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getUserIsNotMemberOfPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends AccessLogFilteringCriteriaCfgClient, ? extends AccessLogFilteringCriteriaCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum LogRecordType {
        ABANDON("abandon"),
        ADD("add"),
        BIND("bind"),
        COMPARE("compare"),
        CONNECT("connect"),
        DELETE("delete"),
        DISCONNECT("disconnect"),
        EXTENDED("extended"),
        MODIFY("modify"),
        RENAME("rename"),
        SEARCH("search"),
        UNBIND("unbind");

        private final String name;

        private LogRecordType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

