/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import com.forgerock.opendj.ldap.config.AdminMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.DecodingException;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.server.AbstractConfigListenerAdaptor;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConstraintViolationException;
import org.forgerock.opendj.config.server.DNBuilder;
import org.forgerock.opendj.config.server.ServerConstraintHandler;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.config.server.ServerManagedObjectChangeListener;
import org.forgerock.opendj.config.server.ServerManagementContext;
import org.forgerock.opendj.config.server.spi.ConfigChangeListener;
import org.forgerock.opendj.config.server.spi.ConfigDeleteListener;
import org.forgerock.opendj.config.server.spi.ConfigurationRepository;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ResultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigChangeListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigChangeListener {
    private static final Logger debugLogger = LoggerFactory.getLogger(ConfigChangeListenerAdaptor.class);
    private static final LocalizedLogger adminLogger = LocalizedLogger.getLocalizedLogger((String)AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DOES_NOT_EXIST.get((Object)"").resourceName());
    private ServerManagedObject<? extends S> cachedManagedObject;
    private final ConfigDeleteListener cleanerListener;
    private final Set<DN> dependencies;
    private final ConfigChangeListener dependencyListener;
    private final DN dn;
    private final ServerManagedObjectChangeListener<? super S> listener;
    private final ManagedObjectPath<?, S> path;
    private final ConfigurationRepository configRepository;
    private final ServerManagementContext serverContext;

    public ConfigChangeListenerAdaptor(ServerManagementContext serverContext, ManagedObjectPath<?, S> path, ServerManagedObjectChangeListener<? super S> listener) {
        Entry configEntry;
        this.serverContext = serverContext;
        this.configRepository = serverContext.getConfigRepository();
        this.path = path;
        this.dn = DNBuilder.create(path);
        this.listener = listener;
        this.cachedManagedObject = null;
        this.dependencies = new HashSet<DN>();
        this.dependencyListener = new ConfigChangeListener(){

            @Override
            public ConfigChangeResult applyConfigurationChange(Entry configEntry) {
                Entry dependentConfigEntry = ConfigChangeListenerAdaptor.this.getConfigEntry(ConfigChangeListenerAdaptor.this.dn);
                if (dependentConfigEntry != null) {
                    return ConfigChangeListenerAdaptor.this.applyConfigurationChange(dependentConfigEntry);
                }
                ConfigChangeListenerAdaptor.this.configRepository.deregisterChangeListener(configEntry.getName(), this);
                return new ConfigChangeResult();
            }

            @Override
            public boolean configChangeIsAcceptable(Entry configEntry, LocalizableMessageBuilder unacceptableReason) {
                Entry dependentConfigEntry = ConfigChangeListenerAdaptor.this.getConfigEntry(ConfigChangeListenerAdaptor.this.dn);
                if (dependentConfigEntry != null) {
                    return ConfigChangeListenerAdaptor.this.configChangeIsAcceptable(dependentConfigEntry, unacceptableReason, configEntry);
                }
                ConfigChangeListenerAdaptor.this.configRepository.deregisterChangeListener(configEntry.getName(), this);
                return true;
            }
        };
        AbstractManagedObjectDefinition<?, S> d = path.getManagedObjectDefinition();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            Visitor.find(path, pd, this.dependencies);
        }
        for (DN entryDN : this.dependencies) {
            Entry configEntry2;
            if (entryDN.equals((Object)this.dn) || (configEntry2 = this.getConfigEntry(entryDN)) == null) continue;
            this.configRepository.registerChangeListener(configEntry2.getName(), this.dependencyListener);
        }
        this.cleanerListener = new ConfigDeleteListener(){

            @Override
            public ConfigChangeResult applyConfigurationDelete(Entry configEntry) {
                if (configEntry.getName().equals((Object)ConfigChangeListenerAdaptor.this.dn)) {
                    ConfigChangeListenerAdaptor.this.finalizeChangeListener();
                }
                return new ConfigChangeResult();
            }

            @Override
            public boolean configDeleteIsAcceptable(Entry configEntry, LocalizableMessageBuilder unacceptableReason) {
                return true;
            }
        };
        DN parent = this.dn.parent();
        if (parent != null && (configEntry = this.getConfigEntry(this.dn.parent())) != null) {
            this.configRepository.registerDeleteListener(configEntry.getName(), this.cleanerListener);
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(Entry configEntry) {
        this.cachedManagedObject.setConfigDN(configEntry.getName());
        ConfigChangeResult result = this.listener.applyConfigurationChange(this.cachedManagedObject);
        if (result.getResultCode() == ResultCode.SUCCESS) {
            ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
            for (Constraint constraint : d.getAllConstraints()) {
                for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                    try {
                        handler.performPostModify(this.cachedManagedObject);
                    }
                    catch (ConfigException e) {
                        debugLogger.trace("Unable to perform post modify", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean configChangeIsAcceptable(Entry configEntry, LocalizableMessageBuilder unacceptableReason) {
        return this.configChangeIsAcceptable(configEntry, unacceptableReason, configEntry);
    }

    public boolean configChangeIsAcceptable(Entry configEntry, LocalizableMessageBuilder unacceptableReason, Entry newConfigEntry) {
        try {
            this.cachedManagedObject = this.serverContext.decode(this.path, configEntry, newConfigEntry);
        }
        catch (DecodingException e) {
            unacceptableReason.append(e.getMessageObject());
            return false;
        }
        try {
            this.cachedManagedObject.ensureIsUsable();
        }
        catch (ConstraintViolationException e) {
            this.generateUnacceptableReason(e.getMessages(), unacceptableReason);
            return false;
        }
        LinkedList<LocalizableMessage> reasons = new LinkedList<LocalizableMessage>();
        if (this.listener.isConfigurationChangeAcceptable(this.cachedManagedObject, reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    public void finalizeChangeListener() {
        for (DN dependency : this.dependencies) {
            Entry listenerConfigEntry = this.getConfigEntry(dependency);
            if (listenerConfigEntry == null) continue;
            this.configRepository.deregisterChangeListener(listenerConfigEntry.getName(), this.dependencyListener);
        }
        Entry parentConfigEntry = this.getConfigEntry(this.dn.parent());
        if (parentConfigEntry != null) {
            this.configRepository.deregisterDeleteListener(parentConfigEntry.getName(), this.cleanerListener);
        }
    }

    ServerManagedObjectChangeListener<? super S> getServerManagedObjectChangeListener() {
        return this.listener;
    }

    private Entry getConfigEntry(DN dn) {
        try {
            if (this.configRepository.hasEntry(dn)) {
                return this.configRepository.getEntry(dn);
            }
            adminLogger.error(AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DOES_NOT_EXIST, (Object)String.valueOf(dn));
        }
        catch (ConfigException e) {
            debugLogger.trace("The dependent entry could not be retrieved", (Throwable)e);
            adminLogger.error(AdminMessages.ERR_ADMIN_CANNOT_GET_MANAGED_OBJECT, (Object)String.valueOf(dn), (Object)StaticUtils.getExceptionMessage((Throwable)e));
        }
        return null;
    }

    private static final class Visitor<T>
    implements DefaultBehaviorProviderVisitor<T, Void, ManagedObjectPath<?, ?>> {
        private final Collection<DN> dependencies;

        public static <T> void find(ManagedObjectPath<?, ?> path, PropertyDefinition<T> pd, Collection<DN> dependencies) {
            Visitor<T> v = new Visitor<T>(dependencies);
            DefaultBehaviorProvider<T> db = pd.getDefaultBehaviorProvider();
            db.accept(v, path);
        }

        private Visitor(Collection<DN> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public Void visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            ManagedObjectPath<?, ?> next = d.getManagedObjectPath();
            this.dependencies.add(DNBuilder.create(next));
            String propertyName = d.getPropertyName();
            AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
            PropertyDefinition<?> pd = mod.getPropertyDefinition(propertyName);
            Visitor.find(next, pd, this.dependencies);
            return null;
        }

        @Override
        public Void visitAlias(AliasDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }

        @Override
        public Void visitDefined(DefinedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }

        @Override
        public Void visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            ManagedObjectPath<?, ?> next = d.getManagedObjectPath(p);
            this.dependencies.add(DNBuilder.create(next));
            String propertyName = d.getPropertyName();
            AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
            PropertyDefinition<?> pd = mod.getPropertyDefinition(propertyName);
            Visitor.find(next, pd, this.dependencies);
            return null;
        }

        @Override
        public Void visitUndefined(UndefinedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }
    }
}

