/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefaultManagedObject;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelationDefinitionVisitor;

public final class SetRelationDefinition<C extends ConfigurationClient, S extends Configuration>
extends RelationDefinition<C, S> {
    private final String pluralName;
    private final Map<String, DefaultManagedObject<? extends C, ? extends S>> defaultManagedObjects;

    private SetRelationDefinition(RelationDefinition.Common<C, S> common, String pluralName, Map<String, DefaultManagedObject<? extends C, ? extends S>> defaultManagedObjects) {
        super(common);
        this.pluralName = pluralName;
        this.defaultManagedObjects = defaultManagedObjects;
    }

    @Override
    public <R, P> R accept(RelationDefinitionVisitor<R, P> v, P p) {
        return v.visitSet(this, p);
    }

    public DefaultManagedObject<? extends C, ? extends S> getDefaultManagedObject(String name) {
        if (!this.defaultManagedObjects.containsKey(name)) {
            throw new IllegalArgumentException("unrecognized default managed object \"" + name + "\"");
        }
        return this.defaultManagedObjects.get(name);
    }

    public Set<String> getDefaultManagedObjectNames() {
        return Collections.unmodifiableSet(this.defaultManagedObjects.keySet());
    }

    public String getPluralName() {
        return this.pluralName;
    }

    public LocalizableMessage getUserFriendlyPluralName() {
        return this.getUserFriendlyPluralName(Locale.getDefault());
    }

    public LocalizableMessage getUserFriendlyPluralName(Locale locale) {
        String property = "relation." + this.getName() + ".user-friendly-plural-name";
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this.getParentDefinition(), property, locale);
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("name=");
        builder.append(this.getName());
        builder.append(" type=set parent=");
        builder.append(this.getParentDefinition().getName());
        builder.append(" child=");
        builder.append(this.getChildDefinition().getName());
    }

    @Override
    protected void initialize() throws Exception {
        for (DefaultManagedObject<C, S> dmo : this.defaultManagedObjects.values()) {
            dmo.initialize();
        }
    }

    public static final class Builder<C extends ConfigurationClient, S extends Configuration>
    extends RelationDefinition.AbstractBuilder<C, S, SetRelationDefinition<C, S>> {
        private final String pluralName;
        private final Map<String, DefaultManagedObject<? extends C, ? extends S>> defaultManagedObjects = new HashMap<String, DefaultManagedObject<? extends C, ? extends S>>();

        public Builder(AbstractManagedObjectDefinition<?, ?> pd, String name, String pluralName, AbstractManagedObjectDefinition<C, S> cd) {
            super(pd, name, cd);
            this.pluralName = pluralName;
        }

        public void setDefaultManagedObject(DefaultManagedObject<? extends C, ? extends S> defaultManagedObject) {
            this.defaultManagedObjects.put(defaultManagedObject.getManagedObjectDefinition().getName(), defaultManagedObject);
        }

        @Override
        protected SetRelationDefinition<C, S> buildInstance(RelationDefinition.Common<C, S> common) {
            return new SetRelationDefinition(common, this.pluralName, this.defaultManagedObjects);
        }
    }
}

