/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.ldap.AddressMask;
import org.forgerock.util.Reject;

public final class IPAddressMaskPropertyDefinition
extends PropertyDefinition<AddressMask> {
    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private IPAddressMaskPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<AddressMask> defaultBehavior) {
        super(d, AddressMask.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public void validateValue(AddressMask value) {
        Reject.ifNull((Object)value);
    }

    @Override
    public AddressMask decodeValue(String value) {
        Reject.ifNull((Object)value);
        try {
            return AddressMask.valueOf((String)value);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitIPAddressMask(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, AddressMask value, P p) {
        return v.visitIPAddressMask(this, value, p);
    }

    @Override
    public int compare(AddressMask o1, AddressMask o2) {
        return o1.toString().compareTo(o2.toString());
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<AddressMask, IPAddressMaskPropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected IPAddressMaskPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<AddressMask> defaultBehavior) {
            return new IPAddressMaskPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

