/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommandBuilder;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.Closeable;
import javax.net.ssl.SSLException;
import org.forgerock.opendj.config.LDAPProfile;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.ldap.LDAPManagementContext;
import org.forgerock.opendj.config.dsconfig.BuildVersion;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.util.Utils;

public final class LDAPManagementContextFactory {
    private ManagementContext context;
    private CommandBuilder contextCommandBuilder;
    private final ConnectionFactoryProvider provider;
    private final ConnectionFactory factory;

    public LDAPManagementContextFactory(ConnectionFactoryProvider cfp) throws ArgumentException {
        this.provider = cfp;
        this.factory = cfp.getAuthenticatedConnectionFactory();
    }

    public void close() {
        Utils.closeSilently((Closeable[])new Closeable[]{this.context});
    }

    public CommandBuilder getContextCommandBuilder() {
        return this.contextCommandBuilder;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagementContext getManagementContext(ConsoleApplication app) throws ArgumentException, ClientException {
        if (this.context == null) {
            Connection connection;
            String hostName = this.provider.getHostname();
            int port = this.provider.getPort();
            try {
                connection = this.factory.getConnection();
                BuildVersion.checkVersionMismatch(connection);
            }
            catch (LdapException e) {
                try {
                    if (e.getCause() instanceof SSLException) {
                        throw new ClientException(ReturnCode.CLIENT_SIDE_CONNECT_ERROR, DsconfigMessages.ERR_FAILED_TO_CONNECT_NOT_TRUSTED.get((Object)hostName, (Object)String.valueOf(port)));
                    }
                    throw new ClientException(ReturnCode.CLIENT_SIDE_CONNECT_ERROR, DsconfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get((Object)hostName, (Object)String.valueOf(port)));
                    catch (ConfigException e2) {
                        throw new ClientException(ReturnCode.ERROR_USER_DATA, e2.getMessageObject());
                    }
                    catch (Exception ex) {
                        throw new ClientException(ReturnCode.CLIENT_SIDE_CONNECT_ERROR, DsconfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get((Object)hostName, (Object)port));
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeSilently((Closeable[])new Closeable[]{this.factory});
                    throw throwable;
                }
            }
            Utils.closeSilently((Closeable[])new Closeable[]{this.factory});
            this.context = LDAPManagementContext.newManagementContext(connection, LDAPProfile.getInstance());
        }
        return this.context;
    }
}

