/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.client.ClientConstraintHandler;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.conditions.Condition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ServerConstraintHandler;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.LdapException;

public class GenericConstraint
extends Constraint {
    private final ClientConstraintHandler clientHandler = new ClientHandler();
    private final Condition condition;
    private final AbstractManagedObjectDefinition<?, ?> definition;
    private final int id;
    private final ServerConstraintHandler serverHandler = new ServerHandler();

    public GenericConstraint(AbstractManagedObjectDefinition<?, ?> definition, int id, Condition condition) {
        this.definition = definition;
        this.id = id;
        this.condition = condition;
    }

    @Override
    public Collection<ClientConstraintHandler> getClientConstraintHandlers() {
        return Collections.singleton(this.clientHandler);
    }

    @Override
    public Collection<ServerConstraintHandler> getServerConstraintHandlers() {
        return Collections.singleton(this.serverHandler);
    }

    public final LocalizableMessage getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final LocalizableMessage getSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "constraint." + this.id + ".synopsis";
        return resource.getMessage(this.definition, property, locale);
    }

    @Override
    protected void initialize() throws Exception {
        this.condition.initialize(this.definition);
    }

    private final class ServerHandler
    extends ServerConstraintHandler {
        private ServerHandler() {
        }

        @Override
        public boolean isUsable(ServerManagedObject<?> managedObject, Collection<LocalizableMessage> unacceptableReasons) throws ConfigException {
            if (!GenericConstraint.this.condition.evaluate(managedObject)) {
                unacceptableReasons.add(GenericConstraint.this.getSynopsis());
                return false;
            }
            return true;
        }
    }

    private final class ClientHandler
    extends ClientConstraintHandler {
        private ClientHandler() {
        }

        @Override
        public boolean isAddAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<LocalizableMessage> unacceptableReasons) throws LdapException {
            if (!GenericConstraint.this.condition.evaluate(context, managedObject)) {
                unacceptableReasons.add(GenericConstraint.this.getSynopsis());
                return false;
            }
            return true;
        }

        @Override
        public boolean isModifyAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<LocalizableMessage> unacceptableReasons) throws LdapException {
            if (!GenericConstraint.this.condition.evaluate(context, managedObject)) {
                unacceptableReasons.add(GenericConstraint.this.getSynopsis());
                return false;
            }
            return true;
        }
    }
}

