/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentGroup;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocGenerationHelper;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandUsageHandler;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.util.OperatingSystem;
import com.forgerock.opendj.util.StaticUtils;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;

public class SubCommandArgumentParser
extends ArgumentParser {
    private static final String INDENT = "    ";
    private static final int COLUMN_ADJUST = OperatingSystem.isWindows() ? 1 : 0;
    private final Map<Argument, Collection<SubCommand>> usageGroupArguments = new HashMap<Argument, Collection<SubCommand>>();
    private final Map<Character, Argument> globalShortIDMap = new HashMap<Character, Argument>();
    private final Map<String, Argument> globalLongIDMap = new HashMap<String, Argument>();
    private final Map<String, Argument> globalArgumentMap = new HashMap<String, Argument>();
    private final List<Argument> globalArgumentList = new LinkedList<Argument>();
    private final SortedMap<String, SubCommand> subCommands = new TreeMap<String, SubCommand>();
    private SubCommand subCommand;
    private SubCommandUsageHandler subCommandUsageHandler;

    public SubCommandArgumentParser(String mainClassName, LocalizableMessage toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
    }

    public boolean hasGlobalArgument(String argumentName) {
        return this.globalArgumentMap.containsKey(argumentName);
    }

    public Argument getGlobalArgumentForShortID(Character shortID) {
        return this.globalShortIDMap.get(shortID);
    }

    public Argument getGlobalArgumentForLongID(String longID) {
        return this.globalLongIDMap.get(longID);
    }

    public boolean hasSubCommand(String name) {
        return this.subCommands.containsKey(name);
    }

    public SubCommand getSubCommand(String name) {
        return (SubCommand)this.subCommands.get(name);
    }

    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    public void addGlobalArgument(Argument argument) throws ArgumentException {
        this.addGlobalArgument(argument, null);
    }

    @Override
    public void addLdapConnectionArgument(Argument argument) throws ArgumentException {
        this.addGlobalArgument(argument, null);
    }

    public void addGlobalArgument(Argument argument, ArgumentGroup group) throws ArgumentException {
        String longID = argument.getLongIdentifier();
        if (this.globalArgumentMap.containsKey(longID)) {
            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_DUPLICATE_GLOBAL_ARG_NAME.get((Object)longID));
        }
        for (SubCommand s : this.subCommands.values()) {
            if (s.getArgumentForLongIdentifier(longID) == null) continue;
            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_NAME_SUBCMD_CONFLICT.get((Object)longID, (Object)s.getName()));
        }
        Character shortID = argument.getShortIdentifier();
        if (shortID != null) {
            if (this.globalShortIDMap.containsKey(shortID)) {
                String conflictingLongID = this.globalShortIDMap.get(shortID).getLongIdentifier();
                throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_DUPLICATE_GLOBAL_ARG_SHORT_ID.get((Object)shortID, (Object)longID, (Object)conflictingLongID));
            }
            for (SubCommand s : this.subCommands.values()) {
                if (s.getArgument(shortID) == null) continue;
                String conflictingLongID = s.getArgument(shortID).getLongIdentifier();
                throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_SHORT_ID_CONFLICT.get((Object)shortID, (Object)longID, (Object)conflictingLongID, (Object)s.getName()));
            }
        }
        if (!this.longArgumentsCaseSensitive() && this.globalLongIDMap.containsKey(longID = StaticUtils.toLowerCase((String)longID))) {
            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_DUPLICATE_GLOBAL_ARG_LONG_ID.get((Object)longID));
        }
        for (SubCommand s : this.subCommands.values()) {
            if (s.getArgument(longID) == null) continue;
            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_GLOBAL_ARG_LONG_ID_CONFLICT.get((Object)longID, (Object)s.getName()));
        }
        if (shortID != null) {
            this.globalShortIDMap.put(shortID, argument);
        }
        if (longID != null) {
            this.globalLongIDMap.put(longID, argument);
        }
        this.globalArgumentList.add(argument);
        if (group == null) {
            group = this.getStandardGroup(argument);
        }
        group.addArgument(argument);
        this.argumentGroups.add(group);
    }

    @Override
    public void setUsageArgument(Argument argument, OutputStream outputStream) {
        super.setUsageArgument(argument, outputStream);
        this.usageGroupArguments.put(argument, Collections.emptySet());
    }

    public void setUsageGroupArgument(Argument argument, Collection<SubCommand> subCommands) {
        this.usageGroupArguments.put(argument, subCommands);
    }

    public void setUsageHandler(SubCommandUsageHandler subCommandUsageHandler) {
        this.subCommandUsageHandler = subCommandUsageHandler;
    }

    @Override
    public void parseArguments(String[] rawArguments, Properties argumentProperties) throws ArgumentException {
        this.subCommand = null;
        ArrayList<String> trailingArguments = this.getTrailingArguments();
        trailingArguments.clear();
        this.setUsageOrVersionDisplayed(false);
        boolean inTrailingArgs = false;
        int numArguments = rawArguments.length;
        for (int i = 0; i < numArguments; ++i) {
            SubCommand sc;
            String argValue;
            String arg = rawArguments[i];
            if (inTrailingArgs) {
                trailingArguments.add(arg);
                if (this.subCommand == null) {
                    throw new ArgumentException(CliMessages.ERR_ARG_SUBCOMMAND_INVALID.get());
                }
                if (this.subCommand.getMaxTrailingArguments() <= 0 || trailingArguments.size() <= this.subCommand.getMaxTrailingArguments()) continue;
                throw new ArgumentException(CliMessages.ERR_ARGPARSER_TOO_MANY_TRAILING_ARGS.get((Object)this.subCommand.getMaxTrailingArguments()));
            }
            if (arg.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (arg.startsWith("--")) {
                Argument a;
                String argName = arg.substring(2);
                argValue = null;
                int equalPos = argName.indexOf(61);
                if (equalPos >= 0) {
                    if (equalPos == 0) {
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_LONG_ARG_WITHOUT_NAME.get((Object)arg));
                    }
                    argValue = argName.substring(equalPos + 1);
                    argName = argName.substring(0, equalPos);
                }
                String origArgName = argName;
                if (!this.longArgumentsCaseSensitive()) {
                    argName = StaticUtils.toLowerCase((String)argName);
                }
                if ((a = this.globalLongIDMap.get(argName)) == null) {
                    if (this.subCommand != null) {
                        a = this.subCommand.getArgument(argName);
                    }
                    if (a == null) {
                        if ("help".equals(argName)) {
                            this.writeToUsageOutputStream(this.getUsage());
                            return;
                        }
                        if ("version".equals(argName)) {
                            this.printVersion();
                            return;
                        }
                        if (this.subCommand != null) {
                            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_LONG_ID.get((Object)origArgName));
                        }
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_ARGUMENT_FOR_LONG_ID.get((Object)origArgName));
                    }
                }
                a.setPresent(true);
                if (this.usageGroupArguments.containsKey(a)) {
                    this.getUsage(a);
                    return;
                }
                if (a.needsValue()) {
                    LocalizableMessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_VALUE_FOR_ARGUMENT_WITH_LONG_ID.get((Object)argName));
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new LocalizableMessageBuilder())) {
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_VALUE_UNACCEPTABLE_FOR_LONG_ID.get((Object)argValue, (Object)argName, (Object)invalidReason));
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NOT_MULTIVALUED_FOR_LONG_ID.get((Object)origArgName));
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_ARG_FOR_LONG_ID_DOESNT_TAKE_VALUE.get((Object)origArgName));
            }
            if (arg.equals("-")) {
                throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_INVALID_DASH_AS_ARGUMENT.get());
            }
            if (arg.startsWith("-")) {
                char argCharacter = arg.charAt(1);
                argValue = arg.length() > 2 ? arg.substring(2) : null;
                Argument a = this.globalShortIDMap.get(Character.valueOf(argCharacter));
                if (a == null) {
                    if (this.subCommand == null) {
                        if (argCharacter == '?') {
                            this.writeToUsageOutputStream(this.getUsage());
                            if (this.getUsageArgument() != null) {
                                this.getUsageArgument().setPresent(true);
                            }
                            return;
                        }
                        if (argCharacter == 'V') {
                            if (this.dashVAccepted()) {
                                this.printVersion();
                                return;
                            }
                            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                        }
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                    }
                    a = this.subCommand.getArgument(Character.valueOf(argCharacter));
                    if (a == null) {
                        if (argCharacter == '?') {
                            this.writeToUsageOutputStream(this.getUsage());
                            return;
                        }
                        if (argCharacter == 'V') {
                            if (this.dashVAccepted()) {
                                this.printVersion();
                                return;
                            }
                        } else {
                            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_ARGUMENT_FOR_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                        }
                    }
                }
                a.setPresent(true);
                if (this.usageGroupArguments.containsKey(a)) {
                    this.getUsage(a);
                    return;
                }
                if (a.needsValue()) {
                    LocalizableMessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_VALUE_FOR_ARGUMENT_WITH_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new LocalizableMessageBuilder())) {
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_VALUE_UNACCEPTABLE_FOR_SHORT_ID.get((Object)argValue, (Object)Character.valueOf(argCharacter), (Object)invalidReason));
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NOT_MULTIVALUED_FOR_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                int valueLength = argValue.length();
                for (int j = 0; j < valueLength; ++j) {
                    char c = argValue.charAt(j);
                    Argument b = this.globalShortIDMap.get(Character.valueOf(c));
                    if (b == null) {
                        if (this.subCommand == null) {
                            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_GLOBAL_ARGUMENT_FOR_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                        }
                        b = this.subCommand.getArgument(Character.valueOf(c));
                        if (b == null) {
                            throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_NO_ARGUMENT_FOR_SHORT_ID.get((Object)Character.valueOf(argCharacter)));
                        }
                    }
                    if (b.needsValue()) {
                        throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_CANT_MIX_ARGS_WITH_VALUES.get((Object)Character.valueOf(argCharacter), (Object)argValue, (Object)Character.valueOf(c)));
                    }
                    b.setPresent(true);
                    if (!this.usageGroupArguments.containsKey(b)) continue;
                    this.getUsage(b);
                    return;
                }
                continue;
            }
            if (this.subCommand != null) {
                if (this.subCommand.allowsTrailingArguments()) {
                    trailingArguments.add(arg);
                    inTrailingArgs = true;
                    continue;
                }
                throw new ArgumentException(CliMessages.ERR_ARGPARSER_DISALLOWED_TRAILING_ARGUMENT.get((Object)arg));
            }
            String nameToCheck = arg;
            if (!this.longArgumentsCaseSensitive()) {
                nameToCheck = StaticUtils.toLowerCase((String)arg);
            }
            if ((sc = (SubCommand)this.subCommands.get(nameToCheck)) == null) {
                throw new ArgumentException(CliMessages.ERR_SUBCMDPARSER_INVALID_ARGUMENT.get((Object)arg));
            }
            this.subCommand = sc;
        }
        if (this.subCommand != null) {
            int minTrailingArguments = this.subCommand.getMinTrailingArguments();
            if (this.subCommand.allowsTrailingArguments() && minTrailingArguments > 0 && trailingArguments.size() < minTrailingArguments) {
                throw new ArgumentException(CliMessages.ERR_ARGPARSER_TOO_FEW_TRAILING_ARGUMENTS.get((Object)minTrailingArguments));
            }
        }
        if (argumentProperties == null) {
            argumentProperties = this.checkExternalProperties();
        }
        this.normalizeArguments(argumentProperties, this.globalArgumentList);
        if (this.subCommand != null) {
            this.normalizeArguments(argumentProperties, this.subCommand.getArguments());
        }
    }

    private boolean dashVAccepted() {
        if (this.globalShortIDMap.containsKey(Character.valueOf('V'))) {
            return false;
        }
        for (SubCommand subCmd : this.subCommands.values()) {
            if (subCmd.getArgument(Character.valueOf('V')) == null) continue;
            return false;
        }
        return true;
    }

    public void getSubCommandUsage(StringBuilder buffer, SubCommand subCommand) {
        buffer.append((CharSequence)this.getLocalizableScriptName());
        buffer.append(" ");
        buffer.append(subCommand.getName());
        buffer.append(" ").append((CharSequence)CliMessages.INFO_SUBCMDPARSER_OPTIONS.get());
        if (subCommand.allowsTrailingArguments()) {
            buffer.append(' ');
            buffer.append(subCommand.getTrailingArgumentsDisplayName());
        }
        buffer.append(StaticUtils.EOL);
        this.wrap(buffer, subCommand.getDescription());
        buffer.append(StaticUtils.EOL);
        if (!this.globalArgumentList.isEmpty()) {
            buffer.append(StaticUtils.EOL);
            buffer.append((CharSequence)CliMessages.INFO_GLOBAL_OPTIONS.get());
            buffer.append(StaticUtils.EOL);
            buffer.append(INDENT);
            buffer.append((CharSequence)CliMessages.INFO_GLOBAL_OPTIONS_REFERENCE.get((Object)this.getScriptNameOrJava()));
            buffer.append(StaticUtils.EOL);
        }
        if (!subCommand.getArguments().isEmpty()) {
            buffer.append(StaticUtils.EOL);
            buffer.append((CharSequence)CliMessages.INFO_SUBCMD_OPTIONS.get());
            buffer.append(StaticUtils.EOL);
        }
        for (Argument a : subCommand.getArguments()) {
            if (a.isHidden()) continue;
            this.printLineForShortLongArgument(a, buffer);
            this.indentAndWrap(buffer, INDENT, a.getDescription());
            if (!a.needsValue() || a.getDefaultValue() == null || a.getDefaultValue().length() <= 0) continue;
            this.indentAndWrap(buffer, INDENT, CliMessages.INFO_ARGPARSER_USAGE_DEFAULT_VALUE.get((Object)a.getDefaultValue()));
        }
    }

    @Override
    public String getUsage() {
        this.setUsageOrVersionDisplayed(true);
        StringBuilder buffer = new StringBuilder();
        if (this.subCommand == null) {
            if (System.getProperty("org.forgerock.opendj.gendoc") != null) {
                this.generateReferenceDoc(buffer, this.subCommands.values());
            } else if (this.usageGroupArguments.size() > 1) {
                this.getFullUsage(Collections.emptySet(), true, buffer);
            } else {
                this.getFullUsage(this.subCommands.values(), true, buffer);
            }
        } else {
            this.getSubCommandUsage(buffer, this.subCommand);
        }
        return buffer.toString();
    }

    void addSubCommand(SubCommand subCommand) {
        this.subCommands.put(StaticUtils.toLowerCase((String)subCommand.getName()), subCommand);
    }

    private void getUsage(Argument a) {
        this.setUsageOrVersionDisplayed(true);
        StringBuilder buffer = new StringBuilder();
        boolean isUsageArgument = this.isUsageArgument(a);
        if (isUsageArgument && this.subCommand != null) {
            this.getSubCommandUsage(buffer, this.subCommand);
        } else if (isUsageArgument && this.usageGroupArguments.size() <= 1) {
            this.getFullUsage(this.subCommands.values(), true, buffer);
        } else if (isUsageArgument) {
            this.getFullUsage(Collections.emptySet(), true, buffer);
        } else {
            this.getFullUsage(this.usageGroupArguments.get(a), false, buffer);
        }
        this.writeToUsageOutputStream(buffer);
    }

    private void getFullUsage(Collection<SubCommand> c, boolean showGlobalOptions, StringBuilder buffer) {
        LocalizableMessage toolDescription = this.getToolDescription();
        if (toolDescription != null && toolDescription.length() > 0) {
            buffer.append(Utils.wrapText(toolDescription, Utils.MAX_LINE_WIDTH - 1));
            buffer.append(StaticUtils.EOL).append(StaticUtils.EOL);
        }
        buffer.append((CharSequence)CliMessages.INFO_ARGPARSER_USAGE.get());
        buffer.append("  ");
        buffer.append(this.getScriptNameOrJava());
        if (this.subCommands.isEmpty()) {
            buffer.append(" ").append((CharSequence)CliMessages.INFO_SUBCMDPARSER_OPTIONS.get());
        } else {
            buffer.append(" ").append((CharSequence)CliMessages.INFO_SUBCMDPARSER_SUBCMD_AND_OPTIONS.get());
        }
        if (!this.subCommands.isEmpty()) {
            buffer.append(StaticUtils.EOL);
            buffer.append(StaticUtils.EOL);
            if (c.isEmpty()) {
                buffer.append((CharSequence)CliMessages.INFO_SUBCMDPARSER_SUBCMD_HELP_HEADING.get());
            } else {
                buffer.append((CharSequence)CliMessages.INFO_SUBCMDPARSER_SUBCMD_HEADING.get());
            }
            buffer.append(StaticUtils.EOL);
        }
        if (c.isEmpty()) {
            for (Argument argument : this.globalArgumentList) {
                if (argument.isHidden() || !this.usageGroupArguments.containsKey(argument) || this.isUsageArgument(argument)) continue;
                this.printArgumentUsage(argument, buffer);
            }
        } else {
            boolean isFirst = true;
            for (SubCommand sc : c) {
                if (sc.isHidden()) continue;
                if (isFirst) {
                    buffer.append(StaticUtils.EOL);
                }
                buffer.append(sc.getName());
                buffer.append(StaticUtils.EOL);
                this.indentAndWrap(buffer, INDENT, sc.getDescription());
                buffer.append(StaticUtils.EOL);
                isFirst = false;
            }
        }
        buffer.append(StaticUtils.EOL);
        if (showGlobalOptions) {
            if (this.subCommands.isEmpty()) {
                buffer.append((CharSequence)CliMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
            } else {
                buffer.append((CharSequence)CliMessages.INFO_SUBCMDPARSER_GLOBAL_HEADING.get());
            }
            buffer.append(StaticUtils.EOL).append(StaticUtils.EOL);
            boolean printGroupHeaders = this.printUsageGroupHeaders();
            for (ArgumentGroup argGroup : this.argumentGroups) {
                LocalizableMessage groupDesc;
                if (argGroup.containsArguments() && printGroupHeaders && (groupDesc = argGroup.getDescription()) != null && !LocalizableMessage.EMPTY.equals((Object)groupDesc)) {
                    buffer.append(StaticUtils.EOL);
                    buffer.append(Utils.wrapText(groupDesc.toString(), Utils.MAX_LINE_WIDTH - 1));
                    buffer.append(StaticUtils.EOL).append(StaticUtils.EOL);
                }
                for (Argument a : argGroup.getArguments()) {
                    if (a.isHidden() || this.usageGroupArguments.containsKey(a)) continue;
                    this.printArgumentUsage(a, buffer);
                }
            }
            Argument argument = this.getUsageArgument();
            if (argument != null) {
                this.printArgumentUsage(argument, buffer);
            } else {
                buffer.append("-?");
            }
            buffer.append(StaticUtils.EOL);
        }
    }

    private void printArgumentUsage(Argument a, StringBuilder buffer) {
        LocalizableMessage pHolder;
        String value = a.needsValue() ? ((pHolder = a.getValuePlaceholder()) != null ? " " + pHolder : " {value}") : "";
        Argument usageArgument = this.getUsageArgument();
        Character shortIDChar = a.getShortIdentifier();
        if (shortIDChar != null) {
            if (a.equals(usageArgument)) {
                buffer.append("-?, ");
            }
            buffer.append("-");
            buffer.append(shortIDChar);
            String longIDString = a.getLongIdentifier();
            if (longIDString != null) {
                buffer.append(", --");
                buffer.append(longIDString);
            }
            buffer.append(value);
        } else {
            String longIDString = a.getLongIdentifier();
            if (longIDString != null) {
                if (a.equals(usageArgument)) {
                    buffer.append("-?, ");
                }
                buffer.append("--");
                buffer.append(longIDString);
                buffer.append(value);
            }
        }
        buffer.append(StaticUtils.EOL);
        this.indentAndWrap(buffer, INDENT, a.getDescription());
        if (a.needsValue() && a.getDefaultValue() != null && a.getDefaultValue().length() > 0) {
            this.indentAndWrap(buffer, INDENT, CliMessages.INFO_ARGPARSER_USAGE_DEFAULT_VALUE.get((Object)a.getDefaultValue()));
        }
    }

    private void wrap(StringBuilder buffer, LocalizableMessage text) {
        this.indentAndWrap(buffer, "", text);
    }

    private void indentAndWrap(StringBuilder buffer, String indent, LocalizableMessage text) {
        int actualSize = Utils.MAX_LINE_WIDTH - indent.length() - COLUMN_ADJUST;
        SubCommandArgumentParser.indentAndWrap(indent, buffer, actualSize, text);
    }

    static void indentAndWrap(String indent, StringBuilder buffer, int actualSize, LocalizableMessage text) {
        if (text.length() <= actualSize) {
            buffer.append(indent);
            buffer.append((CharSequence)text);
            buffer.append(StaticUtils.EOL);
        } else {
            String s = text.toString();
            while (s.length() > actualSize) {
                int spacePos = s.lastIndexOf(32, actualSize);
                if (spacePos == -1) {
                    spacePos = s.indexOf(32);
                }
                if (spacePos == -1) {
                    buffer.append(indent).append(s).append(StaticUtils.EOL);
                    return;
                }
                buffer.append(indent);
                buffer.append(s.substring(0, spacePos).trim());
                s = s.substring(spacePos + 1).trim();
                buffer.append(StaticUtils.EOL);
            }
            if (s.length() > 0) {
                buffer.append(indent).append(s).append(StaticUtils.EOL);
            }
        }
    }

    private void generateReferenceDoc(StringBuilder builder, Collection<SubCommand> subCommands) {
        this.toRefEntry(builder, subCommands);
    }

    @Override
    String getSynopsisArgs() {
        if (this.subCommands.isEmpty()) {
            return CliMessages.INFO_SUBCMDPARSER_OPTIONS.get().toString();
        }
        return CliMessages.INFO_SUBCMDPARSER_SUBCMD_AND_OPTIONS.get().toString();
    }

    void toRefEntry(StringBuilder builder, Collection<SubCommand> subCommands) {
        String scriptName = this.getScriptName();
        if (scriptName == null) {
            throw new RuntimeException("The script name should have been set via the environment property 'com.forgerock.opendj.ldap.tools.scriptName'.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("locale", Locale.getDefault().getLanguage());
        map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
        map.put("name", scriptName);
        map.put("shortDesc", this.getShortToolDescription());
        map.put("descTitle", CliMessages.REF_TITLE_DESCRIPTION.get());
        map.put("args", this.getSynopsisArgs());
        map.put("description", this.eolToNewPara(this.getToolDescription()));
        map.put("info", this.getDocToolDescriptionSupplement());
        if (!this.globalArgumentList.isEmpty()) {
            map.put("optionSection", this.getOptionsRefSect1(scriptName));
        }
        map.put("subcommands", this.toRefSect1(scriptName, subCommands));
        map.put("trailingSectionString", System.getProperty("org.forgerock.opendj.gendoc.trailing"));
        DocGenerationHelper.applyTemplate(builder, "refEntry.ftl", map);
        if (scriptName.equals("dsconfig")) {
            this.appendSubCommandPages(builder, scriptName, subCommands);
        }
    }

    private String toRefSect1(String scriptName, Collection<SubCommand> subCommands) {
        if (subCommands.isEmpty()) {
            return "";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", scriptName);
        map.put("title", CliMessages.REF_TITLE_SUBCOMMANDS.get());
        map.put("info", this.getDocSubcommandsDescriptionSupplement());
        map.put("intro", CliMessages.REF_INTRO_SUBCOMMANDS.get((Object)scriptName));
        if (scriptName.equals("dsconfig")) {
            map.put("isItemizedList", true);
        }
        ArrayList<String> scUsageList = new ArrayList<String>();
        for (SubCommand subCommand : subCommands) {
            if (subCommand.isHidden()) continue;
            if (scriptName.equals("dsconfig")) {
                scUsageList.add(this.getSubCommandListItem(scriptName, subCommand));
                continue;
            }
            scUsageList.add(this.toRefSect2(scriptName, subCommand));
        }
        map.put("subcommands", scUsageList);
        StringBuilder sb = new StringBuilder();
        DocGenerationHelper.applyTemplate(sb, "refSect1.ftl", map);
        return sb.toString();
    }

    private String getSubCommandListItem(String scriptName, SubCommand subCommand) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", scriptName + "-" + subCommand.getName());
        map.put("name", scriptName + " " + subCommand.getName());
        map.put("description", this.eolToNewPara(subCommand.getDescription()));
        StringBuilder sb = new StringBuilder();
        DocGenerationHelper.applyTemplate(sb, "dscfgListItem.ftl", map);
        return sb.toString();
    }

    private String toRefSect2(String scriptName, SubCommand subCommand) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", scriptName + "-" + subCommand.getName());
        String name = scriptName + " " + subCommand.getName();
        map.put("name", name);
        map.put("description", this.eolToNewPara(subCommand.getDescription()));
        map.put("optionsTitle", CliMessages.REF_TITLE_OPTIONS.get());
        map.put("optionsIntro", CliMessages.REF_INTRO_OPTIONS.get((Object)name));
        map.put("info", subCommand.getDocDescriptionSupplement());
        this.setSubCommandOptionsInfo(map, subCommand);
        StringBuilder sb = new StringBuilder();
        DocGenerationHelper.applyTemplate(sb, "refSect2.ftl", map);
        return sb.toString();
    }

    private void setSubCommandOptionsInfo(Map<String, Object> map, SubCommand subCommand) {
        if (!subCommand.getArguments().isEmpty()) {
            LinkedList options = new LinkedList();
            String nameOption = null;
            for (Argument a : subCommand.getArguments()) {
                if (a.isHidden()) continue;
                HashMap<String, Object> option = new HashMap<String, Object>();
                String optionSynopsis = DocGenerationHelper.getOptionSynopsis(a);
                option.put("synopsis", optionSynopsis);
                option.put("description", this.eolToNewPara(a.getDescription()));
                HashMap<String, String> info = new HashMap<String, String>();
                if (this.subCommandUsageHandler != null) {
                    if (!DocGenerationHelper.doesHandleProperties(a)) {
                        nameOption = "<option>" + optionSynopsis + "</option>";
                    }
                    info.put("usage", this.subCommandUsageHandler.getArgumentAdditionalInfo(subCommand, a, nameOption));
                } else {
                    String defaultValue = this.isHostNameArgument(a) ? "localhost.localdomain" : a.getDefaultValue();
                    info.put("default", (String)(defaultValue != null ? CliMessages.REF_DEFAULT.get((Object)defaultValue) : null));
                    info.put("doc", (String)a.getDocDescriptionSupplement());
                }
                option.put("info", info);
                options.add(option);
            }
            map.put("options", options);
        }
        if (this.subCommandUsageHandler != null) {
            map.put("propertiesInfo", this.subCommandUsageHandler.getProperties(subCommand));
        }
    }

    private void appendSubCommandPages(StringBuilder builder, String scriptName, Collection<SubCommand> subCommands) {
        for (SubCommand subCommand : subCommands) {
            if (subCommand.isHidden()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("marker", "@@@" + scriptName + "-" + subCommand.getName() + "@@@");
            map.put("locale", Locale.getDefault().getLanguage());
            map.put("year", new SimpleDateFormat("yyyy").format(new Date()));
            map.put("id", scriptName + "-" + subCommand.getName());
            map.put("name", scriptName + " " + subCommand.getName());
            map.put("purpose", this.eolToNewPara(subCommand.getDescription()));
            map.put("args", CliMessages.INFO_SUBCMDPARSER_OPTIONS.get());
            map.put("descTitle", CliMessages.REF_TITLE_DESCRIPTION.get());
            map.put("description", this.eolToNewPara(subCommand.getDescription()));
            map.put("info", subCommand.getDocDescriptionSupplement());
            map.put("optionsTitle", CliMessages.REF_TITLE_OPTIONS.get());
            map.put("optionsIntro", CliMessages.REF_INTRO_OPTIONS.get((Object)(scriptName + " " + subCommand.getName())));
            this.setSubCommandOptionsInfo(map, subCommand);
            DocGenerationHelper.applyTemplate(builder, "dscfgSubcommand.ftl", map);
        }
        this.appendSubCommandReference(builder, scriptName, subCommands);
    }

    private void appendSubCommandReference(StringBuilder builder, String scriptName, Collection<SubCommand> subCommands) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("marker", "@@@" + scriptName + "-subcommands-ref@@@");
        map.put("name", scriptName);
        map.put("locale", Locale.getDefault().getLanguage());
        map.put("title", CliMessages.REF_PART_TITLE_SUBCOMMANDS.get((Object)scriptName));
        map.put("partintro", CliMessages.REF_PART_INTRO_SUBCOMMANDS.get((Object)scriptName));
        LinkedList commands = new LinkedList();
        for (SubCommand subCommand : subCommands) {
            HashMap<String, String> scMap = new HashMap<String, String>();
            scMap.put("id", scriptName + "-" + subCommand.getName());
            commands.add(scMap);
        }
        map.put("subcommands", commands);
        DocGenerationHelper.applyTemplate(builder, "dscfgReference.ftl", map);
    }

    @Override
    public void replaceArgument(Argument argument) {
        this.replaceArgumentInCollections(this.globalLongIDMap, this.globalShortIDMap, this.globalArgumentList, argument);
    }
}

