/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;

public final class BooleanArgument
extends Argument {
    public static Builder builder(String longIdentifier) {
        return new Builder(longIdentifier);
    }

    private BooleanArgument(Builder builder) throws ArgumentException {
        super(builder);
    }

    @Override
    public final void addValue(String valueString) {
        if (valueString != null) {
            this.clearValues();
            super.addValue(valueString);
            super.setPresent(Boolean.valueOf(valueString));
        }
    }

    @Override
    public final void setPresent(boolean isPresent) {
        this.addValue(String.valueOf(isPresent));
    }

    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        invalidReason.append(CliMessages.ERR_BOOLEANARG_NO_VALUE_ALLOWED.get((Object)this.longIdentifier));
        return false;
    }

    public static final class Builder
    extends Argument.ArgumentBuilder<Builder, Boolean, BooleanArgument> {
        private Builder(String longIdentifier) {
            super(longIdentifier);
            this.needsValue = false;
            this.defaultValue = false;
        }

        @Override
        Builder getThis() {
            return this;
        }

        @Override
        public BooleanArgument buildArgument() throws ArgumentException {
            return new BooleanArgument(this);
        }
    }
}

