/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ConsoleApplication;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class MultiColumnPrinter {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int numCol = 2;
    private int gap = 4;
    private int align = 1;
    private int titleAlign = 1;
    private String border;
    private final List<String[]> titleTable = new Vector<String[]>();
    private final List<int[]> titleSpanTable = new Vector<int[]>();
    private final int[] curLength;
    private final ConsoleApplication app;

    public MultiColumnPrinter(int numCol, int gap, ConsoleApplication app) {
        this(numCol, gap, null, 0, app);
    }

    public MultiColumnPrinter(int numCol, int gap, String border, ConsoleApplication app) {
        this(numCol, gap, border, 0, app);
    }

    public MultiColumnPrinter(int numCol, int gap, String border, int align, ConsoleApplication app) {
        this.curLength = new int[numCol];
        this.numCol = numCol;
        this.gap = gap;
        this.border = border;
        this.align = align;
        this.titleAlign = 0;
        this.app = app;
    }

    public void addTitle(String[] row) {
        if (row == null) {
            return;
        }
        int[] span = new int[row.length];
        for (int i = 0; i < row.length; ++i) {
            span[i] = 1;
        }
        this.addTitle(row, span);
    }

    public void addTitle(String[] row, int[] span) {
        this.titleTable.add(Arrays.copyOf(row, row.length));
        this.titleSpanTable.add(span);
    }

    public void clearTitle() {
        this.titleTable.clear();
        this.titleSpanTable.clear();
    }

    public void printRow(String ... row) {
        for (int i = 0; i < this.numCol; ++i) {
            if (this.titleAlign == 2) {
                int spaceBefore = this.curLength[i] - row[i].length();
                this.printSpaces(spaceBefore);
                this.app.getOutputStream().print(row[i]);
                if (i >= this.numCol - 1) continue;
                this.printSpaces(this.gap);
                continue;
            }
            if (this.align == 1) {
                int space1 = (this.curLength[i] - row[i].length()) / 2;
                int space2 = this.curLength[i] - row[i].length() - space1;
                this.printSpaces(space1);
                this.app.getOutputStream().print(row[i]);
                this.printSpaces(space2);
                if (i >= this.numCol - 1) continue;
                this.printSpaces(this.gap);
                continue;
            }
            this.app.getOutputStream().print(row[i]);
            if (i >= this.numCol - 1) continue;
            this.printSpaces(this.curLength[i] - row[i].length() + this.gap);
        }
        this.app.getOutputStream().println("");
    }

    public void printTitle() {
        int span;
        int i;
        int[] curSpan;
        Iterator<int[]> spanEnum = this.titleSpanTable.iterator();
        for (String[] row : this.titleTable) {
            curSpan = spanEnum.next();
            for (i = 0; i < this.numCol; ++i) {
                if (row[i] == null) {
                    row[i] = "-";
                }
                int len = row[i].length();
                span = curSpan[i];
                int rem = 0;
                if (span > 1) {
                    rem = len % span;
                    len /= span;
                }
                if (this.curLength[i] >= len) continue;
                this.curLength[i] = len;
                if (span <= 1 || i + span > this.numCol) continue;
                for (int j = i + 1; j < i + span; ++j) {
                    this.curLength[j] = len;
                }
                int n = i + span - 1;
                this.curLength[n] = this.curLength[n] + rem;
            }
        }
        this.printBorder();
        spanEnum = this.titleSpanTable.iterator();
        for (String[] row : this.titleTable) {
            curSpan = spanEnum.next();
            for (i = 0; i < this.numCol; ++i) {
                int spaceBefore;
                int availableSpace = 0;
                span = curSpan[i];
                if (span == 0) continue;
                availableSpace = this.curLength[i];
                if (span > 1 && i + span <= this.numCol) {
                    for (int j = i + 1; j < i + span; ++j) {
                        availableSpace += this.gap;
                        availableSpace += this.curLength[j];
                    }
                }
                if (this.titleAlign == 2) {
                    spaceBefore = availableSpace - row[i].length();
                    this.printSpaces(spaceBefore);
                    this.app.getOutputStream().print(row[i]);
                    if (i >= this.numCol - 1) continue;
                    this.printSpaces(this.gap);
                    continue;
                }
                if (this.titleAlign == 1) {
                    spaceBefore = (availableSpace - row[i].length()) / 2;
                    int spaceAfter = availableSpace - row[i].length() - spaceBefore;
                    this.printSpaces(spaceBefore);
                    this.app.getOutputStream().print(row[i]);
                    this.printSpaces(spaceAfter);
                    if (i >= this.numCol - 1) continue;
                    this.printSpaces(this.gap);
                    continue;
                }
                this.app.getOutputStream().print(row[i]);
                if (i >= this.numCol - 1) continue;
                this.printSpaces(availableSpace - row[i].length() + this.gap);
            }
            this.app.getOutputStream().println("");
        }
        this.printBorder();
    }

    public void setTitleAlign(int titleAlign) {
        this.titleAlign = titleAlign;
    }

    private void printBorder() {
        int j;
        int i;
        if (this.border == null) {
            return;
        }
        for (i = 0; i < this.numCol; ++i) {
            for (j = 0; j < this.curLength[i]; ++j) {
                this.app.getOutputStream().print(this.border);
            }
        }
        for (i = 0; i < this.numCol - 1; ++i) {
            for (j = 0; j < this.gap; ++j) {
                this.app.getOutputStream().print(this.border);
            }
        }
        this.app.getOutputStream().println("");
    }

    private void printSpaces(int count) {
        for (int i = 0; i < count; ++i) {
            this.app.getOutputStream().print(" ");
        }
    }
}

